/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ButtonsTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_addButton_1() throws Exception {
        this.check_addButton(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "  }", "}"}, new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "    {", "      Button button = new Button(shell, SWT.NONE);", "      button.setText(\"New Button\");", "    }", "  }", "}"}, null);
    }

    @Test
    public void test_addButton_2() throws Exception {
        this.check_addButton(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "  }", "}"}, new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "    {", "      Button button = new Button(shell, SWT.NONE);", "    }", "  }", "}"}, "no-such-creationId");
    }

    @Test
    public void test_addCheckButton() throws Exception {
        this.check_addButton(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "  }", "}"}, new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "    {", "      Button button = new Button(shell, SWT.CHECK);", "      button.setText(\"Check Button\");", "    }", "  }", "}"}, "check");
    }

    @Test
    public void test_addRadioButton() throws Exception {
        this.check_addButton(new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "  }", "}"}, new String[]{"class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setSize(320, 240);", "    shell.setLayout(new FillLayout());", "    {", "      Button button = new Button(shell, SWT.RADIO);", "      button.setText(\"Radio Button\");", "    }", "  }", "}"}, "radio");
    }

    private void check_addButton(String[] lines, String[] expected, String creationId) throws Exception {
        CompositeInfo shell = this.parseComposite(lines);
        FillLayoutInfo layout = (FillLayoutInfo)shell.getLayout();
        ControlInfo button = (ControlInfo)ButtonsTest.createJavaInfo("org.eclipse.swt.widgets.Button", creationId);
        ButtonsTest.assertEquals((Object)"org.eclipse.swt.widgets.Button", (Object)button.getDescription().getComponentClass().getName());
        layout.command_CREATE(button, null);
        this.assertEditor(expected);
    }

    @Test
    public void test_ButtonStylePresentation() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Button(this, SWT.NONE);", "    new Button(this, SWT.PUSH);", "    new Button(this, SWT.CHECK);", "    new Button(this, SWT.RADIO);", "  }", "}");
        shell.refresh();
        ButtonInfo buttonDefault = (ButtonInfo)shell.getChildrenControls().get(0);
        ButtonInfo buttonPush = (ButtonInfo)shell.getChildrenControls().get(1);
        ButtonInfo buttonCheck = (ButtonInfo)shell.getChildrenControls().get(2);
        ButtonInfo buttonRadio = (ButtonInfo)shell.getChildrenControls().get(3);
        ButtonsTest.assertSame((Object)buttonDefault.getPresentation().getIcon(), (Object)buttonPush.getPresentation().getIcon());
        ButtonsTest.assertNotSame((Object)buttonPush.getPresentation().getIcon(), (Object)buttonRadio.getPresentation().getIcon());
        ButtonsTest.assertNotSame((Object)buttonPush.getPresentation().getIcon(), (Object)buttonCheck.getPresentation().getIcon());
        ButtonsTest.assertNotSame((Object)buttonRadio.getPresentation().getIcon(), (Object)buttonCheck.getPresentation().getIcon());
    }

    @Test
    public void test_ButtonStylePresentation_cacheIcons() throws Exception {
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Button button_1 = new Button(this, SWT.CHECK);", "    Button button_2 = new Button(this, SWT.CHECK);", "  }", "}");
        this.refresh();
        ButtonInfo button_1 = (ButtonInfo)ButtonsTest.getJavaInfoByName("button_1");
        ButtonInfo button_2 = (ButtonInfo)ButtonsTest.getJavaInfoByName("button_2");
        ButtonsTest.assertSame((Object)button_1.getPresentation().getIcon(), (Object)button_2.getPresentation().getIcon());
    }
}

