/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.spring;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentAttachmentInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.spring.SpringLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.junit.Test;

public class SpringLayoutTest
extends AbstractLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new SpringLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutTest.assertNoErrors((JavaInfo)panel);
        SpringLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new SpringLayout())/ /add(button)/}", "  {new: javax.swing.SpringLayout} {empty} {/setLayout(new SpringLayout())/}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
        SpringLayoutTest.assertInstanceOf(SpringLayoutInfo.class, (Object)panel.getLayout());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Rectangle modelBounds = button.getModelBounds();
        SpringLayoutTest.assertEquals((long)modelBounds.x, (long)0L);
        SpringLayoutTest.assertEquals((long)modelBounds.y, (long)0L);
    }

    @Test
    public void test_putConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Rectangle modelBounds = button.getModelBounds();
        SpringLayoutTest.assertEquals((long)modelBounds.x, (long)5L);
        SpringLayoutTest.assertEquals((long)modelBounds.y, (long)10L);
    }

    @Test
    public void test_putConstraints_beforeAdd() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutTest.assertNoErrors((JavaInfo)panel);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Rectangle modelBounds = button.getModelBounds();
        SpringLayoutTest.assertEquals((long)modelBounds.x, (long)5L);
        SpringLayoutTest.assertEquals((long)modelBounds.y, (long)10L);
    }

    @Test
    public void test_getAttachment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringLayoutTest.assertFalse((boolean)layout.getAttachmentLeft(button).isVirtual());
        SpringLayoutTest.assertFalse((boolean)layout.getAttachmentTop(button).isVirtual());
        SpringLayoutTest.assertTrue((boolean)layout.getAttachmentRight(button).isVirtual());
        SpringLayoutTest.assertTrue((boolean)layout.getAttachmentBottom(button).isVirtual());
    }

    @Test
    public void test_isVirtual() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringLayoutTest.assertTrue((boolean)layout.isAttached((IAbstractComponentInfo)button, 1));
        SpringLayoutTest.assertTrue((boolean)layout.isAttached((IAbstractComponentInfo)button, 8));
        SpringLayoutTest.assertFalse((boolean)layout.isAttached((IAbstractComponentInfo)button, 4));
        SpringLayoutTest.assertFalse((boolean)layout.isAttached((IAbstractComponentInfo)button, 32));
    }

    @Test
    public void test_getAttachedToWidget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final JButton button_1 = new JButton();", "  private final JButton button_2 = new JButton();", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      add(button_1);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "    }", "    {", "      add(button_2);", "      layout.putConstraint(SpringLayout.WEST, button_2, 5, SpringLayout.EAST, button_1);", "      layout.putConstraint(SpringLayout.NORTH, button_2, 0, SpringLayout.NORTH, button_1);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        SpringLayoutTest.assertSame(null, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_1, 1));
        SpringLayoutTest.assertSame(null, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_1, 8));
        SpringLayoutTest.assertSame(null, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_1, 4));
        SpringLayoutTest.assertSame(null, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_1, 32));
        SpringLayoutTest.assertSame((Object)button_1, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_2, 1));
        SpringLayoutTest.assertSame((Object)button_1, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_2, 8));
        SpringLayoutTest.assertSame(null, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_2, 4));
        SpringLayoutTest.assertSame(null, (Object)layout.getAttachedToWidget((IAbstractComponentInfo)button_2, 32));
    }

    @Test
    public void test_getComponentAttachmentInfo_parent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.EAST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentAttachmentInfo attachment = layout.getComponentAttachmentInfo((IAbstractComponentInfo)button, 1);
        SpringLayoutTest.assertNull((Object)attachment);
        attachment = layout.getComponentAttachmentInfo((IAbstractComponentInfo)button, 8);
        SpringLayoutTest.assertNull((Object)attachment);
    }

    @Test
    public void test_getComponentAttachmentInfo() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    JButton targetButton = new JButton();", "    add(targetButton);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.EAST, targetButton);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, targetButton);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo targetButton = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        ComponentAttachmentInfo attachment = layout.getComponentAttachmentInfo((IAbstractComponentInfo)button, 1);
        SpringLayoutTest.assertNotNull((Object)attachment);
        SpringLayoutTest.assertSame((Object)targetButton, (Object)attachment.getTarget());
        SpringLayoutTest.assertEquals((long)4L, (long)attachment.getAlignment());
        attachment = layout.getComponentAttachmentInfo((IAbstractComponentInfo)button, 8);
        SpringLayoutTest.assertNotNull((Object)attachment);
        SpringLayoutTest.assertSame((Object)targetButton, (Object)attachment.getTarget());
        SpringLayoutTest.assertEquals((long)8L, (long)attachment.getAlignment());
        attachment = layout.getComponentAttachmentInfo((IAbstractComponentInfo)button, 4);
        SpringLayoutTest.assertNull((Object)attachment);
    }

    @Test
    public void test_property_constraints() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints");
        SpringLayoutTest.assertNotNull((Object)property);
        SpringLayoutTest.assertTrue((boolean)property.isModified());
    }

    @Test
    public void test_property_attachmentRemove() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property property = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/WEST");
        SpringLayoutTest.assertNotNull((Object)property);
        SpringLayoutTest.assertTrue((boolean)property.isModified());
        property.setValue(Property.UNKNOWN_VALUE);
        SpringLayoutTest.assertFalse((boolean)property.isModified());
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        SpringLayoutTest.assertEquals((long)0L, (long)button.getBounds().x);
    }

    @Test
    public void test_property_virtualGet() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property offset = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/WEST/offset");
        SpringLayoutTest.assertFalse((boolean)offset.isModified());
        SpringLayoutTest.assertNull((Object)offset.getValue());
        Property anchor = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/WEST/anchor");
        SpringLayoutTest.assertFalse((boolean)anchor.isModified());
        SpringLayoutTest.assertNull((Object)anchor.getValue());
        Property side = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/WEST/side");
        SpringLayoutTest.assertFalse((boolean)side.isModified());
        SpringLayoutTest.assertNull((Object)side.getValue());
    }

    @Test
    public void test_property_setOffset() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property offset = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/WEST/offset");
        SpringLayoutTest.assertTrue((boolean)offset.isModified());
        SpringLayoutTest.assertEquals((Object)offset.getValue(), (Object)10);
        offset.setValue((Object)50);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.WEST, button, 50, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        SpringLayoutTest.assertTrue((boolean)offset.isModified());
        SpringLayoutTest.assertEquals((Object)offset.getValue(), (Object)50);
        String source = this.m_lastEditor.getSource();
        offset.setValue(Property.UNKNOWN_VALUE);
        SpringLayoutTest.assertEquals((Object)source, (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_property_setOffset_virtual() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property offset = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/WEST/offset");
        offset.setValue((Object)10);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_property_setAnchorSide() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property anchorSide = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/NORTH/side");
        SpringLayoutTest.assertTrue((boolean)anchorSide.isModified());
        SpringLayoutTest.assertEquals((Object)anchorSide.getValue(), (Object)"North");
        anchorSide.setValue((Object)"South");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_property_setAnchorSide_virtual() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button");
        Property anchorSide = PropertyUtils.getByPath((ObjectInfo)button, (String)"Constraints/NORTH/side");
        SpringLayoutTest.assertFalse((boolean)anchorSide.isModified());
        anchorSide.setValue((Object)"South");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.NORTH, button, 0, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_property_setAnchor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    springLayout.putConstraint(SpringLayout.WEST, button_2, 10, SpringLayout.EAST, this);", "    add(button_2);", "  }", "}");
        this.refresh();
        ComponentInfo button_1 = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button_2");
        Property anchor = PropertyUtils.getByPath((ObjectInfo)button_2, (String)"Constraints/WEST/anchor");
        SpringLayoutTest.assertTrue((boolean)anchor.isModified());
        SpringLayoutTest.assertSame((Object)anchor.getValue(), (Object)panel);
        anchor.setValue((Object)button_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    springLayout.putConstraint(SpringLayout.WEST, button_2, 10, SpringLayout.EAST, button_1);", "    add(button_2);", "  }", "}");
    }

    @Test
    public void test_property_setAnchor_virtual() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "  }", "}");
        this.refresh();
        ComponentInfo button_1 = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button_2");
        Property anchor = PropertyUtils.getByPath((ObjectInfo)button_2, (String)"Constraints/WEST/anchor");
        SpringLayoutTest.assertFalse((boolean)anchor.isModified());
        SpringLayoutTest.assertEquals(null, (Object)SpringLayoutTest.getPropertyText(anchor));
        anchor.setValue((Object)button_1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    springLayout.putConstraint(SpringLayout.WEST, button_2, 0, SpringLayout.WEST, button_1);", "    add(button_2);", "  }", "}");
    }

    @Test
    public void test_property_setAnchor_combo() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    springLayout.putConstraint(SpringLayout.WEST, button_2, 10, SpringLayout.EAST, this);", "    add(button_2);", "  }", "}");
        this.refresh();
        ComponentInfo button_2 = (ComponentInfo)SpringLayoutTest.getJavaInfoByName("button_2");
        Property property = PropertyUtils.getByPath((ObjectInfo)button_2, (String)"Constraints/WEST/anchor");
        SpringLayoutTest.addComboPropertyItems(property);
        List<String> items = SpringLayoutTest.getComboPropertyItems();
        Assertions.assertThat(items).containsExactly((Object[])new String[]{"(javax.swing.JPanel)", "button_1"});
        SpringLayoutTest.setComboPropertySelection(1);
        SpringLayoutTest.setComboPropertySelection(property);
        SpringLayoutTest.assertEquals((long)0L, (long)SpringLayoutTest.getComboPropertySelection());
        SpringLayoutTest.setComboPropertyValue(property, 1);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    //", "    JButton button_1 = new JButton();", "    add(button_1);", "    //", "    JButton button_2 = new JButton();", "    springLayout.putConstraint(SpringLayout.WEST, button_2, 10, SpringLayout.EAST, button_1);", "    add(button_2);", "  }", "}");
    }

    @Test
    public void test_detach() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        SpringLayoutTest.assertTrue((boolean)layout.isAttached((IAbstractComponentInfo)button, 1));
        layout.detach((IAbstractComponentInfo)button, 1);
        SpringLayoutTest.assertFalse((boolean)layout.isAttached((IAbstractComponentInfo)button, 1));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
        layout.detach((IAbstractComponentInfo)button, 1);
        SpringLayoutTest.assertFalse((boolean)layout.isAttached((IAbstractComponentInfo)button, 1));
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "      layout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "    }", "  }", "}");
    }

    @Test
    public void test_attachAbsolute() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.attachAbsolute((IAbstractComponentInfo)button, 1, 5);
        layout.attachAbsolute((IAbstractComponentInfo)button, 32, 10);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, -10, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_adjustAttachmentOffset() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.adjustAttachmentOffset((IAbstractComponentInfo)button, 1, 10);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 15, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_attachWidgetSequientially_leadingSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.attachWidgetSequientially((IAbstractComponentInfo)buttonB, (IAbstractComponentInfo)buttonA, 1, 5);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.EAST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_attachWidgetSequientially_trailingSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.attachWidgetSequientially((IAbstractComponentInfo)buttonB, (IAbstractComponentInfo)buttonA, 4, 5);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.EAST, buttonB, -5, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_attachWidgetParallelly_leadingSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.attachWidgetParallelly((IAbstractComponentInfo)buttonB, (IAbstractComponentInfo)buttonA, 1, 5);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.WEST, buttonB, 5, SpringLayout.WEST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_attachWidgetParallelly_trailingSide() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      add(buttonB);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo buttonA = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo buttonB = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.attachWidgetParallelly((IAbstractComponentInfo)buttonB, (IAbstractComponentInfo)buttonA, 4, 5);
        this.assertEditor("public class Test extends JPanel {", "  private JButton buttonA;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      buttonA = new JButton();", "      add(buttonA);", "    }", "    {", "      JButton buttonB = new JButton();", "      layout.putConstraint(SpringLayout.EAST, buttonB, -5, SpringLayout.EAST, buttonA);", "      add(buttonB);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_horizontal_leadingAttached_resizeLeading() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 50, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 1, 1, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 50, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.EAST, button, " + (50 + preferredSize.width) + ", SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_horizontal_leadingAttached_resizeTrailing() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 1, 4, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, 5, SpringLayout.WEST, this);", "      layout.putConstraint(SpringLayout.EAST, button, " + (5 + preferredSize.width + 10) + ", SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_horizontal_trailingAttached_resizeTrailing() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.EAST, button, -50, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 4, 4, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, " + (-50 - preferredSize.width) + ", SpringLayout.EAST, this);", "      layout.putConstraint(SpringLayout.EAST, button, -50, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_horizontal_trailingAttached_resizeLeading() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.EAST, button, -5, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 4, 1, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button, " + (-5 - preferredSize.width - 10) + ", SpringLayout.EAST, this);", "      layout.putConstraint(SpringLayout.EAST, button, -5, SpringLayout.EAST, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_vertical_leadingAttached_resizeLeading() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 50, SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 8, 8, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 50, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, " + (50 + preferredSize.height) + ", SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_vertical_leadingAttached_resizeTrailing() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 8, 32, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, 5, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, " + (5 + preferredSize.height + 10) + ", SpringLayout.NORTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_vertical_trailingAttached_resizeTrailing() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.SOUTH, button, -50, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 32, 32, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, " + (-50 - preferredSize.height) + ", SpringLayout.SOUTH, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, -50, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_setExplicitSize_vertical_trailingAttached_resizeLeading() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.SOUTH, button, -5, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Dimension preferredSize = button.getPreferredSize();
        layout.setExplicitSize((IAbstractComponentInfo)button, 32, 8, 10);
        panel.refresh();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button, " + (-5 - preferredSize.height - 10) + ", SpringLayout.SOUTH, this);", "      layout.putConstraint(SpringLayout.SOUTH, button, -5, SpringLayout.SOUTH, this);", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_absolute() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button_1 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "    {", "      JButton button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_2, 20, SpringLayout.WEST, this);", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_MOVE(button_1, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      JButton button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_2, 20, SpringLayout.WEST, this);", "      add(button_2);", "    }", "    {", "      JButton button_1 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_source() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      button_1 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_2, 0, SpringLayout.WEST, button_1);", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        layout.command_MOVE(button_2, button_1);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      add(button_2);", "    }", "    {", "      button_1 = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button_2, 0, SpringLayout.WEST, button_1);", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "  }", "}");
        layout.command_MOVE(button_2, null);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      button_1 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_2, 0, SpringLayout.WEST, button_1);", "      add(button_2);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_anchor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      button_1 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "    {", "      button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_2, 0, SpringLayout.WEST, button_1);", "      add(button_2);", "    }", "  }", "}");
        panel.refresh();
        SpringLayoutInfo layout = (SpringLayoutInfo)panel.getLayout();
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        layout.command_MOVE(button_1, null);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    SpringLayout layout = new SpringLayout();", "    setLayout(layout);", "    {", "      button_2 = new JButton();", "      layout.putConstraint(SpringLayout.NORTH, button_2, 100, SpringLayout.NORTH, this);", "      add(button_2);", "    }", "    {", "      button_1 = new JButton();", "      layout.putConstraint(SpringLayout.WEST, button_2, 0, SpringLayout.WEST, button_1);", "      layout.putConstraint(SpringLayout.NORTH, button_1, 10, SpringLayout.NORTH, this);", "      layout.putConstraint(SpringLayout.WEST, button_1, 5, SpringLayout.WEST, this);", "      add(button_1);", "    }", "  }", "}");
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(null);", "    {", "      JButton button = new JButton();", "      add(button);", "      button.setBounds(10, 10, 50, 50);", "    }", "  }", "}");
        this.refresh();
        SpringLayoutInfo sl = (SpringLayoutInfo)SpringLayoutTest.createJavaInfo("javax.swing.SpringLayout");
        panel.setLayout((LayoutInfo)sl);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    SpringLayout springLayout = new SpringLayout();", "    setLayout(springLayout);", "    {", "      JButton button = new JButton();", "      springLayout.putConstraint(SpringLayout.NORTH, button, 10, SpringLayout.NORTH, this);", "      springLayout.putConstraint(SpringLayout.WEST, button, 10, SpringLayout.WEST, this);", "      springLayout.putConstraint(SpringLayout.SOUTH, button, 60, SpringLayout.NORTH, this);", "      springLayout.putConstraint(SpringLayout.EAST, button, 60, SpringLayout.WEST, this);", "      add(button);", "    }", "  }", "}");
    }
}

