/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.model;

import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.eclipse.wb.tests.designer.swing.model.layout.model.CardLayoutTest;
import org.junit.Test;

public class CardLayoutGefTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_CREATE_onCanvas_empty() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "  }", "}");
        ComponentInfo newButton = (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)panel, 100, 100).click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button = new JButton('New button');", "      add(button, '" + CardLayoutTest.getAssociationName(newButton) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_onCanvas_beforeExisting() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.select(panel);
        ComponentInfo newButton = (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)button_1, 2, 100).click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button = new JButton('New button');", "      add(button, '" + CardLayoutTest.getAssociationName(newButton) + "');", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_onCanvas_afterExisting() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.select(panel);
        ComponentInfo newButton = (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
        this.canvas.moveTo((Object)button_1, -2, 100).click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, '" + CardLayoutTest.getAssociationName(newButton) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inTree_empty() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "  }", "}");
        ComponentInfo newButton = (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
        this.tree.moveOn(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button = new JButton('New button');", "      add(button, '" + CardLayoutTest.getAssociationName(newButton) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inTree_beforeExisting() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        ComponentInfo newButton = (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
        this.tree.moveBefore(button_1).click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button = new JButton('New button');", "      add(button, '" + CardLayoutTest.getAssociationName(newButton) + "');", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inTree_afterExisting() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        ComponentInfo newButton = (ComponentInfo)this.loadCreationTool("javax.swing.JButton");
        this.tree.moveAfter(button_1).click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, '" + CardLayoutTest.getAssociationName(newButton) + "');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_inTree() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2, '222');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_2");
        this.tree.startDrag(button_2).dragBefore(button_1).endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_2 = new JButton();", "      add(button_2, '222');", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1, '111');", "    }", "  }", "}");
    }

    @Test
    public void test_navigation_next() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton('111');", "      add(button_1, '111');", "    }", "    {", "      JButton button_2 = new JButton('222');", "      add(button_2, '222');", "    }", "    {", "      JButton button_3 = new JButton('333');", "      add(button_3, '333');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_2");
        ComponentInfo button_3 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_3");
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.canvas.select(button_1);
        this.navigateNext(button_1);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNotNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.navigateNext(button_2);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNotNullEditPart(button_3);
        this.navigateNext(button_3);
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
    }

    @Test
    public void test_navigation_prev() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new CardLayout());", "    {", "      JButton button_1 = new JButton('111');", "      add(button_1, '111');", "    }", "    {", "      JButton button_2 = new JButton('222');", "      add(button_2, '222');", "    }", "    {", "      JButton button_3 = new JButton('333');", "      add(button_3, '333');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_1");
        ComponentInfo button_2 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_2");
        ComponentInfo button_3 = (ComponentInfo)CardLayoutGefTest.getJavaInfoByName("button_3");
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.canvas.select(button_1);
        this.navigatePrev(button_1);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNotNullEditPart(button_3);
        this.navigatePrev(button_3);
        this.canvas.assertNullEditPart(button_1);
        this.canvas.assertNotNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
        this.navigatePrev(button_2);
        this.canvas.assertNotNullEditPart(button_1);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.assertNullEditPart(button_3);
    }

    private void navigateNext(ComponentInfo component) {
        this.canvas.moveTo((Object)component, -4, 0).click();
    }

    private void navigatePrev(ComponentInfo component) {
        this.canvas.moveTo((Object)component, -14, 0).click();
    }
}

