/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gef;

import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.junit.Test;

public class BorderLayoutPolicyTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_setLayout() throws Exception {
        String[] source = new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}"};
        String[] source2 = new String[]{"// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout(0, 0));", "  }", "}"};
        this.check_setLayout(source, "java.awt.BorderLayout", source2, 10, 10);
    }

    @Test
    public void test_canvas_CREATE() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)this.m_contentEditPart, 10, 10);
        this.canvas.assertFeedbackFigures(6);
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.canvas.click();
        this.canvas.assertNoFeedbackFigures();
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_MOVE_1() throws Exception {
        this.check_MOVE("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton('Button');", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_canvas_MOVE_2() throws Exception {
        this.check_MOVE("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getButton(), BorderLayout.NORTH);", "  }", "  private JButton button;", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
    }

    @Test
    public void test_canvas_MOVE_3() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      final JButton button = new JButton();", "      add(button);", "    }", "  }", "}"};
        String[] expectedSource = StringUtilities.replace((String[])source, (String)"add(button);", (String)"add(button, BorderLayout.SOUTH);");
        this.check_MOVE(source, expectedSource);
    }

    private void check_MOVE(String ... lines) throws Exception {
        String[] expectedSource = StringUtilities.replace((String[])lines, (String)"NORTH", (String)"SOUTH");
        this.check_MOVE(lines, expectedSource);
    }

    private void check_MOVE(String[] source, String[] expectedSource) throws Exception, InterruptedException {
        ContainerInfo panel = this.openContainer(source);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.beginDrag(button);
        this.canvas.assertNoFeedbackFigures();
        this.canvas.dragTo((Object)panel, 10, -10);
        this.canvas.assertFeedbackFigures(5);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(expectedSource);
    }

    @Test
    public void test_canvas_ADD_1() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.SOUTH);", "      {", "        JButton button_1 = new JButton('Button 1');", "        panel.add(button_1);", "      }", "      {", "        JButton button_2 = new JButton('Button 2');", "        panel.add(button_2);", "      }", "    }", "  }", "}"};
        String[] source2 = new String[]{"public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      add(panel, BorderLayout.SOUTH);", "      {", "        JButton button_2 = new JButton('Button 2');", "        panel.add(button_2);", "      }", "    }", "    {", "      JButton button_1 = new JButton('Button 1');", "      add(button_1, BorderLayout.NORTH);", "    }", "  }", "}"};
        this.check_ADD(source, source2);
    }

    @Test
    public void test_canvas_ADD_2() throws Exception {
        String[] source = new String[]{"public class Test extends JPanel {", "  private JPanel panel;", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getPanel(), BorderLayout.SOUTH);", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      panel.add(getButton_1());", "      panel.add(getButton_2());", "    }", "    return panel;", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton('Button 1');", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton('button 2');", "    }", "    return button_2;", "  }", "}"};
        String[] source2 = new String[]{"public class Test extends JPanel {", "  private JPanel panel;", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    setLayout(new BorderLayout());", "    add(getPanel(), BorderLayout.SOUTH);", "    add(getButton_1(), BorderLayout.NORTH);", "  }", "  private JPanel getPanel() {", "    if (panel == null) {", "      panel = new JPanel();", "      panel.setBackground(Color.PINK);", "      panel.setPreferredSize(new Dimension(0, 150));", "      panel.add(getButton_2());", "    }", "    return panel;", "  }", "  private JButton getButton_1() {", "    if (button_1 == null) {", "      button_1 = new JButton('Button 1');", "    }", "    return button_1;", "  }", "  private JButton getButton_2() {", "    if (button_2 == null) {", "      button_2 = new JButton('button 2');", "    }", "    return button_2;", "  }", "}"};
        this.check_ADD(source, source2);
    }

    private void check_ADD(String[] source, String[] source2) throws Exception {
        ContainerInfo panel = this.openContainer(source);
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.canvas.beginDrag(button);
        this.canvas.assertNoFeedbackFigures();
        this.canvas.dragTo((Object)panel, 10, 10);
        this.canvas.assertFeedbackFigures(5);
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.assertEditor(source2);
    }

    @Test
    public void test_tree_CREATE_hasEmptyRegion() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "  }", "}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_CREATE_noEmptyRegion() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    add(new JButton(), BorderLayout.NORTH);", "    add(new JButton(), BorderLayout.SOUTH);", "    add(new JButton(), BorderLayout.WEST);", "    add(new JButton(), BorderLayout.EAST);", "    add(new JButton(), BorderLayout.CENTER);", "  }", "}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button_1 = new JButton();", "      add(button_1, BorderLayout.NORTH);", "    }", "    {", "      JButton button_2 = new JButton();", "      add(button_2, BorderLayout.SOUTH);", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.tree.startDrag(button_2).dragBefore(button_1);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button_2 = new JButton();", "      add(button_2, BorderLayout.SOUTH);", "    }", "    {", "      JButton button_1 = new JButton();", "      add(button_1, BorderLayout.NORTH);", "    }", "  }", "}");
    }

    @Test
    public void test_tree_ADD() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.CENTER);", "      {", "        JButton button = new JButton();", "        inner.add(button);", "      }", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.tree.startDrag(button).dragBefore(inner);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton();", "      add(button, BorderLayout.NORTH);", "    }", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.CENTER);", "    }", "  }", "}");
    }
}

