/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.FormLayout;

import com.jgoodies.forms.layout.CellConstraints;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.FormLayout.AbstractFormLayoutTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class CellConstraintsSupportTest
extends AbstractFormLayoutTest {
    private ContainerInfo m_panel;
    private ComponentInfo m_button;
    private ComplexProperty m_cellProperty;
    private Property[] m_subProperties;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject != null) {
            this.m_panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new FormLayout(new ColumnSpec[] {", "        FormSpecs.RELATED_GAP_COLSPEC,", "        FormSpecs.DEFAULT_COLSPEC,},", "      new RowSpec[] {", "        FormSpecs.RELATED_GAP_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,", "        FormSpecs.DEFAULT_ROWSPEC,}));", "    {", "      JButton button = new JButton();", "      add(button, '1, 2');", "    }", "  }", "}");
            this.m_panel.refresh();
            this.m_button = (ComponentInfo)this.m_panel.getChildrenComponents().get(0);
            this.m_cellProperty = (ComplexProperty)this.m_button.getPropertyByTitle("Constraints");
            CellConstraintsSupportTest.assertNotNull((Object)this.m_cellProperty);
            this.m_subProperties = this.m_cellProperty.getProperties();
            CellConstraintsSupportTest.assertEquals((long)6L, (long)this.m_subProperties.length);
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (this.m_panel != null) {
            this.m_panel.refresh_dispose();
            this.m_panel = null;
            this.m_button = null;
            this.m_cellProperty = null;
            this.m_subProperties = null;
        }
        super.tearDown();
    }

    @Test
    public void test_CellConstraintsSupport_span() throws Exception {
        CellConstraintsSupport support = FormLayoutInfo.getConstraints((ComponentInfo)this.m_button);
        CellConstraintsSupportTest.assertSame((Object)FormLayoutInfo.getConstraints((ComponentInfo)this.m_button), (Object)support);
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, 2, 1");
        support.setSpan(true, new Rectangle(1, 2, 2, 1));
        support.write();
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_setAlignH() throws Exception {
        CellConstraintsSupport support = FormLayoutInfo.getConstraints((ComponentInfo)this.m_button);
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, left, default");
        support.setAlignH(CellConstraints.LEFT);
        support.write();
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_setAlignV() throws Exception {
        CellConstraintsSupport support = FormLayoutInfo.getConstraints((ComponentInfo)this.m_button);
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, default, top");
        support.setAlignV(CellConstraints.TOP);
        support.write();
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_x() throws Exception {
        Property property = this.m_subProperties[0];
        CellConstraintsSupportTest.assertEquals((Object)"grid x", (Object)property.getTitle());
        CellConstraintsSupportTest.assertTrue((boolean)property.isModified());
        CellConstraintsSupportTest.assertEquals((Object)1, (Object)property.getValue());
        String expectedSource = this.m_lastEditor.getSource();
        property.setValue(Property.UNKNOWN_VALUE);
        CellConstraintsSupportTest.assertEquals((Object)1, (Object)property.getValue());
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"2, 2");
        property.setValue((Object)2);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        property.setValue((Object)1);
    }

    @Test
    public void test_property_y() throws Exception {
        Property property = this.m_subProperties[1];
        CellConstraintsSupportTest.assertEquals((Object)"grid y", (Object)property.getTitle());
        CellConstraintsSupportTest.assertTrue((boolean)property.isModified());
        CellConstraintsSupportTest.assertEquals((Object)2, (Object)property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 1");
        property.setValue((Object)1);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        property.setValue((Object)2);
    }

    @Test
    public void test_property_w() throws Exception {
        Property property = this.m_subProperties[2];
        CellConstraintsSupportTest.assertEquals((Object)"grid width", (Object)property.getTitle());
        CellConstraintsSupportTest.assertFalse((boolean)property.isModified());
        CellConstraintsSupportTest.assertEquals((Object)1, (Object)property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, 2, 1");
        property.setValue((Object)2);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2, 2, 1", (String)"1, 2");
        property.setValue(Property.UNKNOWN_VALUE);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_h() throws Exception {
        Property property = this.m_subProperties[3];
        CellConstraintsSupportTest.assertEquals((Object)"grid height", (Object)property.getTitle());
        CellConstraintsSupportTest.assertFalse((boolean)property.isModified());
        CellConstraintsSupportTest.assertEquals((Object)1, (Object)property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, 1, 2");
        property.setValue((Object)2);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2, 1, 2", (String)"1, 2");
        property.setValue(Property.UNKNOWN_VALUE);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_align_h() throws Exception {
        Property property = this.m_subProperties[4];
        CellConstraintsSupportTest.assertEquals((Object)"h alignment", (Object)property.getTitle());
        CellConstraintsSupportTest.assertFalse((boolean)property.isModified());
        CellConstraintsSupportTest.assertEquals((Object)CellConstraints.DEFAULT, (Object)property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, right, default");
        property.setValue((Object)CellConstraints.RIGHT);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2, right, default", (String)"1, 2");
        property.setValue(Property.UNKNOWN_VALUE);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_property_align_v() throws Exception {
        Property property = this.m_subProperties[5];
        CellConstraintsSupportTest.assertEquals((Object)"v alignment", (Object)property.getTitle());
        CellConstraintsSupportTest.assertFalse((boolean)property.isModified());
        CellConstraintsSupportTest.assertEquals((Object)CellConstraints.DEFAULT, (Object)property.getValue());
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, default, bottom");
        property.setValue((Object)CellConstraints.BOTTOM);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2, default, bottom", (String)"1, 2");
        property.setValue(Property.UNKNOWN_VALUE);
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getSmallAlignmentImage() throws Exception {
        this.check_getSmallAlignmentImage(CellConstraints.DEFAULT, true, false);
        this.check_getSmallAlignmentImage(CellConstraints.LEFT, true, true);
        this.check_getSmallAlignmentImage(CellConstraints.CENTER, true, true);
        this.check_getSmallAlignmentImage(CellConstraints.RIGHT, true, true);
        this.check_getSmallAlignmentImage(CellConstraints.FILL, true, true);
        this.check_getSmallAlignmentImage(CellConstraints.DEFAULT, false, false);
        this.check_getSmallAlignmentImage(CellConstraints.TOP, false, true);
        this.check_getSmallAlignmentImage(CellConstraints.CENTER, false, true);
        this.check_getSmallAlignmentImage(CellConstraints.BOTTOM, false, true);
        this.check_getSmallAlignmentImage(CellConstraints.FILL, false, true);
    }

    private void check_getSmallAlignmentImage(CellConstraints.Alignment alignment, boolean horizontal, boolean notNullExpected) {
        CellConstraintsSupport constraints = FormLayoutInfo.getConstraints((ComponentInfo)this.m_button);
        if (horizontal) {
            constraints.setAlignH(alignment);
        } else {
            constraints.setAlignV(alignment);
        }
        ImageDescriptor alignmentImage = constraints.getSmallAlignmentImageDescriptor(horizontal);
        if (notNullExpected) {
            CellConstraintsSupportTest.assertNotNull((Object)alignmentImage);
        } else {
            CellConstraintsSupportTest.assertNull((Object)alignmentImage);
        }
    }

    @Test
    public void test_contextMenu() throws Exception {
        MenuManager manager = CellConstraintsSupportTest.getDesignerMenuManager();
        this.m_button.getBroadcastObject().addContextMenu(null, (ObjectInfo)this.m_button, (IMenuManager)manager);
        IMenuManager manager2 = CellConstraintsSupportTest.findChildMenuManager((IContributionManager)manager, "Horizontal alignment");
        CellConstraintsSupportTest.assertNotNull((Object)manager2);
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Default"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Left"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Center"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Right"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Fill"));
        String expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2", (String)"1, 2, left, default");
        IAction action = CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Left");
        action.setChecked(true);
        action.run();
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        manager2 = CellConstraintsSupportTest.findChildMenuManager((IContributionManager)manager, "Vertical alignment");
        CellConstraintsSupportTest.assertNotNull((Object)manager2);
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Default"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Top"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Center"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Bottom"));
        CellConstraintsSupportTest.assertNotNull((Object)CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Fill"));
        expectedSource = StringUtils.replace((String)this.m_lastEditor.getSource(), (String)"1, 2, left, default", (String)"1, 2, left, top");
        action = CellConstraintsSupportTest.findChildAction((IContributionManager)manager2, "&Top");
        action.setChecked(true);
        action.run();
        CellConstraintsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
    }
}

