/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component.menu;

import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.RootAssociation;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuBarInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuInfo;
import org.eclipse.wb.internal.swing.model.component.menu.JMenuItemInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class JMenuBarTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('Menu');", "      menuBar.add(menu);", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        menu.add(item_1);", "      }", "      {", "        JMenuItem item_2 = new JMenuItem('Item 2');", "        menu.add(item_2);", "      }", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        JMenuBarTest.assertEquals((long)2L, (long)menuInfo.getChildrenItems().size());
    }

    @Test
    public void test_renderEmpty() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "  }", "}");
        frame.refresh();
        JMenuBarInfo menuBar = (JMenuBarInfo)frame.getChildren(JMenuBarInfo.class).get(0);
        JMenuBarTest.assertTrue((menuBar.getBounds().height > 10 ? 1 : 0) != 0);
    }

    @Test
    public void test_standaloneJMenuBar() throws Exception {
        JMenuBarInfo barInfo = (JMenuBarInfo)this.parseContainer(JMenuBarTest.getDoubleQuotes(new String[]{"public class Test extends JMenuBar {", "  public Test() {", "    JMenu menu = new JMenu('Menu');", "    add(menu);", "  }", "}"}));
        barInfo.refresh();
        JMenuBarTest.assertInstanceOf(RootAssociation.class, (Object)barInfo.getAssociation());
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)barInfo);
        ImageDescriptor image = menuObject.getImageDescriptor();
        JMenuBarTest.assertNotNull((Object)image);
        ImageData imageData = image.getImageData(100);
        JMenuBarTest.assertEquals((long)imageData.x, (long)0L);
        JMenuBarTest.assertEquals((long)imageData.y, (long)0L);
        Assertions.assertThat((int)imageData.width).isGreaterThan(40);
        Assertions.assertThat((int)imageData.height).isGreaterThan(20);
        Rectangle bounds = menuObject.getBounds();
        JMenuBarTest.assertEquals((long)bounds.x, (long)0L);
        JMenuBarTest.assertEquals((long)bounds.y, (long)0L);
        Assertions.assertThat((int)bounds.width).isGreaterThan(40);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
    }

    @Test
    public void test_standaloneJMenuBar_2() throws Exception {
        JMenuBarInfo barInfo = (JMenuBarInfo)this.parseContainer(JMenuBarTest.getDoubleQuotes(new String[]{"public class Test extends JMenuBar {", "  public Test() {", "    {", "      JMenu menu = new JMenu('New menu');", "      add(menu);", "    }", "    {", "      JMenu menu = new JMenu('New menu');", "      add(menu);", "    }", "  }", "}"}));
        barInfo.refresh();
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)barInfo);
        List items = menuObject.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        IMenuInfo menu = ((IMenuItemInfo)items.get(0)).getMenu();
        Rectangle bounds = menu.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(100);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
        menu = ((IMenuItemInfo)items.get(1)).getMenu();
        bounds = menu.getBounds();
        Assertions.assertThat((int)bounds.width).isGreaterThan(100);
        Assertions.assertThat((int)bounds.height).isGreaterThan(20);
    }

    @Test
    public void test_IMenuInfo_access() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu_1 = new JMenu('Menu 1');", "      menuBar.add(menu_1);", "    }", "    {", "      JMenu menu_2 = new JMenu('Menu 2');", "      menuBar.add(menu_2);", "    }", "  }", "}");
        frameInfo.refresh();
        ContainerInfo contentPaneInfo = (ContainerInfo)frameInfo.getChildrenComponents().get(0);
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        List childrenMenus = menuBarInfo.getChildrenMenus();
        JMenuBarTest.assertEquals((long)2L, (long)childrenMenus.size());
        JMenuInfo menuInfo_1 = (JMenuInfo)childrenMenus.get(0);
        JMenuInfo menuInfo_2 = (JMenuInfo)childrenMenus.get(1);
        JMenuBarTest.assertNull((Object)menuBarInfo.getAdapter(List.class));
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuBarInfo);
        JMenuBarTest.assertNotNull((Object)menuObject);
        JMenuBarTest.assertSame((Object)menuBarInfo, (Object)menuObject.getModel());
        JMenuBarTest.assertNull((Object)menuObject.getImageDescriptor());
        JMenuBarTest.assertEquals((long)contentPaneInfo.getBounds().width, (long)menuObject.getBounds().width);
        JMenuBarTest.assertTrue((boolean)menuObject.isHorizontal());
        List items = menuObject.getItems();
        JMenuBarTest.assertEquals((long)2L, (long)items.size());
        JMenuBarTest.assertSame((Object)menuInfo_1, (Object)((IMenuItemInfo)items.get(0)).getModel());
        JMenuBarTest.assertSame((Object)menuInfo_2, (Object)((IMenuItemInfo)items.get(1)).getModel());
    }

    @Test
    public void test_IMenuInfo_CREATE() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuBarInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuBarTest.assertEquals((long)0L, (long)menuObject.getItems().size());
        Object newObject = JMenuBarTest.createJavaInfo("java.lang.Object");
        JMenuBarTest.assertFalse((boolean)policy.validateCreate(newObject));
        JMenuInfo newMenuInfo = (JMenuInfo)JMenuBarTest.createComponent(JMenu.class);
        JMenuBarTest.assertTrue((boolean)policy.validateCreate((Object)newMenuInfo));
        policy.commandCreate((Object)newMenuInfo, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu = new JMenu('New menu');", "      menuBar.add(menu);", "    }", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_CREATE_JButton() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuBarInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuBarTest.assertEquals((long)0L, (long)menuObject.getItems().size());
        ComponentInfo newButtonInfo = JMenuBarTest.createJButton();
        JMenuBarTest.assertTrue((boolean)policy.validateCreate((Object)newButtonInfo));
        policy.commandCreate((Object)newButtonInfo, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JButton button = new JButton();", "      menuBar.add(button);", "    }", "  }", "}");
        List items = menuObject.getItems();
        JMenuBarTest.assertEquals((long)1L, (long)items.size());
        IMenuItemInfo item = (IMenuItemInfo)items.get(0);
        JMenuBarTest.assertSame((Object)newButtonInfo, (Object)item.getModel());
        JMenuBarTest.assertSame((Object)newButtonInfo.getImage(), (Object)item.getImageDescriptor());
        JMenuBarTest.assertEquals((Object)newButtonInfo.getBounds(), (Object)item.getBounds());
        JMenuBarTest.assertNull((Object)item.getMenu());
        JMenuBarTest.assertSame((Object)IMenuPolicy.NOOP, (Object)item.getPolicy());
        JMenuBarTest.assertTrue((boolean)menuObject.getItems().contains(item));
    }

    @Test
    public void test_IMenuInfo_MOVE() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu_1 = new JMenu('Menu 1');", "      menuBar.add(menu_1);", "    }", "    {", "      JMenu menu_2 = new JMenu('Menu 2');", "      menuBar.add(menu_2);", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo_1 = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        JMenuInfo menuInfo_2 = (JMenuInfo)menuBarInfo.getChildrenMenus().get(1);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuBarInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JMenuBarTest.assertTrue((boolean)policy.validateMove((Object)menuInfo_2));
        policy.commandMove((Object)menuInfo_2, (Object)menuInfo_1);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu menu_2 = new JMenu('Menu 2');", "      menuBar.add(menu_2);", "    }", "    {", "      JMenu menu_1 = new JMenu('Menu 1');", "      menuBar.add(menu_1);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_IMenuInfo_PASTE() throws Exception {
        ContainerInfo frameInfo = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu existingMenu = new JMenu('Some menu');", "      menuBar.add(existingMenu);", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        existingMenu.add(item_1);", "        item_1.setEnabled(false);", "      }", "      {", "        JMenuItem item_2 = new JMenuItem('Item 2');", "        existingMenu.add(item_2);", "      }", "    }", "  }", "}");
        frameInfo.refresh();
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frameInfo.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo existingMenuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuBarInfo);
        IMenuPolicy policy = menuObject.getPolicy();
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)existingMenuInfo);
        List<JavaInfoMemento> mementos = List.of(memento);
        JMenuBarTest.assertTrue((boolean)policy.validatePaste(mementos));
        policy.commandPaste(mementos, null);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    JMenuBar menuBar = new JMenuBar();", "    setJMenuBar(menuBar);", "    {", "      JMenu existingMenu = new JMenu('Some menu');", "      menuBar.add(existingMenu);", "      {", "        JMenuItem item_1 = new JMenuItem('Item 1');", "        existingMenu.add(item_1);", "        item_1.setEnabled(false);", "      }", "      {", "        JMenuItem item_2 = new JMenuItem('Item 2');", "        existingMenu.add(item_2);", "      }", "    }", "    {", "      JMenu menu = new JMenu('Some menu');", "      menuBar.add(menu);", "      {", "        JMenuItem menuItem = new JMenuItem('Item 1');", "        menuItem.setEnabled(false);", "        menu.add(menuItem);", "      }", "      {", "        JMenuItem menuItem = new JMenuItem('Item 2');", "        menu.add(menuItem);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_noChildren() throws Exception {
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        frame.refresh();
        JMenuBarInfo menuBar = (JMenuBarInfo)JMenuBarTest.createComponent(JMenuBar.class);
        menuBar.command_CREATE(frame);
        this.assertEditor("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "    {", "      JMenuBar menuBar = new JMenuBar();", "      setJMenuBar(menuBar);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_withStatement() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setEnabled(false);", "  }", "}");
        frame.refresh();
        JMenuBarInfo menuBar = (JMenuBarInfo)JMenuBarTest.createComponent(JMenuBar.class);
        menuBar.command_CREATE(frame);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    setEnabled(false);", "    {", "      JMenuBar menuBar = new JMenuBar();", "      setJMenuBar(menuBar);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_withChildren() throws Exception {
        ContainerInfo frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    {", "      JButton button = new JButton();", "      getContentPane().add(button);", "    }", "  }", "}");
        frame.refresh();
        JMenuBarInfo menuBar = (JMenuBarInfo)JMenuBarTest.createComponent(JMenuBar.class);
        menuBar.command_CREATE(frame);
        this.assertEditor("public class Test extends JFrame {", "  public Test() {", "    {", "      JButton button = new JButton();", "      getContentPane().add(button);", "    }", "    {", "      JMenuBar menuBar = new JMenuBar();", "      setJMenuBar(menuBar);", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_exposedItem_badReference() throws Exception {
        String[] lines = new String[]{"public class MyFrame extends JFrame {", "  private JMenuBar menuBar;", "  private JMenu menu;", "  private JMenuItem item;", "  public MyFrame() {", "    setJMenuBar(getMainJMenuBar());", "  }", "  public JMenuBar getMainJMenuBar() {", "    if (menuBar == null) {", "      menuBar = new JMenuBar();", "      menuBar.add(getMenu());", "    }", "    return menuBar;", "  }", "  public JMenu getMenu() {", "    if (menu == null) {", "      menu = new JMenu('New SubMenu');", "      menu.add(getItem());", "    }", "    return menu;", "  }", "  public JMenuItem getItem() {", "    if (item == null) {", "      item = new JMenuItem('New Item');", "    }", "    return item;", "  }", "}"};
        JMenuBarTest.setFileContentSrc("test/MyFrame.java", this.getTestSource(lines));
        JMenuBarTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends MyFrame {", "  public Test() {", "  }", "}");
        frame.refresh();
        JMenuBarTest.assertHierarchy("{this: test.MyFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}", "  {method: public javax.swing.JMenuBar test.MyFrame.getMainJMenuBar()} {property} {}", "    {method: public javax.swing.JMenu test.MyFrame.getMenu()} {property} {}", "      {method: public javax.swing.JMenuItem test.MyFrame.getItem()} {property} {}");
        JMenuBarInfo menuBarInfo = (JMenuBarInfo)frame.getChildren(JMenuBarInfo.class).get(0);
        JMenuInfo menuInfo = (JMenuInfo)menuBarInfo.getChildrenMenus().get(0);
        JMenuItemInfo itemInfo = (JMenuItemInfo)menuInfo.getChildren(JMenuItemInfo.class).get(0);
        JMenuBarTest.assertTrue((boolean)MenuObjectInfoUtils.isImplicitObject((Object)itemInfo));
    }
}

