/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JTableInfo;
import org.eclipse.wb.internal.swing.model.property.editor.models.table.TableColumnDescription;
import org.eclipse.wb.internal.swing.model.property.editor.models.table.TableModelDescription;
import org.eclipse.wb.internal.swing.model.property.editor.models.table.TableModelPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class JTableTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_evaluate_innerTableModel() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable(new MyTableModel());", "    add(table);", "  }", "  private class MyTableModel extends DefaultTableModel {", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        JTable tableObject = (JTable)tableInfo.getObject();
        TableModel model = tableObject.getModel();
        JTableTest.assertInstanceOf(DefaultTableModel.class, (Object)model);
    }

    @Test
    public void test_evaluate_valuesAndColumns() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        new Object[]{", "          '00', '01', '02'", "        },", "        new Object[]{", "          '10', '11', '12'", "        },", "      },", "      new String[]{", "        'A', 'B', 'C'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        JTable tableObject = (JTable)tableInfo.getObject();
        TableModel model = tableObject.getModel();
        JTableTest.assertNotNull((Object)model);
        JTableTest.assertEquals((long)3L, (long)model.getColumnCount());
        JTableTest.assertEquals((long)2L, (long)model.getRowCount());
        JTableTest.assertEquals((Object)"00", (Object)model.getValueAt(0, 0));
        JTableTest.assertEquals((Object)"01", (Object)model.getValueAt(0, 1));
        JTableTest.assertEquals((Object)"02", (Object)model.getValueAt(0, 2));
        JTableTest.assertEquals((Object)"10", (Object)model.getValueAt(1, 0));
        JTableTest.assertEquals((Object)"11", (Object)model.getValueAt(1, 1));
        JTableTest.assertEquals((Object)"12", (Object)model.getValueAt(1, 2));
        JTableTest.assertEquals((Object)"A", (Object)model.getColumnName(0));
        JTableTest.assertEquals((Object)"B", (Object)model.getColumnName(1));
        JTableTest.assertEquals((Object)"C", (Object)model.getColumnName(2));
        Property property = tableInfo.getPropertyByTitle("model");
        JTableTest.assertEquals((Object)"3 columns, 2 rows", (Object)JTableTest.getPropertyText(property));
        JTableTest.assertInstanceOf(TableModelPropertyEditor.class, (Object)property.getEditor());
    }

    @Test
    public void test_evaluate_anonymous_noColumnClass() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        new Object[]{", "          '00', '01', '02'", "        },", "      },", "      new String[]{", "        'A', 'B', 'C'", "      }", "    ) {", "    });", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        JTable tableObject = (JTable)tableInfo.getObject();
        TableModel model = tableObject.getModel();
        JTableTest.assertNotNull((Object)model);
        JTableTest.assertEquals((long)3L, (long)model.getColumnCount());
        JTableTest.assertEquals((long)1L, (long)model.getRowCount());
        JTableTest.assertEquals((Object)"00", (Object)model.getValueAt(0, 0));
        JTableTest.assertEquals((Object)"01", (Object)model.getValueAt(0, 1));
        JTableTest.assertEquals((Object)"02", (Object)model.getValueAt(0, 2));
        JTableTest.assertEquals((Object)"A", (Object)model.getColumnName(0));
        JTableTest.assertEquals((Object)"B", (Object)model.getColumnName(1));
        JTableTest.assertEquals((Object)"C", (Object)model.getColumnName(2));
        JTableTest.assertSame(Object.class, model.getColumnClass(0));
        JTableTest.assertSame(Object.class, model.getColumnClass(1));
        JTableTest.assertSame(Object.class, model.getColumnClass(2));
    }

    @Test
    public void test_evaluate_anonymous_withColumnClass() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        new Object[]{", "          'str', Boolean.TRUE, 'obj', Integer.valueOf(5)", "        },", "      },", "      new String[]{", "        'A', 'B', 'C', 'D'", "      }", "    ) {", "      Class[] columnTypes = new Class[] {", "        String.class, Boolean.class, Object.class, Integer.class", "      };", "      public Class getColumnClass(int columnIndex) {", "        return columnTypes[columnIndex];", "      }", "    });", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        JTable tableObject = (JTable)tableInfo.getObject();
        TableModel model = tableObject.getModel();
        JTableTest.assertNotNull((Object)model);
        JTableTest.assertEquals((long)4L, (long)model.getColumnCount());
        JTableTest.assertEquals((long)1L, (long)model.getRowCount());
        JTableTest.assertEquals((Object)"str", (Object)model.getValueAt(0, 0));
        JTableTest.assertSame((Object)Boolean.TRUE, (Object)model.getValueAt(0, 1));
        JTableTest.assertEquals((Object)"obj", (Object)model.getValueAt(0, 2));
        JTableTest.assertEquals((Object)5, (Object)model.getValueAt(0, 3));
        JTableTest.assertEquals((Object)"A", (Object)model.getColumnName(0));
        JTableTest.assertEquals((Object)"B", (Object)model.getColumnName(1));
        JTableTest.assertEquals((Object)"C", (Object)model.getColumnName(2));
        JTableTest.assertEquals((Object)"D", (Object)model.getColumnName(3));
        JTableTest.assertSame(String.class, model.getColumnClass(0));
        JTableTest.assertSame(Boolean.class, model.getColumnClass(1));
        JTableTest.assertSame(Object.class, model.getColumnClass(2));
        JTableTest.assertSame(Integer.class, model.getColumnClass(3));
        JTableTest.assertEquals((Object)true, (Object)model.isCellEditable(0, 0));
        JTableTest.assertEquals((Object)true, (Object)model.isCellEditable(0, 1));
        JTableTest.assertEquals((Object)true, (Object)model.isCellEditable(0, 2));
        JTableTest.assertEquals((Object)true, (Object)model.isCellEditable(0, 3));
    }

    @Test
    public void test_evaluate_anonymous_withColumnEditable() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        new Object[]{", "          '0', '1', '2'", "        },", "      },", "      new String[]{", "        'A', 'B', 'C'", "      }", "    ) {", "      boolean[] columnEditables = new boolean[] {", "        true, true, false", "      };", "      public boolean isCellEditable(int row, int column) {", "        return columnEditables[column];", "      }", "    });", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        JTable tableObject = (JTable)tableInfo.getObject();
        TableModel model = tableObject.getModel();
        JTableTest.assertNotNull((Object)model);
        JTableTest.assertEquals((long)3L, (long)model.getColumnCount());
        JTableTest.assertEquals((long)1L, (long)model.getRowCount());
        JTableTest.assertEquals((Object)"0", (Object)model.getValueAt(0, 0));
        JTableTest.assertEquals((Object)"1", (Object)model.getValueAt(0, 1));
        JTableTest.assertEquals((Object)"2", (Object)model.getValueAt(0, 2));
        JTableTest.assertEquals((Object)"A", (Object)model.getColumnName(0));
        JTableTest.assertEquals((Object)"B", (Object)model.getColumnName(1));
        JTableTest.assertEquals((Object)"C", (Object)model.getColumnName(2));
        JTableTest.assertEquals((Object)true, (Object)model.isCellEditable(0, 0));
        JTableTest.assertEquals((Object)true, (Object)model.isCellEditable(0, 1));
        JTableTest.assertEquals((Object)false, (Object)model.isCellEditable(0, 2));
    }

    @Test
    public void test_evaluate_getColumnModel_invocations() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        new Object[]{", "          '0', '1', '2'", "        },", "      },", "      new String[]{", "        'A', 'B', 'C'", "      }", "    ));", "    table.getColumnModel().getColumn(0).setPreferredWidth(200);", "  }", "}");
        panel.refresh();
        JTableTest.assertNoErrors((JavaInfo)panel);
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        JTable tableObject = (JTable)tableInfo.getObject();
        JTableTest.assertEquals((long)200L, (long)tableObject.getColumnModel().getColumn(0).getPreferredWidth());
    }

    @Test
    public void test_editor_getText_noModel() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        Property property = tableInfo.getPropertyByTitle("model");
        JTableTest.assertEquals(null, (Object)JTableTest.getPropertyText(property));
        JTableTest.assertInstanceOf(TableModelPropertyEditor.class, (Object)property.getEditor());
    }

    @Test
    public void test_editor_getText_someModel() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01', '02'},", "        {'10', '11', '12'},", "      },", "      new String[]{", "        'A', 'B', 'C'", "      }", "    ) {", "    });", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        Property property = tableInfo.getPropertyByTitle("model");
        JTableTest.assertEquals((Object)"3 columns, 2 rows", (Object)JTableTest.getPropertyText(property));
        JTableTest.assertInstanceOf(TableModelPropertyEditor.class, (Object)property.getEditor());
    }

    @Test
    public void test_TableModelDescription_simple() throws Exception {
        Object[][] values = new Object[][]{{"00", "01"}, {"10", "11"}, {"20", "21"}};
        Object[] columnNames = new String[]{"A", "B"};
        DefaultTableModel model = new DefaultTableModel(values, columnNames);
        JTable table = new JTable(model);
        TableModelDescription modelDescription = new TableModelDescription(table);
        JTableTest.assertEquals((long)3L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        TableColumnDescription column = modelDescription.getColumn(0);
        JTableTest.assertEquals((Object)"A", (Object)column.m_name);
        JTableTest.assertEquals((Object)true, (Object)column.m_editable);
        JTableTest.assertEquals((Object)true, (Object)column.m_resizable);
        column = modelDescription.getColumn(1);
        JTableTest.assertEquals((Object)"B", (Object)column.m_name);
        JTableTest.assertEquals((Object)true, (Object)column.m_editable);
        JTableTest.assertEquals((Object)true, (Object)column.m_resizable);
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "    {'10', '11'},", "    {'20', '21'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        Assertions.assertThat((List)modelDescription.getColumnModelInvocations()).isEmpty();
    }

    @Test
    public void test_TableModelDescription_noValues() throws Exception {
        Object[][] values = new Object[][]{};
        Object[] columnNames = new String[]{};
        DefaultTableModel model = new DefaultTableModel(values, columnNames);
        JTable table = new JTable(model);
        TableModelDescription modelDescription = new TableModelDescription(table);
        JTableTest.assertEquals((long)0L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)0L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "  },", "  new String[] {", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        Assertions.assertThat((List)modelDescription.getColumnModelInvocations()).isEmpty();
    }

    @Test
    public void test_TableModelDescription_valueTypes() throws Exception {
        Object[][] values = new Object[][]{{"str", Boolean.TRUE, Boolean.FALSE, 8, (byte)8, (short)8, 8L, Float.valueOf(8.1f), 8.2, new Object()}};
        Object[] columnNames = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09"};
        DefaultTableModel model = new DefaultTableModel(values, columnNames);
        JTable table = new JTable(model);
        TableModelDescription modelDescription = new TableModelDescription(table);
        JTableTest.assertEquals((long)1L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)10L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'str', Boolean.TRUE, Boolean.FALSE, new Integer(8), new Byte((byte) 8), new Short((short) 8), new Long(8L), new Float(8.1f), new Double(8.2), null},", "  },", "  new String[] {", "    '00', '01', '02', '03', '04', '05', '06', '07', '08', '09'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        Assertions.assertThat((List)modelDescription.getColumnModelInvocations()).isEmpty();
    }

    @Test
    public void test_TableModelDescription_columnProperties() throws Exception {
        Object[][] values = new Object[][]{{"00", "01"}};
        Object[] columnNames = new String[]{"A", "B"};
        DefaultTableModel model = new DefaultTableModel(values, columnNames){
            private static final long serialVersionUID = 0L;

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 0) {
                    return false;
                }
                return super.isCellEditable(row, column);
            }
        };
        JTable table = new JTable(model);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setResizable(false);
        column.setMinWidth(50);
        column.setPreferredWidth(100);
        column.setMaxWidth(200);
        TableModelDescription modelDescription = new TableModelDescription(table);
        JTableTest.assertEquals((long)1L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        TableColumnDescription column2 = modelDescription.getColumn(0);
        JTableTest.assertEquals((Object)"A", (Object)column2.m_name);
        JTableTest.assertEquals((Object)false, (Object)column2.m_editable);
        JTableTest.assertEquals((Object)false, (Object)column2.m_resizable);
        JTableTest.assertEquals((long)100L, (long)column2.m_preferredWidth);
        JTableTest.assertEquals((long)50L, (long)column2.m_minWidth);
        JTableTest.assertEquals((long)200L, (long)column2.m_maxWidth);
        column2 = modelDescription.getColumn(1);
        JTableTest.assertEquals((Object)"B", (Object)column2.m_name);
        JTableTest.assertEquals((Object)true, (Object)column2.m_editable);
        JTableTest.assertEquals((Object)true, (Object)column2.m_resizable);
        JTableTest.assertEquals((long)75L, (long)column2.m_preferredWidth);
        JTableTest.assertEquals((long)15L, (long)column2.m_minWidth);
        JTableTest.assertEquals((long)Integer.MAX_VALUE, (long)column2.m_maxWidth);
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ") {", "  boolean[] columnEditables = new boolean[] {", "    false, true", "  };", "  public boolean isCellEditable(int row, int column) {", "    return columnEditables[column];", "  }", "}").trim(), (Object)modelDescription.getModelSource());
        List invocations = modelDescription.getColumnModelInvocations();
        JTableTest.assertEquals((Object)invocations, List.of("getColumnModel().getColumn(0).setResizable(false)", "getColumnModel().getColumn(0).setPreferredWidth(100)", "getColumnModel().getColumn(0).setMinWidth(50)", "getColumnModel().getColumn(0).setMaxWidth(200)"));
    }

    @Test
    public void test_TableModelDescription_getColumnClass() throws Exception {
        Object[][] values = new Object[][]{new Object[0]};
        Object[] columnNames = new String[]{"A", "B", "C", "D"};
        DefaultTableModel model = new DefaultTableModel(values, columnNames){
            private static final long serialVersionUID = 0L;
            Class<?>[] columnTypes;
            {
                this.columnTypes = new Class[]{String.class, Boolean.class, Object.class, Integer.class};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnTypes[columnIndex];
            }
        };
        JTable table = new JTable(model);
        TableModelDescription modelDescription = new TableModelDescription(table);
        JTableTest.assertEquals((long)1L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getColumnCount());
        JTableTest.assertSame(String.class, (Object)modelDescription.getColumn((int)0).m_class);
        JTableTest.assertSame(Boolean.class, (Object)modelDescription.getColumn((int)1).m_class);
        JTableTest.assertSame(Object.class, (Object)modelDescription.getColumn((int)2).m_class);
        JTableTest.assertSame(Integer.class, (Object)modelDescription.getColumn((int)3).m_class);
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {null, null, null, null},", "  },", "  new String[] {", "    'A', 'B', 'C', 'D'", "  }", ") {", "  Class[] columnTypes = new Class[] {", "    java.lang.String.class, java.lang.Boolean.class, java.lang.Object.class, java.lang.Integer.class", "  };", "  public Class getColumnClass(int columnIndex) {", "    return columnTypes[columnIndex];", "  }", "}").trim(), (Object)modelDescription.getModelSource());
        List invocations = modelDescription.getColumnModelInvocations();
        Assertions.assertThat((List)invocations).isEmpty();
    }

    @Test
    public void test_TableModelDescription_insertColumn() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01'},", "        {'10', '11'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.insertColumn(1);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)3L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', null, '01'},", "    {'10', null, '11'},", "  },", "  new String[] {", "    'A', 'New column', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        JTableTest.isNewColumn(modelDescription, 1);
    }

    @Test
    public void test_TableModelDescription_removeColumn() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01', '02'},", "        {'10', '11', '12'},", "      },", "      new String[]{", "        'A', 'B', 'C'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)3L, (long)modelDescription.getColumnCount());
        modelDescription.removeColumn(1);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '02'},", "    {'10', '12'},", "  },", "  new String[] {", "    'A', 'C'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }

    @Test
    public void test_TableModelDescription_setColumnCount() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01'},", "        {'10', '11'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.setColumnCount(4);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01', null, null},", "    {'10', '11', null, null},", "  },", "  new String[] {", "    'A', 'B', 'New column', 'New column'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        JTableTest.isNewColumn(modelDescription, 2);
        JTableTest.isNewColumn(modelDescription, 3);
        modelDescription.setColumnCount(1);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)1L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00'},", "    {'10'},", "  },", "  new String[] {", "    'A'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }

    @Test
    public void test_TableModelDescription_moveColumn() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01', '02', '03'},", "        {'10', '11', '12', '13'},", "      },", "      new String[]{", "        'A', 'B', 'C', 'D'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getColumnCount());
        modelDescription.moveColumn(2, 1);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '02', '01', '03'},", "    {'10', '12', '11', '13'},", "  },", "  new String[] {", "    'A', 'C', 'B', 'D'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        modelDescription.moveColumn(1, 2);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01', '02', '03'},", "    {'10', '11', '12', '13'},", "  },", "  new String[] {", "    'A', 'B', 'C', 'D'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        modelDescription.moveColumn(0, 3);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'01', '02', '03', '00'},", "    {'11', '12', '13', '10'},", "  },", "  new String[] {", "    'B', 'C', 'D', 'A'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }

    private static void isNewColumn(TableModelDescription modelDescription, int index) {
        TableColumnDescription column = modelDescription.getColumn(index);
        JTableTest.assertEquals((Object)"New column", (Object)column.m_name);
        JTableTest.assertEquals((Object)true, (Object)column.m_editable);
        JTableTest.assertEquals((Object)true, (Object)column.m_resizable);
        JTableTest.assertEquals((long)75L, (long)column.m_preferredWidth);
        JTableTest.assertEquals((long)15L, (long)column.m_minWidth);
        JTableTest.assertEquals((long)Integer.MAX_VALUE, (long)column.m_maxWidth);
    }

    @Test
    public void test_TableModelDescription_setColumnType() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', Boolean.TRUE},", "        {'10', '11'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.setColumnType(1, Boolean.class);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', Boolean.TRUE},", "    {'10', null},", "  },", "  new String[] {", "    'A', 'B'", "  }", ") {", "  Class[] columnTypes = new Class[] {", "    java.lang.Object.class, java.lang.Boolean.class", "  };", "  public Class getColumnClass(int columnIndex) {", "    return columnTypes[columnIndex];", "  }", "}").trim(), (Object)modelDescription.getModelSource());
        Assertions.assertThat((List)modelDescription.getColumnModelInvocations()).isEmpty();
    }

    @Test
    public void test_TableModelDescription_insertRow() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01'},", "        {'10', '11'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.insertRow(1);
        JTableTest.assertEquals((long)3L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "    {'10', '11'},", "    {null, null},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }

    @Test
    public void test_TableModelDescription_removeRow() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01'},", "        {'10', '11'},", "        {'20', '21'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)3L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.removeRow(1);
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "    {'20', '21'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }

    @Test
    public void test_TableModelDescription_setRowCount() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01'},", "        {'10', '11'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.setRowCount(4);
        JTableTest.assertEquals((long)4L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "    {'10', '11'},", "    {null, null},", "    {null, null},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        modelDescription.setRowCount(1);
        JTableTest.assertEquals((long)1L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }

    @Test
    public void test_TableModelDescription_moveRow() throws Exception {
        ContainerInfo panel = this.parseContainer("import javax.swing.table.*;", "public class Test extends JPanel {", "  public Test() {", "    JTable table = new JTable();", "    add(table);", "    table.setModel(new DefaultTableModel(", "      new Object[][]{", "        {'00', '01'},", "        {'10', '11'},", "        {'20', '21'},", "        {'30', '31'},", "      },", "      new String[]{", "        'A', 'B'", "      }", "    ));", "  }", "}");
        panel.refresh();
        JTableInfo tableInfo = (JTableInfo)panel.getChildrenComponents().get(0);
        TableModelDescription modelDescription = new TableModelDescription((JTable)tableInfo.getObject());
        JTableTest.assertEquals((long)4L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        modelDescription.moveRow(2, 1);
        JTableTest.assertEquals((long)4L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "    {'20', '21'},", "    {'10', '11'},", "    {'30', '31'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        modelDescription.moveRow(1, 2);
        JTableTest.assertEquals((long)4L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'00', '01'},", "    {'10', '11'},", "    {'20', '21'},", "    {'30', '31'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
        modelDescription.moveRow(0, 3);
        JTableTest.assertEquals((long)4L, (long)modelDescription.getRowCount());
        JTableTest.assertEquals((long)2L, (long)modelDescription.getColumnCount());
        JTableTest.assertEquals((Object)JTableTest.getDoubleQuotes2("new javax.swing.table.DefaultTableModel(", "  new Object[][] {", "    {'10', '11'},", "    {'20', '21'},", "    {'30', '31'},", "    {'00', '01'},", "  },", "  new String[] {", "    'A', 'B'", "  }", ")").trim(), (Object)modelDescription.getModelSource());
    }
}

