/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.rcp.model.widgets.DialogInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class DialogTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parse() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends Dialog {", "  protected Object result;", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);", "    setText('SWT Dialog');", "  }", "  public Object open() {", "    createContents();", "    shell.open();", "    shell.layout();", "    Display display = getParent().getDisplay();", "    while (!shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "    return result;", "  }", "  private void createContents() {", "    shell = new Shell(getParent(), getStyle());", "    shell.setSize(450, 300);", "    shell.setText(getText());", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.swt.widgets.Dialog_} {this} {/setText('SWT Dialog')/ /new Shell(getParent(), getStyle())/ /new Shell(getParent(), getStyle())/ /shell.setText(getText())/}", "  {new: org.eclipse.swt.widgets.Shell} {field-unique: shell} {/new Shell(getParent(), getStyle())/ /shell.setSize(450, 300)/ /shell.setText(getText())/ /shell.open()/ /shell.layout()/}", "    {implicit-layout: absolute} {implicit-layout} {}");
        DialogTest.assertFalse((boolean)dialog.getDescription().isCached());
        dialog.refresh();
        DialogTest.assertNotNull((Object)dialog.getImage());
        Rectangle bounds = dialog.getBounds();
        DialogTest.assertEquals((long)bounds.width, (long)450L);
        DialogTest.assertEquals((long)bounds.height, (long)300L);
        ShellInfo shell = (ShellInfo)DialogTest.getJavaInfoByName("shell");
        Rectangle bounds2 = shell.getBounds();
        DialogTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)bounds2);
    }

    @Test
    public void test_parse_RightToLeft() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL | SWT.RIGHT_TO_LEFT);", "    setText('SWT Dialog');", "  }", "  public Object open() {", "    createContents();", "    return null;", "  }", "  private void createContents() {", "    shell = new Shell(getParent(), getStyle());", "    shell.setSize(450, 300);", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.swt.widgets.Dialog_} {this} {/setText('SWT Dialog')/ /new Shell(getParent(), getStyle())/ /new Shell(getParent(), getStyle())/}", "  {new: org.eclipse.swt.widgets.Shell} {field-unique: shell} {/new Shell(getParent(), getStyle())/ /shell.setSize(450, 300)/}", "    {implicit-layout: absolute} {implicit-layout} {}");
        dialog.refresh();
        Rectangle bounds = dialog.getBounds();
        DialogTest.assertEquals((long)bounds.width, (long)450L);
        DialogTest.assertEquals((long)bounds.height, (long)300L);
        ShellInfo shell = (ShellInfo)DialogTest.getJavaInfoByName("shell");
        Rectangle bounds2 = shell.getBounds();
        DialogTest.assertEquals((Object)new Rectangle(0, 0, 450, 300), (Object)bounds2);
    }

    @Test
    public void test_constructorWithStyle() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends Dialog {", "  protected Object result;", "  protected Shell shell;", "  public Test(Shell parent, int style) {", "    super(parent, style);", "  }", "  public Object open() {", "    shell = new Shell(getParent(), getStyle());", "    return result;", "  }", "}");
        DialogTest.assertHierarchy("{this: org.eclipse.swt.widgets.Dialog_} {this} {/new Shell(getParent(), getStyle())/ /new Shell(getParent(), getStyle())/}", "  {new: org.eclipse.swt.widgets.Shell} {field-unique: shell} {/new Shell(getParent(), getStyle())/}", "    {implicit-layout: absolute} {implicit-layout} {}");
        dialog.refresh();
        DialogTest.assertNotNull((Object)dialog.getImage());
        DialogTest.assertNotNull((Object)PropertyUtils.getByPath((ObjectInfo)dialog, (String)"Constructor/arg1"));
    }

    @Test
    public void test_severalConstructors() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent, int style) {", "    super(parent, style);", "  }", "  public Test(Shell parent) {", "    this(parent, SWT.NONE);", "  }", "  public Object open() {", "    shell = new Shell(getParent(), getStyle());", "    return null;", "  }", "}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
    }

    @Test
    public void test_noOpenMethod() throws Exception {
        try {
            this.parseJavaInfo("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent, int style) {", "    super(parent, style);", "  }", "}");
            DialogTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            DialogTest.assertEquals((long)3004L, (long)de.getCode());
        }
    }

    @Test
    public void test_openMethodWithParameters() throws Exception {
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent, int style) {", "    super(parent, style);", "  }", "  public Object open(String msg) {", "    shell = new Shell(getParent(), getStyle());", "    return null;", "  }", "}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
    }

    @Test
    public void test_ignoreNewInstance() throws Exception {
        CompositeInfo shell = (CompositeInfo)this.parseJavaInfo("public class Test {", "  public static void main (String[] args) {", "    Shell shell = new Shell();", "    FileDialog dialog = new FileDialog (shell, SWT.SAVE);", "  }", "}");
        DialogTest.assertHierarchy("{new: org.eclipse.swt.widgets.Shell} {local-unique: shell} {/new Shell()/ /new FileDialog (shell, SWT.SAVE)/}", "  {implicit-layout: absolute} {implicit-layout} {}");
        shell.refresh();
        DialogTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_betterStyleParameterDetection() throws Exception {
        DialogTest.setFileContentSrc("test/MyData.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyData {", "  // filler filler filler", "}"));
        DialogTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, MyData data, int style) {", "    super(parent, style);", "  }", "}"));
        DialogTest.waitForAutoBuild();
        DialogTest.useStrictEvaluationMode(false);
        DialogInfo dialog = (DialogInfo)this.parseJavaInfo("public class Test extends Dialog {", "  protected MyData m_data;", "  protected Shell shell;", "  public Test(Shell parent, MyData data, int style) {", "    super(parent, style);", "    m_data = data;", "  }", "  public Object open() {", "    shell = new Shell(getParent(), getStyle());", "    new MyComposite(shell, m_data, SWT.NONE);", "    return null;", "  }", "}");
        dialog.refresh();
        DialogTest.assertNoErrors((JavaInfo)dialog);
    }

    @Test
    public void test_noMainShell() throws Exception {
        try {
            this.parseJavaInfo("public class Test extends Dialog {", "  protected Object result;", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, 0);", "  }", "  public Object open() {", "    shell.open();", "    shell.layout();", "    return result;", "  }", "}");
            DialogTest.fail();
        }
        catch (Throwable e) {
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            DialogTest.assertEquals((long)3006L, (long)de.getCode());
        }
    }

    @Test
    public void test_contextMenu_setMinimalSize() throws Exception {
        this.parseJavaInfo("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);", "    setText('SWT Dialog');", "  }", "  public Object open() {", "    createContents();", "    return null;", "  }", "  private void createContents() {", "    shell = new Shell(getParent(), getStyle());", "    shell.setSize(450, 300);", "  }", "}");
        this.refresh();
        CompositeInfo shell = (CompositeInfo)DialogTest.getJavaInfoByName("shell");
        Dimension preferredSize = shell.getPreferredSize().getCopy();
        IMenuManager contextMenu = DialogTest.getContextMenu(new ObjectInfo[]{shell});
        IAction action = DialogTest.findChildAction((IContributionManager)contextMenu, "Set minimal size, as after pack()");
        DialogTest.assertNotNull((Object)action);
        action.run();
        this.assertEditor("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);", "    setText('SWT Dialog');", "  }", "  public Object open() {", "    createContents();", "    return null;", "  }", "  private void createContents() {", "    shell = new Shell(getParent(), getStyle());", "    shell.setSize(" + preferredSize.width + ", " + preferredSize.height + ");", "  }", "}");
    }

    @Test
    public void test_contextMenu_removeSize() throws Exception {
        this.parseJavaInfo("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);", "    setText('SWT Dialog');", "  }", "  public Object open() {", "    createContents();", "    return null;", "  }", "  private void createContents() {", "    shell = new Shell(getParent(), getStyle());", "    shell.setSize(450, 300);", "  }", "}");
        this.refresh();
        CompositeInfo shell = (CompositeInfo)DialogTest.getJavaInfoByName("shell");
        IMenuManager contextMenu = DialogTest.getContextMenu(new ObjectInfo[]{shell});
        IAction action = DialogTest.findChildAction((IContributionManager)contextMenu, "Remove setSize()");
        DialogTest.assertNotNull((Object)action);
        action.run();
        this.assertEditor("public class Test extends Dialog {", "  protected Shell shell;", "  public Test(Shell parent) {", "    super(parent, SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);", "    setText('SWT Dialog');", "  }", "  public Object open() {", "    createContents();", "    return null;", "  }", "  private void createContents() {", "    shell = new Shell(getParent(), getStyle());", "  }", "}");
    }
}

