/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.rcp;

import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.wb.internal.rcp.wizards.rcp.editor.EditorPartWizard;
import org.eclipse.wb.internal.rcp.wizards.rcp.view.ViewPartWizard;
import org.eclipse.wb.tests.designer.TestUtils;
import org.eclipse.wb.tests.designer.core.PdeProjectConversionUtils;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RcpWizardsTest
extends RcpModelTest {
    private IPackageFragment m_packageFragment;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_packageFragment = m_testProject.getPackage("test");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        RcpWizardsTest.waitEventLoop(10);
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @DisposeProjectAfter
    @Test
    public void test_ViewPart_isPDE() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_project, null, null);
        this.animate_ViewPart();
        String pluginFile = RcpWizardsTest.getFileContent("plugin.xml");
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"org.eclipse.ui.views"});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"<view"});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"class=\"test.MyViewPart\""});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"id=\"test.MyViewPart\""});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"name=\"New ViewPart\""});
    }

    @DisposeProjectAfter
    @Test
    public void test_ViewPart_notPDE() throws Exception {
        this.animate_ViewPart();
        RcpWizardsTest.assertFileNotExists("plugin.xml");
    }

    private void animate_ViewPart() throws Exception {
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                TestUtils.runWizard((IWizard)new ViewPartWizard(), (IStructuredSelection)new StructuredSelection((Object)RcpWizardsTest.this.m_packageFragment));
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("New Eclipse RCP ViewPart");
                context.getTextByLabel("Name:").setText("MyViewPart");
                context.clickButton("Finish");
            }
        });
    }

    @DisposeProjectAfter
    @Test
    public void test_EditorPart_isPDE() throws Exception {
        PdeProjectConversionUtils.convertToPDE(m_project, null, null);
        this.animate_EditorPart();
        String pluginFile = RcpWizardsTest.getFileContent("plugin.xml");
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"org.eclipse.ui.editors"});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"<editor"});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"class=\"test.MyEditorPart\""});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"id=\"test.MyEditorPart\""});
        Assertions.assertThat((String)pluginFile).contains(new CharSequence[]{"name=\"New EditorPart\""});
    }

    @DisposeProjectAfter
    @Test
    public void test_EditorPart_notPDE() throws Exception {
        this.animate_EditorPart();
        RcpWizardsTest.assertFileNotExists("plugin.xml");
    }

    private void animate_EditorPart() throws Exception {
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                TestUtils.runWizard((IWizard)new EditorPartWizard(), (IStructuredSelection)new StructuredSelection((Object)RcpWizardsTest.this.m_packageFragment));
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("New Eclipse RCP EditorPart");
                context.getTextByLabel("Name:").setText("MyEditorPart");
                context.clickButton("Finish");
            }
        });
    }
}

