/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.rcp.model.jface.ApplicationWindowInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionContributionItemInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ActionInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.ContributionItemInfo;
import org.eclipse.wb.internal.rcp.model.jface.action.MenuManagerInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class MenuManagerTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_standalone() throws Exception {
        CompositeInfo shell = this.parseComposite("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends Shell {", "  public Test() {", "    MenuManager menuManager = new MenuManager();", "  }", "}");
        MenuManagerTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {}", "  {implicit-layout: absolute} {implicit-layout} {}");
        shell.refresh();
        MenuManagerTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_empty() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    return menuManager;", "  }", "}");
        MenuManagerTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addMenuBar()/}", "  {superInvocation: super.createMenuManager()} {local-unique: menuManager} {/super.createMenuManager()/ /menuManager/}");
        MenuManagerInfo menuManager = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuManager);
        window.refresh();
        Assertions.assertThat((int)menuObject.getBounds().width).isGreaterThan(300);
        Assertions.assertThat((int)menuObject.getBounds().height).isGreaterThan(18);
    }

    @Test
    public void test_itemBounds() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action_1;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action_1 = new Action('Action 1') {", "    };", "    action_2 = new Action('Action 2') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(action_1);", "    menuManager.add(action_2);", "    menuManager.add(action_1);", "    return menuManager;", "  }", "}");
        window.refresh();
        List actions = ActionContainerInfo.getActions((JavaInfo)window);
        Assertions.assertThat((List)actions).hasSize(2);
        ActionInfo action_1 = (ActionInfo)actions.get(0);
        ActionInfo action_2 = (ActionInfo)actions.get(1);
        MenuManagerInfo menuManager = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        List items = menuManager.getChildren(ContributionItemInfo.class);
        Assertions.assertThat((List)items).hasSize(3);
        ActionContributionItemInfo item_1 = (ActionContributionItemInfo)items.get(0);
        ActionContributionItemInfo item_2 = (ActionContributionItemInfo)items.get(1);
        ActionContributionItemInfo item_3 = (ActionContributionItemInfo)items.get(2);
        MenuManagerTest.assertSame((Object)action_1, (Object)item_1.getAction());
        MenuManagerTest.assertSame((Object)action_2, (Object)item_2.getAction());
        MenuManagerTest.assertSame((Object)action_1, (Object)item_3.getAction());
        Rectangle bounds_1 = item_1.getBounds();
        Rectangle bounds_2 = item_2.getBounds();
        Rectangle bounds_3 = item_3.getBounds();
        Assertions.assertThat((int)bounds_1.height).isGreaterThanOrEqualTo(18);
        MenuManagerTest.assertEquals((long)bounds_1.height, (long)bounds_2.height);
        MenuManagerTest.assertEquals((long)bounds_1.height, (long)bounds_3.height);
        MenuManagerTest.assertNull((Object)menuManager.getAdapter(List.class));
    }

    @Test
    public void test_emptySubMenu() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      menuManager.add(subMenuManager);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        List menuItems = menuInfo.getItems();
        Assertions.assertThat((List)menuItems).hasSize(1);
        MenuManagerInfo subMenuInfo = (MenuManagerInfo)menuItems.get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)subMenuInfo);
        Assertions.assertThat((int)menuObject.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)menuObject.getBounds().height).isGreaterThan(20);
    }

    @Test
    public void test_ignore_setVisible() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      menuManager.add(subMenuManager);", "      subMenuManager.setVisible(false);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerTest.assertNoErrors((JavaInfo)window);
    }

    @Test
    public void test_ignore_setRemoveAllWhenShown_true_() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      subMenuManager.setRemoveAllWhenShown(true);", "      menuManager.add(subMenuManager);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerTest.assertNoErrors((JavaInfo)window);
    }

    @Test
    public void test_IMenuInfo_0() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action_1;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action_1 = new Action('Action 1') {", "    };", "    action_2 = new Action('Action 2') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(action_1);", "    menuManager.add(action_2);", "    menuManager.add(action_1);", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        List items = menuInfo.getChildren(ContributionItemInfo.class);
        Assertions.assertThat((List)items).hasSize(3);
        ActionContributionItemInfo itemInfo_1 = (ActionContributionItemInfo)items.get(0);
        ActionContributionItemInfo itemInfo_2 = (ActionContributionItemInfo)items.get(1);
        ActionContributionItemInfo itemInfo_3 = (ActionContributionItemInfo)items.get(2);
        MenuManagerTest.assertTrue((boolean)menuInfo.isBar());
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        MenuManagerTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        MenuManagerTest.assertNull((Object)menuObject.getImageDescriptor());
        Assertions.assertThat((int)menuObject.getBounds().width).isGreaterThan(400);
        Assertions.assertThat((int)menuObject.getBounds().height).isGreaterThan(18);
        MenuManagerTest.assertTrue((boolean)menuObject.isHorizontal());
        MenuManagerTest.assertNotNull((Object)itemInfo_1.getBounds());
        MenuManagerTest.assertNotNull((Object)itemInfo_2.getBounds());
        MenuManagerTest.assertNotNull((Object)itemInfo_3.getBounds());
    }

    @Test
    public void test_IMenuInfo_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action_1;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action_1 = new Action('Action 1') {", "    };", "    action_2 = new Action('Action 2') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(action_1);", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      subMenuManager.add(action_2);", "      menuManager.add(subMenuManager);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerTest.assertHierarchy("{this: org.eclipse.jface.window.ApplicationWindow} {this} {/addMenuBar()/}", "  {superInvocation: super.createMenuManager()} {local-unique: menuManager} {/super.createMenuManager()/ /menuManager.add(action_1)/ /menuManager.add(subMenuManager)/ /menuManager/}", "    {void} {void} {/menuManager.add(action_1)/}", "    {new: org.eclipse.jface.action.MenuManager} {local-unique: subMenuManager} {/new MenuManager('Sub-menu')/ /subMenuManager.add(action_2)/ /menuManager.add(subMenuManager)/}", "      {void} {void} {/subMenuManager.add(action_2)/}", "  {org.eclipse.wb.internal.rcp.model.jface.action.ActionContainerInfo}", "    {new: org.eclipse.jface.action.Action} {field-unique: action_1} {/new Action('Action 1')/ /menuManager.add(action_1)/}", "    {new: org.eclipse.jface.action.Action} {field-unique: action_2} {/new Action('Action 2')/ /subMenuManager.add(action_2)/}");
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        List menuItems = menuInfo.getItems();
        Assertions.assertThat((List)menuItems).hasSize(2);
        ActionContributionItemInfo itemInfo_1 = (ActionContributionItemInfo)menuItems.get(0);
        MenuManagerInfo subMenuInfo = (MenuManagerInfo)menuItems.get(1);
        List subMenuItems = subMenuInfo.getItems();
        Assertions.assertThat((List)subMenuItems).hasSize(1);
        ActionContributionItemInfo itemInfo_2 = (ActionContributionItemInfo)subMenuItems.get(0);
        MenuManagerTest.assertTrue((boolean)menuInfo.isBar());
        MenuManagerTest.assertFalse((boolean)subMenuInfo.isBar());
        MenuManagerTest.assertNull((Object)subMenuInfo.getImage());
        Assertions.assertThat((int)subMenuInfo.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)subMenuInfo.getBounds().height).isGreaterThan(18);
        MenuManagerTest.assertNull((Object)itemInfo_1.getImage());
        Assertions.assertThat((int)itemInfo_1.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)itemInfo_1.getBounds().height).isGreaterThan(18);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        MenuManagerTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        MenuManagerTest.assertNull((Object)menuObject.getImageDescriptor());
        Assertions.assertThat((int)menuObject.getBounds().width).isGreaterThan(400);
        Assertions.assertThat((int)menuObject.getBounds().height).isGreaterThan(18);
        MenuManagerTest.assertTrue((boolean)menuObject.isHorizontal());
        List items = menuObject.getItems();
        Assertions.assertThat((List)items).hasSize(2);
        MenuManagerTest.assertSame((Object)subMenuInfo, (Object)((IMenuItemInfo)items.get(1)).getModel());
        IMenuItemInfo itemObject = (IMenuItemInfo)items.get(0);
        MenuManagerTest.assertSame((Object)itemInfo_1, (Object)itemObject.getModel());
        MenuManagerTest.assertNull((Object)itemObject.getImageDescriptor());
        MenuManagerTest.assertSame((Object)itemInfo_1.getImage(), (Object)itemObject.getImageDescriptor());
        MenuManagerTest.assertSame((Object)itemInfo_1.getBounds(), (Object)itemObject.getBounds());
        Assertions.assertThat((int)itemObject.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)itemObject.getBounds().height).isGreaterThan(18);
        MenuManagerTest.assertNull((Object)itemObject.getMenu());
        MenuManagerTest.assertSame((Object)IMenuPolicy.NOOP, (Object)itemObject.getPolicy());
        IMenuItemInfo itemObject2 = MenuObjectInfoUtils.getMenuItemInfo((Object)subMenuInfo);
        MenuManagerTest.assertSame((Object)subMenuInfo, (Object)itemObject2.getModel());
        MenuManagerTest.assertNull((Object)itemObject2.getImageDescriptor());
        Assertions.assertThat((int)itemObject2.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)itemObject2.getBounds().height).isGreaterThan(18);
        MenuManagerTest.assertSame((Object)MenuObjectInfoUtils.getMenuInfo((Object)subMenuInfo), (Object)itemObject2.getMenu());
        MenuManagerTest.assertSame((Object)IMenuPolicy.NOOP, (Object)itemObject2.getPolicy());
        menuObject = MenuObjectInfoUtils.getMenuInfo((Object)subMenuInfo);
        MenuManagerTest.assertSame((Object)menuObject, (Object)menuObject.getModel());
        MenuManagerTest.assertNotNull((Object)menuObject.getImageDescriptor());
        Assertions.assertThat((int)menuObject.getBounds().width).isGreaterThan(50);
        Assertions.assertThat((int)menuObject.getBounds().height).isGreaterThan(18);
        MenuManagerTest.assertFalse((boolean)menuObject.isHorizontal());
        items = menuObject.getItems();
        Assertions.assertThat((List)items).hasSize(1);
        MenuManagerTest.assertSame((Object)itemInfo_2, (Object)((IMenuItemInfo)items.get(0)).getModel());
    }

    @Test
    public void test_IMenuInfo_CREATE_action() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action('Action') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        ActionInfo actionInfo = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        MenuManagerTest.assertFalse((boolean)menuPolicy.validateCreate((Object)this));
        MenuManagerTest.assertTrue((boolean)menuPolicy.validateCreate((Object)actionInfo));
        menuPolicy.commandCreate((Object)actionInfo, null);
        MenuManagerTest.assertSame((Object)actionInfo, (Object)((ActionContributionItemInfo)MenuObjectInfoUtils.m_selectingObject.getToolkitModel()).getAction());
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action('Action') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(action);", "    return menuManager;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_CREATE_actionIntoSubMenu() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action('Action') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      menuManager.add(subMenuManager);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        MenuManagerInfo subMenuInfo = (MenuManagerInfo)menuInfo.getItems().get(0);
        ActionInfo actionInfo = (ActionInfo)ActionContainerInfo.getActions((JavaInfo)window).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)subMenuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        MenuManagerTest.assertFalse((boolean)menuPolicy.validateCreate((Object)this));
        MenuManagerTest.assertTrue((boolean)menuPolicy.validateCreate((Object)actionInfo));
        menuPolicy.commandCreate((Object)actionInfo, null);
        MenuManagerTest.assertSame((Object)actionInfo, (Object)((ActionContributionItemInfo)MenuObjectInfoUtils.m_selectingObject.getToolkitModel()).getAction());
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action('Action') {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      menuManager.add(subMenuManager);", "      subMenuManager.add(action);", "    }", "    return menuManager;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_CREATE_menuManager() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        MenuManagerInfo newManager = (MenuManagerInfo)MenuManagerTest.createJavaInfo("org.eclipse.jface.action.MenuManager");
        MenuManagerTest.assertTrue((boolean)menuPolicy.validateCreate((Object)newManager));
        menuPolicy.commandCreate((Object)newManager, null);
        MenuManagerTest.assertSame((Object)newManager, (Object)MenuObjectInfoUtils.m_selectingObject.getToolkitModel());
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager menuManager_1 = new MenuManager('New MenuManager');", "      menuManager.add(menuManager_1);", "    }", "    return menuManager;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_CREATE_separator() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        ContributionItemInfo separator = (ContributionItemInfo)JavaInfoUtils.createJavaInfo((AstEditor)this.m_lastEditor, this.m_lastLoader.loadClass("org.eclipse.jface.action.Separator"), (CreationSupport)new ConstructorCreationSupport());
        MenuManagerTest.assertTrue((boolean)menuPolicy.validateCreate((Object)separator));
        menuPolicy.commandCreate((Object)separator, null);
        MenuManagerTest.assertSame((Object)separator, (Object)MenuObjectInfoUtils.m_selectingObject.getToolkitModel());
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(new Separator());", "    return menuManager;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_MOVE_1() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(new Separator('Item 1'));", "    menuManager.add(new Separator('Item 2'));", "    return menuManager;", "  }", "  protected Control createContents(Composite parent) {", "    Composite container = (Composite) super.createContents(parent);", "    return container;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        List menuItems = menuInfo.getItems();
        Assertions.assertThat((List)menuItems).hasSize(2);
        ContributionItemInfo itemInfo_1 = (ContributionItemInfo)menuItems.get(0);
        ContributionItemInfo itemInfo_2 = (ContributionItemInfo)menuItems.get(1);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        CompositeInfo containerInfo = (CompositeInfo)window.getChildren(CompositeInfo.class).get(0);
        MenuManagerTest.assertFalse((boolean)menuPolicy.validateMove((Object)containerInfo));
        MenuManagerTest.assertTrue((boolean)menuPolicy.validateMove((Object)itemInfo_2));
        menuPolicy.commandMove((Object)itemInfo_2, (Object)itemInfo_1);
        MenuManagerTest.assertSame((Object)itemInfo_2, (Object)MenuObjectInfoUtils.m_selectingObject.getToolkitModel());
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(new Separator('Item 2'));", "    menuManager.add(new Separator('Item 1'));", "    return menuManager;", "  }", "  protected Control createContents(Composite parent) {", "    Composite container = (Composite) super.createContents(parent);", "    return container;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_MOVE_2() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action() {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    menuManager.add(action);", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      menuManager.add(subMenuManager);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        List menuItems = menuInfo.getItems();
        Assertions.assertThat((List)menuItems).hasSize(2);
        ActionContributionItemInfo itemInfo = (ActionContributionItemInfo)menuItems.get(0);
        MenuManagerInfo subMenuInfo = (MenuManagerInfo)menuItems.get(1);
        MenuManagerTest.assertTrue((boolean)itemInfo.getCreationSupport().canReorder());
        MenuManagerTest.assertTrue((boolean)itemInfo.getCreationSupport().canReparent());
        subMenuInfo.command_MOVE((AbstractComponentInfo)itemInfo, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  private IAction action_2;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action() {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager subMenuManager = new MenuManager('Sub-menu');", "      menuManager.add(subMenuManager);", "      subMenuManager.add(action);", "    }", "    return menuManager;", "  }", "}");
        InvocationVoidAssociation association = (InvocationVoidAssociation)itemInfo.getAssociation();
        MenuManagerTest.assertEquals((Object)"subMenuManager.add(action)", (Object)association.getSource());
        MenuManagerTest.assertSame((Object)this.m_lastEditor.getAstUnit(), (Object)association.getInvocation().getRoot());
        window.refresh();
        MenuManagerTest.assertNoErrors((JavaInfo)window);
    }

    @Test
    public void test_IMenuInfo_MOVE_3() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action() {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager menuManager_1 = new MenuManager('111');", "      menuManager.add(menuManager_1);", "      menuManager_1.add(action);", "    }", "    {", "      MenuManager menuManager_2 = new MenuManager('222');", "      menuManager.add(menuManager_2);", "    }", "    return menuManager;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuManager = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        MenuManagerInfo menuManager_1 = (MenuManagerInfo)menuManager.getItems().get(0);
        menuManager.command_MOVE((AbstractComponentInfo)menuManager_1, null);
        this.assertEditor("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  private IAction action;", "  public Test(Shell parentShell) {", "    super(parentShell);", "    createActions();", "    addMenuBar();", "  }", "  private void createActions() {", "    action = new Action() {", "    };", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    {", "      MenuManager menuManager_2 = new MenuManager('222');", "      menuManager.add(menuManager_2);", "    }", "    {", "      MenuManager menuManager_1 = new MenuManager('111');", "      menuManager.add(menuManager_1);", "      menuManager_1.add(action);", "    }", "    return menuManager;", "  }", "}");
    }

    @Test
    public void test_IMenuInfo_PASTE() throws Exception {
        ApplicationWindowInfo window = (ApplicationWindowInfo)this.parseJavaInfo("import org.eclipse.jface.action.*;", "import org.eclipse.jface.window.*;", "public class Test extends ApplicationWindow {", "  public Test(Shell parentShell) {", "    super(parentShell);", "    addMenuBar();", "  }", "  protected MenuManager createMenuManager() {", "    MenuManager menuManager = super.createMenuManager();", "    return menuManager;", "  }", "  protected Control createContents(Composite parent) {", "    Composite container = (Composite) super.createContents(parent);", "    return container;", "  }", "}");
        window.refresh();
        MenuManagerInfo menuInfo = (MenuManagerInfo)window.getChildren(MenuManagerInfo.class).get(0);
        IMenuInfo menuObject = MenuObjectInfoUtils.getMenuInfo((Object)menuInfo);
        IMenuPolicy menuPolicy = menuObject.getPolicy();
        MenuManagerTest.assertFalse((boolean)menuPolicy.validatePaste(null));
        List objects = menuPolicy.commandPaste(null, null);
        Assertions.assertThat((List)objects).isEmpty();
    }
}

