/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Ignore;
import org.junit.Test;

public class CopyActionTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_noSelection() throws Exception {
        this.openContainer("public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}");
        IAction copyAction = this.getCopyAction();
        this.canvas.select(new Object[0]);
        CopyActionTest.assertFalse((boolean)copyAction.isEnabled());
    }

    @Test
    public void test_thisSelection() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}");
        IAction copyAction = this.getCopyAction();
        this.canvas.select(panel);
        CopyActionTest.assertFalse((boolean)copyAction.isEnabled());
    }

    @Ignore
    @Test
    public void test_copySingle() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton btn = new JButton();", "      add(btn);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(button);
        IAction copyAction = this.getCopyAction();
        CopyActionTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        CopyActionTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        EditPart targetEditPart = this.m_contentEditPart;
        this.canvas.moveTo((Object)targetEditPart, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    {", "      JButton btn = new JButton();", "      add(btn);", "    }", "  }", "}");
    }

    @Ignore
    @Test
    public void test_copyParentAndItsChild() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      {", "        JButton button = new JButton();", "        inner.add(button);", "      }", "    }", "  }", "}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.canvas.select(inner, button);
        IAction copyAction = this.getCopyAction();
        CopyActionTest.assertTrue((boolean)copyAction.isEnabled());
        copyAction.run();
        IAction pasteAction = this.getPasteAction();
        CopyActionTest.assertTrue((boolean)pasteAction.isEnabled());
        pasteAction.run();
        EditPart targetEditPart = this.m_contentEditPart;
        this.canvas.moveTo((Object)targetEditPart, 10, 10);
        this.canvas.click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel panel = new JPanel();", "      add(panel);", "      {", "        JButton button = new JButton();", "        panel.add(button);", "      }", "    }", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      {", "        JButton button = new JButton();", "        inner.add(button);", "      }", "    }", "  }", "}");
    }
}

