/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.databinding.rcp;

import java.util.List;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.parser.AstModelSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.eclipse.wb.tests.designer.databinding.rcp.UtilsTest;
import org.junit.BeforeClass;
import org.junit.Test;

public class AstModelSupportTest
extends AbstractJavaTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        AstModelSupportTest.do_projectCreate();
    }

    @Test
    public void test_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  public void foo() {", "    create('aaa');", "    String name = create('aaa');", "    foo(name, create('aaa'));", "  }", "  static String create(String value) {", "    return 'zzz: ' + value;", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)3L, (long)statements.size());
        MethodInvocation invocation0 = UtilsTest.getMethodInvocation(statements, 0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, (Expression)invocation0);
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)invocation0));
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_field_assignment_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  private String m_name;", "  public void foo() {", "    m_name = create('aaa');", "    String name = create('aaa');", "    foo(name, m_name);", "  }", "  static String create(String value) {", "    return 'zzz: ' + value;", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)3L, (long)statements.size());
        Assignment assignment = UtilsTest.getAssignment(statements, 0);
        AstModelSupportTest.assertInstanceOf(MethodInvocation.class, (Object)assignment.getRightHandSide());
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, assignment.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"m_name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
    }

    @Test
    public void test_local_variable_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  public void foo() {", "    String name = create('aaa');", "    String name2 = create('aaa');", "    foo(name, name2);", "  }", "  static String create(String value) {", "    return 'zzz: ' + value;", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)3L, (long)statements.size());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)statements.get(0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, ((VariableDeclarationFragment)DomGenerics.fragments((VariableDeclarationStatement)statement).get(0)).getInitializer());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_local_variable_assignment_method() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  public void foo() {", "    String name;", "    String name2 = create('aaa');", "    name = create('aaa');", "    foo(name, name2);", "  }", "  static String create(String value) {", "    return 'zzz: ' + value;", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)4L, (long)statements.size());
        Assignment statement2 = UtilsTest.getAssignment(statements, 2);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, statement2.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation3 = UtilsTest.getMethodInvocation(statements, 3);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(1)));
    }

    @Test
    public void test_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  public void foo() {", "    new String('aaa');", "    String name = new String('aaa');", "    foo(name, new String('aaa'));", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)3L, (long)statements.size());
        ClassInstanceCreation creation0 = UtilsTest.getClassInstanceCreation(statements, 0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, (Expression)creation0);
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)creation0));
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_field_assignment_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  private String m_name;", "  public void foo() {", "    m_name = new String('aaa');", "    String name = new String('aaa');", "    foo(name, m_name);", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)3L, (long)statements.size());
        Assignment assignment = UtilsTest.getAssignment(statements, 0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, assignment.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"m_name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation).get(1)));
    }

    @Test
    public void test_local_variable_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  public void foo() {", "    String name = new String('aaa');", "    String name2 = new String('aaa');", "    foo(name, name2);", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)3L, (long)statements.size());
        VariableDeclarationStatement statement = (VariableDeclarationStatement)statements.get(0);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, ((VariableDeclarationFragment)DomGenerics.fragments((VariableDeclarationStatement)statement).get(0)).getInitializer());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation2 = UtilsTest.getMethodInvocation(statements, 2);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation2).get(1)));
    }

    @Test
    public void test_local_variable_assignment_constructor() throws Exception {
        TypeDeclaration type = this.createTypeDeclaration_Test("public class Test {", "  public void foo() {", "    String name;", "    String name2 = new String('aaa');", "    name = new String('aaa');", "    foo(name, name2);", "  }", "  void foo(String name, String value) {", "  }", "}");
        MethodDeclaration method = AstNodeUtils.getMethodBySignature((TypeDeclaration)type, (String)"foo()");
        AstModelSupportTest.assertNotNull((Object)method);
        List statements = method.getBody().statements();
        AstModelSupportTest.assertNotNull((Object)statements);
        AstModelSupportTest.assertEquals((long)4L, (long)statements.size());
        Assignment statement2 = UtilsTest.getAssignment(statements, 2);
        TestModel model = new TestModel();
        AstModelSupportTest.assertNull((Object)model.getVariableIdentifier());
        AstModelSupport support = new AstModelSupport((AstObjectInfo)model, statement2.getRightHandSide());
        AstModelSupportTest.assertEquals((Object)"name", (Object)model.getVariableIdentifier());
        AstModelSupportTest.assertSame((Object)((Object)model), (Object)support.getModel());
        MethodInvocation invocation3 = UtilsTest.getMethodInvocation(statements, 3);
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertTrue((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(0)));
        AstModelSupportTest.assertFalse((boolean)support.isRepresentedBy((Expression)DomGenerics.arguments((MethodInvocation)invocation3).get(1)));
    }

    private static class TestModel
    extends AstObjectInfo {
        private TestModel() {
        }
    }
}

