/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.util.ast;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstReflectionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.junit.Before;
import org.junit.Test;

public class AstReflectionUtilsTest
extends AbstractJavaTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            AstReflectionUtilsTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getClass() throws Exception {
        this.createTypeDeclaration_Test("// filler filler filler filler filler", "import javax.swing.JPanel;", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        SimpleName name = (SimpleName)this.getNode("JPanel");
        ITypeBinding typeBinding = name.resolveTypeBinding();
        ProjectClassLoader classLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_javaProject);
        Class clazz = AstReflectionUtils.getClass((ClassLoader)classLoader, (ITypeBinding)typeBinding);
        AstReflectionUtilsTest.assertEquals((Object)"javax.swing.JPanel", (Object)clazz.getCanonicalName());
    }

    @Test
    public void test_updateForVarArgs_hasVarArgs() throws Exception {
        AstReflectionUtilsTest.setFileContentSrc("test/MyPanel.java", AstReflectionUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyPanel {", "  public void hasVarArgs(int value, String... names) {", "  }", "}"));
        AstReflectionUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.JButton;", "public class Test extends MyPanel {", "  public Test() {", "    hasVarArgs(1, 'a', 'b', 'c');", "  }", "}");
        ProjectClassLoader classLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_javaProject);
        MethodInvocation invocation = this.getNode("hasVarArgs(", MethodInvocation.class);
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        Object[] rawArguments = new Object[]{1, "a", "b", "c"};
        Object[] updatedArguments = AstReflectionUtils.updateForVarArgs((ClassLoader)classLoader, (IMethodBinding)methodBinding, (Object[])rawArguments);
        AstReflectionUtilsTest.assertArrayEquals((Object[])updatedArguments, (Object[])new Object[]{1, new String[]{"a", "b", "c"}});
        rawArguments = new Object[]{1, new String[]{"a", "b", "c"}};
        updatedArguments = AstReflectionUtils.updateForVarArgs((ClassLoader)classLoader, (IMethodBinding)methodBinding, (Object[])rawArguments);
        AstReflectionUtilsTest.assertArrayEquals((Object[])updatedArguments, (Object[])new Object[]{1, new String[]{"a", "b", "c"}});
        rawArguments = new Object[]{1, "a"};
        updatedArguments = AstReflectionUtils.updateForVarArgs((ClassLoader)classLoader, (IMethodBinding)methodBinding, (Object[])rawArguments);
        AstReflectionUtilsTest.assertArrayEquals((Object[])updatedArguments, (Object[])new Object[]{1, new String[]{"a"}});
        rawArguments = new Object[]{1};
        updatedArguments = AstReflectionUtils.updateForVarArgs((ClassLoader)classLoader, (IMethodBinding)methodBinding, (Object[])rawArguments);
        AstReflectionUtilsTest.assertArrayEquals((Object[])updatedArguments, (Object[])new Object[]{1, new String[0]});
    }

    @Test
    public void test_updateForVarArgs_noVarArgs() throws Exception {
        AstReflectionUtilsTest.setFileContentSrc("test/MyPanel.java", AstReflectionUtilsTest.getSourceDQ("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyPanel {", "  public void noVarArgs(int value, String name) {", "  }", "}"));
        AstReflectionUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.JButton;", "public class Test extends MyPanel {", "  public Test() {", "    noVarArgs(1, 'str');", "  }", "}");
        ProjectClassLoader classLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_javaProject);
        MethodInvocation invocation = this.getNode("noVarArgs(", MethodInvocation.class);
        IMethodBinding methodBinding = invocation.resolveMethodBinding();
        Object[] rawArguments = new Object[]{1, "str"};
        Object[] updatedArguments = AstReflectionUtils.updateForVarArgs((ClassLoader)classLoader, (IMethodBinding)methodBinding, (Object[])rawArguments);
        AstReflectionUtilsTest.assertArrayEquals((Object[])updatedArguments, (Object[])new Object[]{1, "str"});
    }

    @Test
    public void test_getConstructor_SuperConstructorInvocation() throws Exception {
        AstReflectionUtilsTest.setFileContentSrc("test/MyPanel.java", AstReflectionUtilsTest.getSourceDQ("package test;", "import javax.swing.JComponent;", "import javax.swing.JPanel;", "public class MyPanel extends JPanel {", "  public <T extends JComponent> MyPanel(String string, T value) {", "  }", "}"));
        AstReflectionUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.JButton;", "public class Test extends MyPanel {", "  public Test() {", "    super('test', new JButton());", "  }", "}");
        SuperConstructorInvocation superInvocation = (SuperConstructorInvocation)this.getNode("super(");
        ProjectClassLoader classLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_javaProject);
        Class<?> clazz = classLoader.loadClass("test.MyPanel");
        String signature = AstNodeUtils.getSuperSignature((SuperConstructorInvocation)superInvocation);
        Constructor constructor = ReflectionUtils.getConstructorBySignature(clazz, (String)signature);
        AstReflectionUtilsTest.assertNull((Object)constructor);
        Constructor constructor2 = AstReflectionUtils.getConstructor(clazz, (SuperConstructorInvocation)superInvocation);
        AstReflectionUtilsTest.assertNotNull((Object)constructor2);
    }

    @Test
    public void test_getConstructor_ClassInstanceCreation() throws Exception {
        AstReflectionUtilsTest.setFileContentSrc("test/MyPanel.java", AstReflectionUtilsTest.getSourceDQ("package test;", "import javax.swing.*;", "public class MyPanel extends JPanel {", "  public <T extends JComponent> MyPanel(String string, T value) {", "  }", "}"));
        AstReflectionUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.*;", "public class Test extends JPanel {", "  public Test() {", "    add(new MyPanel('test', new JButton()));", "  }", "}");
        ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)this.getNode("new MyPanel(");
        ProjectClassLoader classLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_javaProject);
        Class<?> clazz = classLoader.loadClass("test.MyPanel");
        String signature = AstNodeUtils.getCreationSignature((ClassInstanceCreation)classInstanceCreation);
        Constructor constructor = ReflectionUtils.getConstructorBySignature(clazz, (String)signature);
        AstReflectionUtilsTest.assertNull((Object)constructor);
        Constructor constructor2 = AstReflectionUtils.getConstructor(clazz, (ClassInstanceCreation)classInstanceCreation);
        AstReflectionUtilsTest.assertNotNull((Object)constructor2);
    }

    @Test
    public void test_getMethod_MethodInvocation() throws Exception {
        AstReflectionUtilsTest.setFileContentSrc("test/MyPanel.java", AstReflectionUtilsTest.getSourceDQ("package test;", "import javax.swing.JComponent;", "import javax.swing.JPanel;", "public class MyPanel extends JPanel {", "  public <T extends JComponent> T componentFactory(String string, T component) {", "    return component;", "  }", "}"));
        AstReflectionUtilsTest.waitForAutoBuild();
        this.createTypeDeclaration_Test("import javax.swing.JButton;", "public class Test extends MyPanel {", "  public Test() {", "    componentFactory('test', new JButton());", "  }", "}");
        MethodInvocation invocation = (MethodInvocation)AstNodeUtils.getEnclosingNode(this.getNode("componentFactory("), MethodInvocation.class);
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)m_javaProject);
        Class<?> clazz = projectClassLoader.loadClass("test.MyPanel");
        String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
        Method method = ReflectionUtils.getMethodBySignature(clazz, (String)signature);
        AstReflectionUtilsTest.assertNull((Object)method);
        signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
        method = ReflectionUtils.getMethodByGenericSignature(clazz, (String)signature);
        AstReflectionUtilsTest.assertNull((Object)method);
        Method method2 = AstReflectionUtils.getMethod(clazz, (MethodInvocation)invocation);
        AstReflectionUtilsTest.assertNotNull((Object)method2);
    }
}

