/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.wb.core.editor.palette.model.entry.TabOrderToolEntryInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.internal.core.gef.tools.TabOrderTool;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class TabOrderToolEntryInfoTest
extends AbstractPaletteTest {
    @Test
    public void test_noSelection() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        TabOrderToolEntryInfo entry = new TabOrderToolEntryInfo();
        TabOrderToolEntryInfoTest.assertEquals((Object)"Tab Order", (Object)entry.getName());
        TabOrderToolEntryInfoTest.assertNotNull((Object)entry.getIcon());
        IEditPartViewer viewer = (IEditPartViewer)Mockito.mock(IEditPartViewer.class);
        Mockito.when((Object)viewer.getSelectedEditParts()).thenReturn(Collections.emptyList());
        TabOrderToolEntryInfoTest.assertTrue((boolean)entry.initialize(viewer, panel));
        TabOrderToolEntryInfoTest.assertNull((Object)entry.createTool());
        ((IEditPartViewer)Mockito.verify((Object)viewer)).getSelectedEditParts();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{viewer});
    }

    @Test
    public void test_singleSelection() throws Exception {
        JavaInfo panel = this.parseEmptyPanel();
        TabOrderToolEntryInfo entry = new TabOrderToolEntryInfo();
        TabOrderToolEntryInfoTest.assertEquals((Object)"Tab Order", (Object)entry.getName());
        TabOrderToolEntryInfoTest.assertNotNull((Object)entry.getIcon());
        InOrder inOrder = null;
        EditPolicy tabContainerRole = (EditPolicy)Mockito.mock(EditPolicy.class);
        EditPart selectedEditPart = (EditPart)Mockito.mock(EditPart.class);
        IEditPartViewer viewer = (IEditPartViewer)Mockito.mock(IEditPartViewer.class);
        inOrder = Mockito.inOrder((Object[])new Object[]{tabContainerRole, selectedEditPart, viewer});
        Mockito.when((Object)selectedEditPart.getViewer()).thenReturn((Object)viewer);
        Mockito.when((Object)selectedEditPart.getEditPolicy((Object)"tab container role")).thenReturn((Object)tabContainerRole);
        ((IEditPartViewer)Mockito.doReturn(List.of(selectedEditPart)).when((Object)viewer)).getSelectedEditParts();
        TabOrderToolEntryInfoTest.assertTrue((boolean)entry.initialize(viewer, panel));
        TabOrderToolEntryInfoTest.assertInstanceOf(TabOrderTool.class, (Object)entry.createTool());
        ((IEditPartViewer)inOrder.verify((Object)viewer)).getSelectedEditParts();
        ((IEditPartViewer)inOrder.verify((Object)viewer)).addSelectionChangedListener((ISelectionChangedListener)ArgumentMatchers.any());
        ((EditPart)inOrder.verify((Object)selectedEditPart)).getEditPolicy((Object)"tab container role");
        inOrder.verifyNoMoreInteractions();
    }
}

