/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.Locale;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.Test;

public class LocaleInfoTest
extends DesignerTestCase {
    @Test
    public void test_default() throws Exception {
        LocaleInfo locale = LocaleInfo.DEFAULT;
        LocaleInfoTest.assertNull((Object)locale.getLocale());
        LocaleInfoTest.assertTrue((boolean)locale.isDefault());
        LocaleInfoTest.assertEquals((Object)"(default)", (Object)locale.getTitle());
    }

    @Test
    public void test_italian() throws Exception {
        LocaleInfo locale = new LocaleInfo(Locale.ITALIAN);
        LocaleInfoTest.assertSame((Object)Locale.ITALIAN, (Object)locale.getLocale());
        LocaleInfoTest.assertEquals((Object)"it", (Object)locale.getTitle());
    }

    @Test
    public void test_toString() throws Exception {
        LocaleInfoTest.assertEquals((Object)"it", (Object)new LocaleInfo(Locale.ITALIAN).toString());
    }

    @Test
    public void test_equals() throws Exception {
        LocaleInfo locale_it = new LocaleInfo(Locale.ITALIAN);
        LocaleInfo locale_fr = new LocaleInfo(Locale.FRENCH);
        LocaleInfoTest.assertTrue((boolean)LocaleInfo.DEFAULT.equals((Object)new LocaleInfo(null)));
        LocaleInfoTest.assertTrue((boolean)locale_it.equals((Object)locale_it));
        LocaleInfoTest.assertFalse((boolean)locale_it.equals((Object)locale_fr));
        LocaleInfoTest.assertFalse((boolean)locale_it.equals((Object)this));
    }

    @Test
    public void test_hasCode() throws Exception {
        LocaleInfoTest.assertEquals((long)0L, (long)LocaleInfo.DEFAULT.hashCode());
        LocaleInfoTest.assertTrue((new LocaleInfo(Locale.ITALIAN).hashCode() != 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_getParent() throws Exception {
        LocaleInfo[] locales = new LocaleInfo[]{new LocaleInfo(new Locale("fr", "FR")), new LocaleInfo(new Locale("ru"))};
        LocaleInfoTest.assertSame((Object)locales[1], (Object)new LocaleInfo(new Locale("ru", "RU")).getParent(locales));
        LocaleInfoTest.assertSame((Object)LocaleInfo.DEFAULT, (Object)new LocaleInfo(new Locale("ru")).getParent(locales));
    }
}

