/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.JTextField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.LocalUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.Test;

public class LocalUniqueTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseCase_1();
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        LocalUniqueTest.assertTrue((boolean)(variableSupport instanceof LocalUniqueVariableSupport));
        LocalUniqueTest.assertTrue((boolean)variableSupport.hasName());
        LocalUniqueTest.assertSame((Object)button, (Object)variableSupport.getJavaInfo());
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getTitle());
        LocalUniqueTest.assertEquals((Object)"local-unique: button", (Object)variableSupport.toString());
        LocalUniqueTest.assertTrue((boolean)variableSupport.canConvertLocalToField());
        LocalUniqueTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            LocalUniqueTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        button = (JavaInfo)panel.getChildrenComponents().get(1);
        variableSupport = button.getVariableSupport();
        LocalUniqueTest.assertTrue((boolean)(variableSupport instanceof LocalUniqueVariableSupport));
        LocalUniqueTest.assertTrue((boolean)variableSupport.hasName());
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getName());
    }

    @Test
    public void test_setName() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        variableSupport.setName("abc");
        LocalUniqueTest.assertAST(this.m_lastEditor);
        LocalUniqueTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  public Test() {", "    JButton abc = new JButton();", "    add(abc);", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_toField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        LocalUniqueTest.check_toField(panel, this.getTestSource("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}"));
    }

    @Test
    public void test_toFieldStatic() throws Exception {
        ContainerInfo button = this.parseContainer("public class Test {", "  public static void main(String [] args) {", "    JButton button = new JButton();", "  }", "}");
        button.getVariableSupport().convertLocalToField();
        this.assertEditor("public class Test {", "  private static JButton button;", "  public static void main(String [] args) {", "    button = new JButton();", "  }", "}");
    }

    @Test
    public void test_toFieldStatic2() throws Exception {
        this.m_waitForAutoBuild = true;
        ContainerInfo button = this.parseContainer("public class Test {", "  public static void main(String [] args) {", "    Test application = new Test();", "    application.open();", "  }", "  public void open() {", "    JButton button = new JButton();", "  }", "}");
        button.getVariableSupport().convertLocalToField();
        this.assertEditor("public class Test {", "  private JButton button;", "  public static void main(String [] args) {", "    Test application = new Test();", "    application.open();", "  }", "  public void open() {", "    button = new JButton();", "  }", "}");
    }

    @Test
    public void test_toField_withPrefixes() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        Map options = ProjectUtils.getOptions((IJavaProject)javaProject);
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "m_");
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", "_Q");
        try {
            LocalUniqueTest.check_toField(panel, this.getTestSource("public class Test extends JPanel {", "  private JButton m_button_Q;", "  public Test() {", "    m_button_Q = new JButton();", "    add(m_button_Q);", "  }", "}"));
        }
        finally {
            javaProject.setOptions(options);
        }
    }

    @Test
    public void test_toField_assignment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    button = new JButton();", "    add(button);", "  }", "}");
        LocalUniqueTest.check_toField(panel, this.getTestSource("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}"));
    }

    @Test
    public void test_toField_numberPrefix() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button_1 = new JButton();", "    add(button_1);", "  }", "}");
        LocalUniqueTest.check_toField(panel, this.getTestSource("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}"));
    }

    @Test
    public void test_toField_afterExistingField() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private int m_value;", "  public Test() {", "    JButton button_1 = new JButton();", "    add(button_1);", "  }", "}");
        LocalUniqueTest.check_toField(panel, this.getTestSource("public class Test extends JPanel {", "  private int m_value;", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}"));
    }

    private static void check_toField(ContainerInfo panel, String expectedSource) throws Exception {
        AstEditor editor = panel.getEditor();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        button.getVariableSupport().convertLocalToField();
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        LocalUniqueTest.assertAST(editor);
        LocalUniqueTest.assertEquals((Object)expectedSource, (Object)editor.getSource());
    }

    @Test
    public void test_hasExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, true, 0);
        LocalUniqueTest.assertFalse((boolean)variableSupport.hasExpression(target));
        target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        LocalUniqueTest.assertTrue((boolean)variableSupport.hasExpression(target));
    }

    @Test
    public void test_getReferenceExpression_local_declarationWithInitializer() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
    }

    @Test
    public void test_getReferenceExpression_local_assignAfterDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button;", "    button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 2);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
    }

    @Test
    public void test_getReferenceExpression_local_beginOfBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    {", "      // empty block", "    }", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeBlockTarget((JavaInfo)panel, true, 2);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        LocalUniqueTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getReferenceExpression_local_endOfBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    {", "      // empty block", "    }", "  }", "}");
        String expectedSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeBlockTarget((JavaInfo)panel, false, 2);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        LocalUniqueTest.assertEditor(expectedSource, this.m_lastEditor);
        target = LocalUniqueTest.getNodeBlockTarget((JavaInfo)panel, false, new int[0]);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)variableSupport.getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        LocalUniqueTest.assertEditor(expectedSource, this.m_lastEditor);
    }

    @Test
    public void test_getReferenceExpression_remote_afterBlock() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_remote_afterBlock_asBeforeStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    int target;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, true, 1);
        LocalUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getReferenceExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      button = new JButton();", "      add(button);", "    }", "    int target;", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_remote_otherMethodOfExecutionFlow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    addButton();", "  }", "  private void addButton() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        LocalUniqueTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)button.getVariableSupport().getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    addButton();", "  }", "  private void addButton() {", "    button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_remote_invokedMethod() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    someInvokedMethod();", "  }", "  private void someInvokedMethod() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget target = LocalUniqueTest.getNodeStatementTarget((JavaInfo)panel, "someInvokedMethod()", true, new int[0]);
        LocalUniqueTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)button.getVariableSupport().getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "    someInvokedMethod();", "  }", "  private void someInvokedMethod() {", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_remote_methodBodyNotOfExecutionFlow() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "  private void externalMethod() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Block targetBlock = LocalUniqueTest.getBlock((JavaInfo)panel, "externalMethod()", new int[0]);
        NodeTarget target = new NodeTarget(new StatementTarget(targetBlock, true));
        LocalUniqueTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)button.getVariableSupport().getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "  private void externalMethod() {", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_remote_afterMethodDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        MethodDeclaration targetMethod = (MethodDeclaration)LocalUniqueTest.getBodyDeclaration((JavaInfo)panel, 0);
        NodeTarget target = new NodeTarget(new BodyDeclarationTarget((BodyDeclaration)targetMethod, false));
        LocalUniqueTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)button.getVariableSupport().getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_getReferenceExpression_remote_endOfTypeDeclaration() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        TypeDeclaration targetType = LocalUniqueTest.getTypeDeclaration((JavaInfo)panel);
        NodeTarget target = new NodeTarget(new BodyDeclarationTarget(targetType, false));
        LocalUniqueTest.assertEquals((Object)"button", (Object)button.getVariableSupport().getReferenceExpression(target));
        LocalUniqueTest.assertEquals((Object)"button.", (Object)button.getVariableSupport().getAccessExpression(target));
        LocalUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof FieldUniqueVariableSupport));
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_target() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]){", "    JPanel panel = new JPanel();", "  }", "}");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName((CompilationUnit)this.m_lastEditor.getAstUnit(), (String)"Test");
        MethodDeclaration mainMethod = typeDeclaration.getMethods()[0];
        LocalUniqueTest.assertStatementTarget((JavaInfo)panel, null, (Statement)mainMethod.getBody().statements().get(0), false);
    }

    @Test
    public void test_isVisibleAt() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      System.out.println();", "    }", "    {", "      JButton button = new JButton('button 1');", "      add(button);", "      {", "        System.out.println();", "      }", "    }", "    {", "      JButton button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalUniqueTest.check_isVisibleAt(true, (JavaInfo)button, new int[]{1, 1});
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        LocalUniqueTest.check_isVisibleAt(true, (JavaInfo)button, nArray);
        LocalUniqueTest.check_isVisibleAt(false, (JavaInfo)button, new int[2]);
        LocalUniqueTest.check_isVisibleAt(false, (JavaInfo)button, new int[]{2});
        LocalUniqueTest.check_isVisibleAt(false, (JavaInfo)button, new int[]{2, 1});
    }

    private static void check_isVisibleAt(boolean expected, JavaInfo button, int[] indexes) throws Exception {
        TypeDeclaration typeDeclaration = (TypeDeclaration)button.getEditor().getAstUnit().types().get(0);
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        Statement statement = LocalUniqueTest.getStatement(methodDeclaration.getBody(), indexes);
        LocalUniqueTest.assertEquals((Object)expected, (Object)button.getVariableSupport().isValidStatementForChild(statement));
    }

    @Test
    public void test_ADD_normal() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LocalUniqueTest.createJButton();
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_final() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = LocalUniqueTest.createJButton();
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        panel.getDescription().getToolkit().getPreferences().setValue("variable.localUnique.final", true);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      final JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_forcedField() throws Exception {
        ToolkitDescriptionJava toolkit = ToolkitProvider.DESCRIPTION;
        ArrayList<NamesManager.ComponentNameDescription> descriptions = new ArrayList<NamesManager.ComponentNameDescription>();
        descriptions.add(new NamesManager.ComponentNameDescription("javax.swing.JTextField", "textField", "txt", true));
        NamesManager.setNameDescriptions((ToolkitDescription)toolkit, descriptions);
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        SwingTestUtils.setGenerations(LocalUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        try {
            ComponentInfo newComponent = LocalUniqueTest.createComponent(JTextField.class);
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private JTextField textField;", "  public Test() {", "    {", "      textField = new JTextField();", "      add(textField);", "      textField.setColumns(10);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_beforeAssociation() throws Exception {
        LocalUniqueTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        LocalUniqueTest.setFileContentSrc("test/MyButton.wbp-component.xml", LocalUniqueTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton()]]></source>", "    <invocation signature='setText(java.lang.String)'><![CDATA['New Button']]></invocation>", "  </creation>", "  <method-order>", "    <default order='beforeAssociation'/>", "  </method-order>", "</component>"));
        LocalUniqueTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)LocalUniqueTest.createJavaInfo("test.MyButton");
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      myButton.setText('New Button');", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_variableName_inCreationSource() throws Exception {
        LocalUniqueTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton(String text) {", "  }", "}"));
        LocalUniqueTest.setFileContentSrc("test/MyButton.wbp-component.xml", LocalUniqueTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton('%variable-name%')]]></source>", "  </creation>", "</component>"));
        LocalUniqueTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)LocalUniqueTest.createJavaInfo("test.MyButton");
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton('myButton');", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_typeArguments() throws Exception {
        LocalUniqueTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<K, V> extends JButton {", "}"));
        LocalUniqueTest.setFileContentSrc("test/MyButton.wbp-component.xml", LocalUniqueTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%keyType%, %valueType%>()]]></source>", "  </creation>", "</component>"));
        LocalUniqueTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo newButton = (ComponentInfo)LocalUniqueTest.createJavaInfo("test.MyButton");
        newButton.putTemplateArgument("keyType", "java.lang.String");
        newButton.putTemplateArgument("valueType", "java.util.List<java.lang.Double>");
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("import java.util.List;", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton<String, List<Double>> myButton = new MyButton<String, List<Double>>();", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_delete_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "// filler filler filler", "public class  Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "}", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalUniqueTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "// filler filler filler", "public class  Test extends JPanel {", "  Test() {", "}", "}");
    }

    @Test
    public void test_delete_2() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "    JButton button;", "    button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalUniqueTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_3() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JPanel rootPanel = new JPanel();", "  }", "}");
        LocalUniqueTest.assertTrue((boolean)panel.canDelete());
        panel.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  public static void main(String[] args) {", "    JPanel rootPanel = new JPanel();", "  }", "}");
    }

    @Test
    public void test_delete_4() throws Exception {
        this.parseContainer("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "    JButton button_1 = new JButton(), button_2, button_3;", "    add(button_1);", "    button_2 = new JButton();", "    add(button_2);", "    button_3 = new JButton();", "    add(button_3);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)LocalUniqueTest.getJavaInfoByName("button_1");
        LocalUniqueTest.assertTrue((boolean)button_1.canDelete());
        button_1.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "    JButton button_2, button_3;", "    button_2 = new JButton();", "    add(button_2);", "    button_3 = new JButton();", "    add(button_3);", "  }", "}");
        ComponentInfo button_3 = (ComponentInfo)LocalUniqueTest.getJavaInfoByName("button_3");
        LocalUniqueTest.assertTrue((boolean)button_3.canDelete());
        button_3.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "    JButton button_2;", "    button_2 = new JButton();", "    add(button_2);", "  }", "}");
        ComponentInfo button_2 = (ComponentInfo)LocalUniqueTest.getJavaInfoByName("button_2");
        LocalUniqueTest.assertTrue((boolean)button_2.canDelete());
        button_2.delete();
        this.assertEditor("// filler filler filler", "public final class Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setType() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalUniqueVariableSupport variable = (LocalUniqueVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JTextField button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_inline_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    button.setEnabled(false);", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        LocalUniqueVariableSupport variableSupport = (LocalUniqueVariableSupport)button.getVariableSupport();
        LocalUniqueTest.assertFalse((boolean)variableSupport.canInline());
    }

    @Test
    public void test_inline_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CreationSupport creationSupport = button.getCreationSupport();
        ASTNode creationNode = creationSupport.getNode();
        LocalUniqueVariableSupport variableSupport = (LocalUniqueVariableSupport)button.getVariableSupport();
        LocalUniqueTest.assertTrue((boolean)variableSupport.canInline());
        variableSupport.inline();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        LocalUniqueTest.assertSame((Object)creationSupport, (Object)button.getCreationSupport());
        LocalUniqueTest.assertSame((Object)creationNode, (Object)creationSupport.getNode());
        variableSupport = (EmptyVariableSupport)button.getVariableSupport();
        LocalUniqueTest.assertSame((Object)creationNode, (Object)variableSupport.getInitializer());
    }

    @Test
    public void test_inline_3() throws Exception {
        LocalUniqueTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends JButton {", "  public MyButton(Container container) {", "    container.add(this);", "  }", "}"));
        LocalUniqueTest.setFileContentSrc("test/MyButton.wbp-component.xml", LocalUniqueTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <constructors>", "    <constructor>", "      <parameter type='java.awt.Container' parent='true'/>", "    </constructor>", "  </constructors>", "</component>"));
        LocalUniqueTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    MyButton button = (MyButton) new MyButton(this);", "    button.setEnabled(false);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        CreationSupport creationSupport = button.getCreationSupport();
        ASTNode creationNode = creationSupport.getNode();
        LocalUniqueVariableSupport variableSupport = (LocalUniqueVariableSupport)button.getVariableSupport();
        LocalUniqueTest.assertTrue((boolean)variableSupport.canInline());
        variableSupport.inline();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    ((MyButton) new MyButton(this)).setEnabled(false);", "  }", "}");
        LocalUniqueTest.assertSame((Object)creationSupport, (Object)button.getCreationSupport());
        LocalUniqueTest.assertSame((Object)creationNode, (Object)creationSupport.getNode());
        variableSupport = (EmptyVariableSupport)button.getVariableSupport();
        CastExpression casted = (CastExpression)variableSupport.getInitializer();
        LocalUniqueTest.assertSame((Object)creationNode, (Object)casted.getExpression());
        MethodInvocation invocation = button.getMethodInvocation("setEnabled(boolean)");
        LocalUniqueTest.assertNotNull((Object)invocation);
    }

    private ContainerInfo parseCase_1() throws Exception {
        return this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    {", "      final JButton button = new JButton('button 1');", "      add(button);", "      button.addActionListener(new ActionListener() {", "        public void actionPerformed(ActionEvent e) {", "          button.setVisible(false);", "        }", "      });", "    }", "    {", "      JButton button = new JButton('button 2');", "      add(button);", "    }", "  }", "}");
    }
}

