/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.model.variable.description.FieldUniqueVariableDescription;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.junit.Test;

public class FieldUniqueTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_object() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button_1;", "  private JButton button_2;", "  public Test() {", "    {", "      button_1 = new JButton('button 1');", "      add(button_1);", "    }", "    {", "      button_2 = new JButton('button 2');", "      add(button_2);", "    }", "  }", "}");
        FieldUniqueTest.assertEquals((long)2L, (long)panel.getChildrenComponents().size());
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldUniqueTest.assertTrue((boolean)(variableSupport instanceof FieldUniqueVariableSupport));
        FieldUniqueTest.assertTrue((boolean)variableSupport.hasName());
        FieldUniqueTest.assertEquals((Object)"field-unique: button_1", (Object)variableSupport.toString());
        FieldUniqueTest.assertEquals((Object)"button_1", (Object)variableSupport.getName());
        NodeTarget target = FieldUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 0, 1);
        FieldUniqueTest.assertEquals((Object)"button_1", (Object)variableSupport.getReferenceExpression(target));
        FieldUniqueTest.assertEquals((Object)"button_1.", (Object)variableSupport.getAccessExpression(target));
        FieldUniqueTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        FieldUniqueTest.assertTrue((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertLocalToField();
            FieldUniqueTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        button = (JavaInfo)panel.getChildrenComponents().get(1);
        variableSupport = button.getVariableSupport();
        FieldUniqueTest.assertTrue((boolean)(variableSupport instanceof FieldUniqueVariableSupport));
        FieldUniqueTest.assertEquals((Object)"button_2", (Object)variableSupport.getName());
    }

    @Test
    public void test_componentName() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton m_myButton_Q;", "  public Test() {", "    {", "      m_myButton_Q = new JButton();", "      add(m_myButton_Q);", "    }", "  }", "}");
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        FieldUniqueVariableSupport variableSupport = (FieldUniqueVariableSupport)button.getVariableSupport();
        Map options = ProjectUtils.getOptions((IJavaProject)javaProject);
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "m_");
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", "_Q");
        try {
            FieldUniqueTest.assertEquals((Object)"m_myButton_Q", (Object)variableSupport.getName());
            FieldUniqueTest.assertEquals((Object)"myButton", (Object)variableSupport.getComponentName());
        }
        finally {
            javaProject.setOptions(options);
        }
    }

    @Test
    public void test_isValidStatementForChild() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test {", "  private static JPanel panel;", "  public static void main(String args[]) {", "    {", "      panel = new JPanel();", "    }", "  }", "}");
        VariableSupport variableSupport = panel.getVariableSupport();
        Block mainBlock = this.getMethod("main(java.lang.String[])").getBody();
        Statement statement = FieldUniqueTest.getStatement(mainBlock, 0, 0);
        FieldUniqueTest.assertTrue((boolean)variableSupport.isValidStatementForChild(statement));
        statement = FieldUniqueTest.getStatement(mainBlock, 0);
        FieldUniqueTest.assertFalse((boolean)variableSupport.isValidStatementForChild(statement));
    }

    @Test
    public void test_noLocal() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "  void foo() {", "    button.setEnabled(false);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldUniqueTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
    }

    @Test
    public void test_setName() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldUniqueTest.assertTrue((boolean)(variableSupport instanceof FieldUniqueVariableSupport));
        variableSupport.setName("abc");
        FieldUniqueTest.assertSame((Object)variableSupport, (Object)button.getVariableSupport());
        FieldUniqueTest.assertAST(this.m_lastEditor);
        FieldUniqueTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  private JButton abc;", "  public Test() {", "    abc = new JButton();", "    add(abc);", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_setName_withApplicationStyleReference() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    new Thread() {", "      public void run() {", "        Test test = new Test();", "        test.button.setEnabled(true);", "      }", "    };", "    button = new JButton();", "    add(button);", "  }", "}");
        Object button = FieldUniqueTest.getJavaInfoByName("button");
        VariableSupport variableSupport = button.getVariableSupport();
        FieldUniqueTest.assertTrue((boolean)(variableSupport instanceof FieldUniqueVariableSupport));
        variableSupport.setName("abc");
        FieldUniqueTest.assertSame((Object)variableSupport, (Object)button.getVariableSupport());
        FieldUniqueTest.assertEditor(this.getTestSource("public class Test extends JPanel {", "  private JButton abc;", "  public Test() {", "    new Thread() {", "      public void run() {", "        Test test = new Test();", "        test.abc.setEnabled(true);", "      }", "    };", "    abc = new JButton();", "    add(abc);", "  }", "}"), this.m_lastEditor);
    }

    @Test
    public void test_toLocal_1_simple() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        button.getVariableSupport().convertFieldToLocal();
        FieldUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        FieldUniqueTest.assertAST(this.m_lastEditor);
        FieldUniqueTest.assertEquals((Object)this.getTestSource("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_toLocal_2_withPrefixes() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  private JButton m_button_Q;", "  public Test() {", "    m_button_Q = new JButton();", "    add(m_button_Q);", "  }", "}");
        IJavaProject javaProject = this.m_lastEditor.getJavaProject();
        Map options = ProjectUtils.getOptions((IJavaProject)javaProject);
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "m_");
        javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldSuffixes", "_Q");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        try {
            button.getVariableSupport().convertFieldToLocal();
            FieldUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        }
        finally {
            javaProject.setOptions(options);
        }
        FieldUniqueTest.assertTrue((boolean)(button.getVariableSupport() instanceof LocalUniqueVariableSupport));
        FieldUniqueTest.assertAST(this.m_lastEditor);
        FieldUniqueTest.assertEquals((Object)this.getTestSource("class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"), (Object)this.m_lastEditor.getSource());
    }

    @Test
    public void test_converts() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldUniqueTest.assertTrue((boolean)button.getVariableSupport().canConvertLocalToField());
        FieldUniqueTest.assertFalse((boolean)button.getVariableSupport().canConvertFieldToLocal());
        button.getVariableSupport().convertLocalToField();
        FieldUniqueTest.assertEquals((Object)this.getTestSource("class Test extends JPanel {", "  private JButton button;", "  Test() {", "    button = new JButton();", "    add(button);", "  }", "}"), (Object)this.m_lastEditor.getSource());
        FieldUniqueTest.assertAST(this.m_lastEditor);
        FieldUniqueTest.assertFalse((boolean)button.getVariableSupport().canConvertLocalToField());
        FieldUniqueTest.assertTrue((boolean)button.getVariableSupport().canConvertFieldToLocal());
        button.getVariableSupport().convertFieldToLocal();
        FieldUniqueTest.assertEquals((Object)this.getTestSource("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}"), (Object)this.m_lastEditor.getSource());
        FieldUniqueTest.assertAST(this.m_lastEditor);
        FieldUniqueTest.assertTrue((boolean)button.getVariableSupport().canConvertLocalToField());
        FieldUniqueTest.assertFalse((boolean)button.getVariableSupport().canConvertFieldToLocal());
        button.getVariableSupport().convertLocalToField();
        FieldUniqueTest.assertEquals((Object)this.getTestSource("class Test extends JPanel {", "  private JButton button;", "  Test() {", "    button = new JButton();", "    add(button);", "  }", "}"), (Object)this.m_lastEditor.getSource());
        FieldUniqueTest.assertAST(this.m_lastEditor);
    }

    @Test
    public void test_thisQualifier_parse() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  JButton button;", "  Test() {", "    this.button = new JButton();", "    add(this.button);", "  }", "}");
        FieldUniqueTest.assertEquals((long)1L, (long)panel.getChildrenComponents().size());
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        FieldUniqueTest.assertInstanceOf(FieldUniqueVariableSupport.class, (Object)variableSupport);
        FieldUniqueTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        variableSupport.setName("button2");
        this.assertEditor("class Test extends JPanel {", "  JButton button2;", "  Test() {", "    this.button2 = new JButton();", "    add(this.button2);", "  }", "}");
        FieldUniqueTest.assertTrue((boolean)button.getVariableSupport().canConvertFieldToLocal());
        button.getVariableSupport().convertFieldToLocal();
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JButton button2 = new JButton();", "    add(button2);", "  }", "}");
    }

    @Test
    public void test_thisQualifier_getReferenceExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  JButton m_button;", "  Test() {", "    this.m_button = new JButton();", "    add(this.m_button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        NodeTarget target = FieldUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 1);
        FieldUniqueTest.assertEquals((Object)"m_button", (Object)variableSupport.getReferenceExpression(target));
        button.getDescription().getToolkit().getPreferences().setValue("variable.fieldUnique.prefixThis", true);
        FieldUniqueTest.assertEquals((Object)"this.m_button", (Object)variableSupport.getReferenceExpression(target));
    }

    @Test
    public void test_getTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  static JPanel panel;", "  public static void main(String args[]){", "    panel = new JPanel();", "  }", "}");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName((CompilationUnit)this.m_lastEditor.getAstUnit(), (String)"Test");
        MethodDeclaration mainMethod = typeDeclaration.getMethods()[0];
        FieldUniqueTest.assertStatementTarget((JavaInfo)panel, null, (Statement)mainMethod.getBody().statements().get(0), false);
    }

    @Test
    public void test_ADD_private() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldUniqueTest.createJButton();
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        SwingTestUtils.setFieldUniqueModifier(0);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_public() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldUniqueTest.createJButton();
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        SwingTestUtils.setFieldUniqueModifier(2);
        try {
            flowLayout.add(newComponent, null);
        }
        finally {
            SwingTestUtils.setGenerationDefaults();
        }
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  protected JButton button;", "  public Test() {", "    {", "      button = new JButton();", "      add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_static() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldUniqueTest.createJButton();
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        flowLayout.add(newComponent, null);
        this.assertEditor("public class Test {", "  private static JButton button;", "  public static void main(String args[]) {", "    JPanel panel = new JPanel();", "    {", "      button = new JButton();", "      panel.add(button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_static_withNonStaticAnonymous() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test {", "  public static void main(String args[]) {", "    EventQueue.invokeLater(new Runnable() {", "      public void run() {", "        JPanel panel = new JPanel();", "      }", "    });", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldUniqueTest.createJButton();
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        flowLayout.add(newComponent, null);
        this.assertEditor("public class Test {", "  private static JButton button;", "  public static void main(String args[]) {", "    EventQueue.invokeLater(new Runnable() {", "      public void run() {", "        JPanel panel = new JPanel();", "        {", "          button = new JButton();", "          panel.add(button);", "        }", "      }", "    });", "  }", "}");
    }

    @Test
    public void test_ADD_thisPrefix() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldUniqueTest.createJButton();
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        panel.getDescription().getToolkit().getPreferences().setValue("variable.fieldUnique.prefixThis", true);
        flowLayout.add(newComponent, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    {", "      this.button = new JButton();", "      add(this.button);", "    }", "  }", "}");
        FieldUniqueVariableSupport variableSupport = (FieldUniqueVariableSupport)newComponent.getVariableSupport();
        NodeTarget target = FieldUniqueTest.getNodeStatementTarget((JavaInfo)panel, false, 0, 1);
        FieldUniqueTest.assertEquals((Object)"this.button", (Object)variableSupport.getReferenceExpression(target));
        FieldUniqueTest.assertEquals((Object)"this.button.", (Object)variableSupport.getAccessExpression(target));
    }

    @Test
    public void test_ADD_configuredPrefix() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FlowLayoutInfo flowLayout = (FlowLayoutInfo)panel.getLayout();
        ComponentInfo newComponent = FieldUniqueTest.createJButton();
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        m_javaProject.setOption("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "m_");
        flowLayout.add(newComponent, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private JButton m_button;", "  public Test() {", "    {", "      m_button = new JButton();", "      add(m_button);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_variableName_inCreationSource() throws Exception {
        FieldUniqueTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "public class MyButton extends JButton {", "  public MyButton(String text) {", "  }", "}"));
        FieldUniqueTest.setFileContentSrc("test/MyButton.wbp-component.xml", FieldUniqueTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton('%variable-name%')]]></source>", "  </creation>", "</component>"));
        FieldUniqueTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        ComponentInfo button = (ComponentInfo)FieldUniqueTest.createJavaInfo("test.MyButton");
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        ((FlowLayoutInfo)panel.getLayout()).add(button, null);
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private MyButton myButton;", "  public Test() {", "    {", "      myButton = new MyButton('myButton');", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_typeArguments() throws Exception {
        FieldUniqueTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton<K, V> extends JButton {", "}"));
        FieldUniqueTest.setFileContentSrc("test/MyButton.wbp-component.xml", FieldUniqueTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <creation>", "    <source><![CDATA[new test.MyButton<%keyType%, %valueType%>()]]></source>", "  </creation>", "</component>"));
        FieldUniqueTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        SwingTestUtils.setGenerations(FieldUniqueVariableDescription.INSTANCE, BlockStatementGeneratorDescription.INSTANCE);
        ComponentInfo newButton = (ComponentInfo)FieldUniqueTest.createJavaInfo("test.MyButton");
        newButton.putTemplateArgument("keyType", "java.lang.String");
        newButton.putTemplateArgument("valueType", "java.util.List<java.lang.Double>");
        ((FlowLayoutInfo)panel.getLayout()).add(newButton, null);
        this.assertEditor("import java.util.List;", "// filler filler filler filler filler", "public class Test extends JPanel {", "  private MyButton<String, List<Double>> myButton;", "  public Test() {", "    {", "      myButton = new MyButton<String, List<Double>>();", "      add(myButton);", "    }", "  }", "}");
    }

    @Test
    public void test_delete_1() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FieldUniqueTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_2() throws Exception {
        this.parseContainer("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button_2;", "  public Test() {", "    JPanel inner = new JPanel();", "    add(inner);", "    //", "    JButton button_1 = new JButton();", "    inner.add(button_1);", "    //", "    button_2 = new JButton(button_1.getText());", "    inner.add(button_2);", "  }", "}");
        ComponentInfo inner = (ComponentInfo)FieldUniqueTest.getJavaInfoByName("inner");
        FieldUniqueTest.assertTrue((boolean)inner.canDelete());
        inner.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_delete_3() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  private static JPanel rootPanel;", "  public static void main(String[] args) {", "    rootPanel = new JPanel();", "  }", "}");
        FieldUniqueTest.assertTrue((boolean)panel.canDelete());
        panel.delete();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test {", "  private static JPanel rootPanel;", "  public static void main(String[] args) {", "    rootPanel = new JPanel();", "  }", "}");
    }

    @Test
    public void test_delete_4() throws Exception {
        this.parseContainer("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button_1, button_2, button_3;", "  public Test() {", "    button_1 = new JButton();", "    add(button_1);", "    //", "    button_2 = new JButton();", "    add(button_2);", "    //", "    button_3 = new JButton();", "    add(button_3);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)FieldUniqueTest.getJavaInfoByName("button_1");
        FieldUniqueTest.assertTrue((boolean)button_1.canDelete());
        button_1.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button_2, button_3;", "  public Test() {", "    //", "    button_2 = new JButton();", "    add(button_2);", "    //", "    button_3 = new JButton();", "    add(button_3);", "  }", "}");
        ComponentInfo button_3 = (ComponentInfo)FieldUniqueTest.getJavaInfoByName("button_3");
        FieldUniqueTest.assertTrue((boolean)button_3.canDelete());
        button_3.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  private JButton button_2;", "  public Test() {", "    //", "    button_2 = new JButton();", "    add(button_2);", "  }", "}");
        ComponentInfo button_2 = (ComponentInfo)FieldUniqueTest.getJavaInfoByName("button_2");
        FieldUniqueTest.assertTrue((boolean)button_2.canDelete());
        button_2.delete();
        this.assertEditor("// filler filler filler", "public class  Test extends JPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setType() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        JavaInfo button = (JavaInfo)panel.getChildrenComponents().get(0);
        FieldUniqueVariableSupport variable = (FieldUniqueVariableSupport)button.getVariableSupport();
        variable.setType("javax.swing.JTextField");
        this.assertEditor("public class Test extends JPanel {", "  private JTextField button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
    }
}

