/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.RenameConvertSupport;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.gef.UIRunnable;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.Test;
import org.mockito.Mockito;

public class RenameConvertSupportTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_action_zeroOrOne() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        RenameConvertSupportTest.assertNull((Object)this.getRenameAction(new ObjectInfo[0]));
        ObjectInfo objectMock = (ObjectInfo)Mockito.mock(ObjectInfo.class);
        RenameConvertSupportTest.assertNull((Object)this.getRenameAction(objectMock));
        RenameConvertSupportTest.assertNotNull((Object)RenameConvertSupportTest.getRenameAction((JavaInfo)button));
        MenuManager manager = RenameConvertSupportTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(null, (ObjectInfo)button, (IMenuManager)manager);
        RenameConvertSupportTest.assertNull((Object)RenameConvertSupportTest.findChildAction((IContributionManager)manager, "Rename..."));
        manager = RenameConvertSupportTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(List.of(button), (ObjectInfo)button, (IMenuManager)manager);
        RenameConvertSupportTest.assertNotNull((Object)RenameConvertSupportTest.findChildAction((IContributionManager)manager, "Rename..."));
    }

    @Test
    public void test_action_hashEquals() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IAction action = RenameConvertSupportTest.getRenameAction((JavaInfo)button);
        RenameConvertSupportTest.assertNotNull((Object)action);
        RenameConvertSupportTest.assertEquals((long)0L, (long)action.hashCode());
        RenameConvertSupportTest.assertEquals((Object)action, (Object)Mockito.mock(action.getClass()));
    }

    @Test
    public void test_action_multiSelect() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "    //", "    JTextField textField = new JTextField();", "    add(textField);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo textField = (ComponentInfo)panel.getChildrenComponents().get(1);
        RenameConvertSupportTest.assertNotNull((Object)this.getRenameAction(new ObjectInfo[]{button, textField}));
        List<ComponentInfo> objects = List.of(button, textField);
        MenuManager manager = RenameConvertSupportTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(objects, (ObjectInfo)button, (IMenuManager)manager);
        RenameConvertSupportTest.assertNotNull((Object)RenameConvertSupportTest.findChildAction((IContributionManager)manager, "Rename..."));
        manager = RenameConvertSupportTest.getDesignerMenuManager();
        button.getBroadcastObject().addContextMenu(objects, (ObjectInfo)textField, (IMenuManager)manager);
        RenameConvertSupportTest.assertNotNull((Object)RenameConvertSupportTest.findChildAction((IContributionManager)manager, "Rename..."));
    }

    @Test
    public void test_animateUI_openDialog() throws Exception {
        this.parseContainer("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        final ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                RenameConvertSupport.rename(List.of(button));
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Rename/convert");
                context.clickButton("Cancel");
            }
        });
    }

    @Test
    public void test_animateUI_setName() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        final IAction renameAction = RenameConvertSupportTest.getRenameAction((JavaInfo)button);
        RenameConvertSupportTest.assertNotNull((Object)renameAction);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                renameAction.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Rename/convert");
                try {
                    Text nameField = context.getTextByText("button");
                    nameField.setText("myButton");
                    context.clickButton("OK");
                }
                catch (Throwable e) {
                    context.clickButton("Cancel");
                }
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton myButton = new JButton();", "    add(myButton);", "  }", "}");
    }

    @Test
    public void test_animateUI_toField() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        final IAction renameAction = RenameConvertSupportTest.getRenameAction((JavaInfo)button);
        RenameConvertSupportTest.assertNotNull((Object)renameAction);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                renameAction.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Rename/convert");
                try {
                    ToolItem item = context.getToolItem("Be field");
                    context.click(item, 0);
                    context.clickButton("OK");
                }
                catch (Throwable e) {
                    context.clickButton("Cancel");
                }
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_animateUI_setName_lazy() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    add(getButton());", "  }", "  private JButton getButton() {", "    if (button == null) {", "      button = new JButton();", "    }", "    return button;", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        final IAction renameAction = RenameConvertSupportTest.getRenameAction((JavaInfo)button);
        RenameConvertSupportTest.assertNotNull((Object)renameAction);
        new UiContext().executeAndCheck(new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                renameAction.run();
            }
        }, new UIRunnable(){

            @Override
            public void run(UiContext context) throws Exception {
                context.useShell("Rename/convert");
                try {
                    Text nameField = context.getTextByText("button");
                    nameField.setText("myButton");
                    RenameConvertSupportTest.assertFalse((boolean)context.getToolItem("Be local").isEnabled());
                    RenameConvertSupportTest.assertFalse((boolean)context.getToolItem("Be field").isEnabled());
                    context.clickButton("OK");
                }
                catch (Throwable e) {
                    context.clickButton("Cancel");
                }
            }
        });
        this.assertEditor("public class Test extends JPanel {", "  private JButton myButton;", "  public Test() {", "    add(getMyButton());", "  }", "  private JButton getMyButton() {", "    if (myButton == null) {", "      myButton = new JButton();", "    }", "    return myButton;", "  }", "}");
    }

    private static IAction getRenameAction(JavaInfo javaInfo) throws Exception {
        IMenuManager contextMenu = RenameConvertSupportTest.getContextMenu(new ObjectInfo[]{javaInfo});
        return RenameConvertSupportTest.findChildAction((IContributionManager)contextMenu, "Rename...");
    }

    @Test
    public void test_commands_executeNoCommands() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        panel.addBroadcastListener((Object)new ObjectEventListener(){

            public void refreshed() throws Exception {
                RenameConvertSupportTest.fail((String)"No refresh expected.");
            }
        });
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{panel});
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
    }

    @Test
    public void test_commands_sameCommand() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{panel});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)panel);
        RenameConvertSupportTest.assertSame((Object)command, (Object)RenameConvertSupportTest.getCommand(support, (JavaInfo)panel));
    }

    @Test
    public void test_commands_setName_single() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"setName", String.class, (Object)"myButton");
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton myButton = new JButton();", "    add(myButton);", "  }", "}");
    }

    @Test
    public void test_commands_setName_autoUnique() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int myButton;", "    //", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"setName", String.class, (Object)"myButton");
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    int myButton;", "    //", "    JButton myButton_1 = new JButton();", "    add(myButton_1);", "  }", "}");
    }

    @Test
    public void test_commands_toField() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"toField");
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_commands_toLocal() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"toLocal");
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_commands_toField_toLocal() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        String initialSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"toField");
        ReflectionUtils.invokeMethod2((Object)command, (String)"toLocal");
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
        RenameConvertSupportTest.assertEditor(initialSource, this.m_lastEditor);
    }

    @Test
    public void test_commands_toLocal_toField() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  private JButton button;", "  public Test() {", "    button = new JButton();", "    add(button);", "  }", "}");
        String initialSource = this.m_lastEditor.getSource();
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"toLocal");
        ReflectionUtils.invokeMethod2((Object)command, (String)"toField");
        ReflectionUtils.invokeMethod((Object)support, (String)"executeCommands()", (Object[])new Object[0]);
        RenameConvertSupportTest.assertEditor(initialSource, this.m_lastEditor);
    }

    @Test
    public void test_validate_OK() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        RenameConvertSupportTest.assertNull((Object)RenameConvertSupportTest.validateCommands(support));
    }

    @Test
    public void test_validate_invalidIdentifier() throws Exception {
        this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)RenameConvertSupportTest.getJavaInfoByName("button");
        RenameConvertSupport support = this.getRenameSupport(new ObjectInfo[]{button});
        Object command = RenameConvertSupportTest.getCommand(support, (JavaInfo)button);
        ReflectionUtils.invokeMethod2((Object)command, (String)"setName", String.class, (Object)"invalid-name");
        RenameConvertSupportTest.assertTrue((boolean)RenameConvertSupportTest.validateCommands(support).contains("identifier"));
    }

    private RenameConvertSupport getRenameSupport(ObjectInfo ... objects) throws Exception {
        return (RenameConvertSupport)ReflectionUtils.getConstructor(RenameConvertSupport.class, (Class[])new Class[]{Iterable.class}).newInstance(List.of(objects));
    }

    private static Object getCommand(RenameConvertSupport support, JavaInfo javaInfo) throws Exception {
        return ReflectionUtils.invokeMethod2((Object)support, (String)"getCommand", JavaInfo.class, (Object)javaInfo);
    }

    private static String validateCommands(RenameConvertSupport support) throws Exception {
        return (String)ReflectionUtils.invokeMethod2((Object)support, (String)"validateCommands");
    }

    private IAction getRenameAction(ObjectInfo ... objects) {
        MenuManager menuManager = RenameConvertSupportTest.getDesignerMenuManager();
        RenameConvertSupport.contribute(List.of(objects), (IContributionManager)menuManager);
        return RenameConvertSupportTest.findChildAction((IContributionManager)menuManager, "Rename...");
    }
}

