/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.table;

import org.eclipse.draw2d.Cursors;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.IntegerPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.string.StringPropertyEditor;
import org.eclipse.wb.tests.designer.core.model.property.table.AbstractPropertyTableTest;
import org.junit.Before;
import org.junit.Test;

public class PropertyTableTest
extends AbstractPropertyTableTest {
    private AbstractPropertyTableTest.TestProperty m_locationProperty;
    private AbstractPropertyTableTest.TestProperty m_boundsProperty;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        PropertyEditor stringEditor = StringPropertyEditor.INSTANCE;
        IntegerPropertyEditor intEditor = IntegerPropertyEditor.INSTANCE;
        AbstractPropertyTableTest.ComplexEditor locationEditor = new AbstractPropertyTableTest.ComplexEditor(new Property[]{new AbstractPropertyTableTest.TestProperty("x", false, 100, (PropertyEditor)intEditor), new AbstractPropertyTableTest.TestProperty("y", false, 150, (PropertyEditor)intEditor)});
        this.m_locationProperty = new AbstractPropertyTableTest.TestProperty("location", true, "(100, 150)", (PropertyEditor)locationEditor);
        AbstractPropertyTableTest.ComplexEditor boundsEditor = new AbstractPropertyTableTest.ComplexEditor(new Property[]{this.m_locationProperty, new AbstractPropertyTableTest.TestProperty("width", false, 50, (PropertyEditor)intEditor), new AbstractPropertyTableTest.TestProperty("height", false, 10, (PropertyEditor)intEditor)});
        this.m_boundsProperty = new AbstractPropertyTableTest.TestProperty("bounds", true, "(100, 150, 50, 10)", (PropertyEditor)boundsEditor);
        this.m_propertyTable.setInput(new Property[]{new AbstractPropertyTableTest.TestProperty("text 1", true, "New button", stringEditor), new AbstractPropertyTableTest.TestProperty("text 2", true, "New button", stringEditor), new AbstractPropertyTableTest.TestProperty("text 3", true, "New button", stringEditor), new AbstractPropertyTableTest.TestProperty("variable", false, "button", stringEditor), new AbstractPropertyTableTest.TestProperty("tooltip", true, "Very long description of component", stringEditor), this.m_boundsProperty});
        PropertyTableTest.waitEventLoop(0);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_setInput_null() throws Exception {
        this.m_propertyTable.setInput(null);
        PropertyTableTest.waitEventLoop(0);
    }

    @Test
    public void test_cursor() throws Exception {
        this.m_sender.moveTo(10, 10);
        PropertyTableTest.assertNull((Object)this.m_propertyTable.getControl().getCursor());
        int splitter = this.m_propertyTable.forTests_getSplitter();
        int x = splitter - 1;
        while (x <= splitter + 1) {
            this.m_sender.moveTo(x, 10);
            PropertyTableTest.assertSame((Object)Cursors.SIZEWE, (Object)this.m_propertyTable.getControl().getCursor());
            ++x;
        }
        this.m_sender.moveTo(splitter + 2, 10);
        PropertyTableTest.assertNull((Object)this.m_propertyTable.getControl().getCursor());
    }

    @Test
    public void test_splitter() throws Exception {
        int width = this.m_propertyTable.getControl().getClientArea().width;
        int splitter = (int)((double)width * 0.4);
        PropertyTableTest.assertEquals((long)splitter, (long)this.m_propertyTable.forTests_getSplitter());
        splitter = this.check_dragSplitter(splitter, 100, 100);
        splitter = this.check_dragSplitter(splitter, 10, 75);
        splitter = this.check_dragSplitter(splitter, width - 10, width - 75);
    }

    private int check_dragSplitter(int from, int to, int expected) throws InterruptedException {
        this.m_sender.startDrag(from, 10, 1);
        this.m_sender.dragTo(to, 10);
        this.m_sender.endDrag();
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)expected, (long)this.m_propertyTable.forTests_getSplitter());
        return this.m_propertyTable.forTests_getSplitter();
    }

    @Test
    public void test_expandCollapse() throws Exception {
        PropertyTableTest.assertNull((Object)this.m_propertyTable.forTests_getStateLocation(null));
        Point boundsL = this.m_propertyTable.forTests_getStateLocation((Property)this.m_boundsProperty);
        PropertyTableTest.assertNotNull((Object)boundsL);
        PropertyTableTest.assertEquals((long)6L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        this.m_sender.click(boundsL, 1);
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)9L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        Point locationL = this.m_propertyTable.forTests_getStateLocation((Property)this.m_locationProperty);
        PropertyTableTest.assertNotNull((Object)locationL);
        this.m_sender.click(locationL, 1);
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)11L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        this.m_sender.click(boundsL, 1);
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)6L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        this.m_sender.click(boundsL, 1);
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)11L, (long)this.m_propertyTable.forTests_getPropertiesCount());
    }

    @Test
    public void test_noPropertiesClip() throws Exception {
        this.m_propertyTable.setInput(null);
        this.m_shell.setSize(100, 100);
        PropertyTableTest.waitEventLoop(0);
    }

    @Test
    public void test_setInput_complexPropertySubPropertiesChanged() throws Exception {
        AbstractPropertyTableTest.TestProperty propertyA = new AbstractPropertyTableTest.TestProperty("a", true, 1, (PropertyEditor)IntegerPropertyEditor.INSTANCE);
        AbstractPropertyTableTest.TestProperty propertyB = new AbstractPropertyTableTest.TestProperty("b", true, 2, (PropertyEditor)IntegerPropertyEditor.INSTANCE);
        ComplexProperty complexProperty = new ComplexProperty("complex", "(Dynamic complex property)");
        complexProperty.setProperties(new Property[]{propertyA});
        this.m_propertyTable.setInput(new Property[]{complexProperty});
        PropertyTableTest.waitEventLoop(0);
        Point stateLocation = this.m_propertyTable.forTests_getStateLocation((Property)complexProperty);
        PropertyTableTest.assertNotNull((Object)stateLocation);
        PropertyTableTest.assertEquals((long)1L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        this.m_sender.click(stateLocation, 1);
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)2L, (long)this.m_propertyTable.forTests_getPropertiesCount());
        complexProperty.setProperties(new Property[]{propertyA, propertyB});
        this.m_propertyTable.setInput(new Property[]{complexProperty});
        PropertyTableTest.waitEventLoop(0);
        PropertyTableTest.assertEquals((long)3L, (long)this.m_propertyTable.forTests_getPropertiesCount());
    }
}

