/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.EnumerationValuesPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class EnumerationValuesPropertyEditorTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_bad_notArray() throws Exception {
        this.prepareMyPanel("'notArrayValue'");
        this.check_bad();
    }

    @Test
    public void test_bad_notObjectArray() throws Exception {
        this.prepareMyPanel("new int[0]");
        this.check_bad();
    }

    @Test
    public void test_bad_isArray_notArrayValue() throws Exception {
        this.prepareMyPanel("new Object[]{'a', 'b'}");
        this.check_bad();
    }

    @Test
    public void test_bad_isArray_notMultiple3() throws Exception {
        this.prepareMyPanel("new Object[]{'a', null, '0', 'b'}");
        this.check_bad();
    }

    @Test
    public void test_bad_isArray_notStringObjectString_1() throws Exception {
        this.prepareMyPanel("new Object[]{null, null, '0'}");
        this.check_bad();
    }

    @Test
    public void test_bad_isArray_notStringObjectString_2() throws Exception {
        this.prepareMyPanel("new Object[]{'a', null, null}");
        this.check_bad();
    }

    @Test
    public void test_bad_isArray_notStringObjectString_3() throws Exception {
        this.prepareMyPanel("new Object[]{'a', null, '0', 'b', null, null}");
        this.check_bad();
    }

    private void check_bad() throws Exception {
        GenericProperty property = this.getValueProperty();
        EnumerationValuesPropertyEditorTest.assertNotInstanceOf(EnumerationValuesPropertyEditor.class, property.getEditor());
    }

    @Test
    public void test_0() throws Exception {
        this.prepareMyPanel("new Object[]{'a', 1, '1', 'b', 2, '2'}");
        GenericProperty property = this.getValueProperty();
        PropertyEditor editor = property.getEditor();
        IValueSourcePropertyEditor sourceEditor = (IValueSourcePropertyEditor)editor;
        EnumerationValuesPropertyEditorTest.assertEquals(null, (Object)sourceEditor.getValueSource((Object)0));
        EnumerationValuesPropertyEditorTest.assertEquals((Object)"1", (Object)sourceEditor.getValueSource((Object)1));
        EnumerationValuesPropertyEditorTest.assertEquals((Object)"2", (Object)sourceEditor.getValueSource((Object)2));
        EnumerationValuesPropertyEditorTest.assertEquals(null, (Object)EnumerationValuesPropertyEditorTest.getPropertyText((Property)property));
        EnumerationValuesPropertyEditorTest.assertEquals(null, (Object)((IClipboardSourceProvider)editor).getClipboardSource(property));
        property.setValue((Object)1);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setValue(1);", "  }", "}");
        EnumerationValuesPropertyEditorTest.assertEquals((Object)"a", (Object)EnumerationValuesPropertyEditorTest.getPropertyText((Property)property));
        EnumerationValuesPropertyEditorTest.assertEquals((Object)"1", (Object)((IClipboardSourceProvider)editor).getClipboardSource(property));
    }

    private void prepareMyPanel(String attributeValue) throws Exception {
        EnumerationValuesPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setValue(Object value) {", "  }", "}"));
        String[] lines = new String[]{"import java.beans.*;", "public class MyPanelBeanInfo extends SimpleBeanInfo {", "  private PropertyDescriptor[] m_descriptors;", "  public MyPanelBeanInfo() {", "    try {", "      m_descriptors = new PropertyDescriptor[1];", "      m_descriptors[0] = new PropertyDescriptor('value', MyPanel.class, null, 'setValue');", "      m_descriptors[0].setValue('enumerationValues', " + attributeValue + ");", "    } catch (Throwable e) {", "    }", "  }", "  public PropertyDescriptor[] getPropertyDescriptors() {", "    return m_descriptors;", "  }", "}"};
        EnumerationValuesPropertyEditorTest.setFileContentSrc("test/MyPanelBeanInfo.java", this.getTestSource(lines));
        EnumerationValuesPropertyEditorTest.waitForAutoBuild();
    }

    private GenericProperty getValueProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        GenericProperty property = (GenericProperty)panel.getPropertyByTitle("value");
        EnumerationValuesPropertyEditorTest.assertNotNull((Object)property);
        return property;
    }
}

