/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.generic;

import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ContainerObjectValidatorsTest
extends SwingModelTest {
    @Test
    public void test_alwaysTrue() throws Exception {
        ContainerObjectValidator validator = ContainerObjectValidators.alwaysTrue();
        ContainerObjectValidatorsTest.assertEquals((Object)"alwaysTrue", (Object)validator.toString());
        ContainerObjectValidatorsTest.assertTrue((boolean)validator.validate(null, null));
    }

    @Test
    public void test_forList() throws Exception {
        String typesString = "javax.swing.JButton javax.swing.JTextField";
        String[] types = StringUtils.split((String)typesString);
        ContainerObjectValidator validator = ContainerObjectValidators.forList((String[])types);
        ContainerObjectValidatorsTest.assertEquals((Object)typesString, (Object)validator.toString());
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    add(new JTextField());", "    add(new JLabel());", "  }", "}");
        ContainerObjectValidatorsTest.assertFalse((boolean)validator.validate(null, null));
        ContainerObjectValidatorsTest.assertFalse((boolean)validator.validate(null, new Object()));
        ContainerObjectValidatorsTest.assertTrue((boolean)validator.validate(null, panel.getChildrenComponents().get(0)));
        ContainerObjectValidatorsTest.assertTrue((boolean)validator.validate(null, panel.getChildrenComponents().get(1)));
        ContainerObjectValidatorsTest.assertFalse((boolean)validator.validate(null, panel.getChildrenComponents().get(2)));
    }

    @Test
    public void test_forContainerExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerObjectValidatorsTest.assertContainerValidatorFalse("no matter", (Object)this);
        ContainerObjectValidatorsTest.assertContainerValidatorTrue("true", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorFalse("false", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorTrue("1 == 1", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorFalse("1 == 2", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorTrue("isContainerType('javax.swing.JPanel')", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorTrue("isContainerType('java.awt.Component')", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorFalse("isContainerType('javax.swing.JButton')", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorTrue("isContainerType('javax.swing.JButton')", button);
        ContainerObjectValidatorsTest.assertContainerValidatorTrue("isContainerThis()", panel);
        ContainerObjectValidatorsTest.assertContainerValidatorFalse("isContainerThis()", button);
    }

    private static void assertContainerValidatorFalse(String expression, Object container) {
        ContainerObjectValidatorsTest.assertContainerValidator(false, expression, container);
    }

    private static void assertContainerValidatorTrue(String expression, Object container) {
        ContainerObjectValidatorsTest.assertContainerValidator(true, expression, container);
    }

    private static void assertContainerValidator(boolean expected, String expression, Object container) {
        Predicate validator = ContainerObjectValidators.forContainerExpression((String)expression);
        ContainerObjectValidatorsTest.assertEquals((Object)expression, (Object)validator.toString());
        ContainerObjectValidatorsTest.assertEquals((Object)expected, (Object)validator.test(container));
        if (container instanceof JavaInfo) {
            ContainerObjectValidatorsTest.assertEquals((Object)expected, (Object)ContainerObjectValidators.validateContainer((Object)container, (String)expression));
        }
    }

    @Test
    public void test_forComponentExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    add(new JTextField());", "    add(new JLabel());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo textField = (ComponentInfo)panel.getChildrenComponents().get(1);
        ContainerObjectValidatorsTest.assertComponentValidatorFalse("true", null, button);
        ContainerObjectValidatorsTest.assertComponentValidatorFalse("true", panel, null);
        ContainerObjectValidatorsTest.assertComponentValidatorFalse("false", panel, button);
        ContainerObjectValidatorsTest.assertComponentValidatorTrue("true", panel, button);
        ContainerObjectValidatorsTest.assertComponentValidatorTrue("isComponentType(java.awt.Component)", panel, button);
        ContainerObjectValidatorsTest.assertComponentValidatorTrue("isComponentType(java.awt.Component)", panel, textField);
        ContainerObjectValidatorsTest.assertComponentValidatorTrue("isComponentType(javax.swing.AbstractButton)", panel, button);
        ContainerObjectValidatorsTest.assertComponentValidatorFalse("isComponentType(javax.swing.AbstractButton)", panel, textField);
    }

    @Test
    public void test_forComponentExpression_externalType() throws Exception {
        ContainerObjectValidatorsTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        ContainerObjectValidatorsTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerObjectValidatorsTest.assertComponentValidatorTrue("isComponentType(javax.swing.JButton)", panel, button);
        ContainerObjectValidatorsTest.assertComponentValidatorTrue("isComponentType('test.MyButton')", panel, button);
    }

    @Test
    public void test_forComponentExpression_externalType2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ContainerObjectValidator validator = ContainerObjectValidators.forComponentExpression((String)"container.hasLayout()");
        int i = 0;
        while (i < 100) {
            ContainerObjectValidatorsTest.assertTrue((boolean)validator.validate((Object)panel, (Object)button));
            ++i;
        }
    }

    private static void assertComponentValidatorFalse(String expression, Object container, Object component) {
        ContainerObjectValidatorsTest.assertComponentValidator(false, expression, container, component);
    }

    private static void assertComponentValidatorTrue(String expression, Object container, Object component) {
        ContainerObjectValidatorsTest.assertComponentValidator(true, expression, container, component);
    }

    private static void assertComponentValidator(boolean expected, String expression, Object container, Object component) {
        ContainerObjectValidator validator = ContainerObjectValidators.forComponentExpression((String)expression);
        ContainerObjectValidatorsTest.assertEquals((Object)expression, (Object)validator.toString());
        ContainerObjectValidatorsTest.assertEquals((Object)expected, (Object)validator.validate(container, component));
    }

    @Test
    public void test_forReferenceExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    add(new JTextField());", "    add(new JLabel());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo textField = (ComponentInfo)panel.getChildrenComponents().get(1);
        ContainerObjectValidatorsTest.assertReferenceValidatorFalse("true", null, button);
        ContainerObjectValidatorsTest.assertReferenceValidatorFalse("true", panel, null);
        ContainerObjectValidatorsTest.assertReferenceValidatorFalse("false", panel, button);
        ContainerObjectValidatorsTest.assertReferenceValidatorTrue("true", panel, button);
        ContainerObjectValidatorsTest.assertReferenceValidatorTrue("isReferenceType(java.awt.Component)", panel, button);
        ContainerObjectValidatorsTest.assertReferenceValidatorTrue("isReferenceType(java.awt.Component)", panel, textField);
        ContainerObjectValidatorsTest.assertReferenceValidatorTrue("isReferenceType(javax.swing.AbstractButton)", panel, button);
        ContainerObjectValidatorsTest.assertReferenceValidatorFalse("isReferenceType(javax.swing.AbstractButton)", panel, textField);
    }

    private static void assertReferenceValidatorFalse(String expression, Object container, Object reference) {
        ContainerObjectValidatorsTest.assertReferenceValidator(false, expression, container, reference);
    }

    private static void assertReferenceValidatorTrue(String expression, Object container, Object reference) {
        ContainerObjectValidatorsTest.assertReferenceValidator(true, expression, container, reference);
    }

    private static void assertReferenceValidator(boolean expected, String expression, Object container, Object reference) {
        ContainerObjectValidator validator = ContainerObjectValidators.forReferenceExpression((String)expression);
        ContainerObjectValidatorsTest.assertEquals((Object)expression, (Object)validator.toString());
        ContainerObjectValidatorsTest.assertEquals((Object)expected, (Object)validator.validate(container, reference));
    }
}

