/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.presentation.DefaultJavaInfoPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.eclipse.wb.tests.designer.tests.Activator;
import org.junit.Test;

public class DefaultJavaInfoPresentationTest
extends SwingModelTest {
    @Test
    public void test_normalComponent() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IObjectPresentation presentation = button.getPresentation();
        DefaultJavaInfoPresentationTest.assertInstanceOf(DefaultJavaInfoPresentation.class, (Object)presentation);
        DefaultJavaInfoPresentationTest.assertSame((Object)button.getDescription().getIcon(), (Object)presentation.getIcon());
        DefaultJavaInfoPresentationTest.assertEquals((Object)"button", (Object)presentation.getText());
    }

    @Test
    public void test_factoryComponent() throws Exception {
        DefaultJavaInfoPresentationTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        IFile iconFile = DefaultJavaInfoPresentationTest.getFileSrc("test", "StaticFactory.createButton__.png");
        iconFile.create(Activator.getFile("icons/test.png"), true, null);
        DefaultJavaInfoPresentationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StaticFactoryCreationSupport creationSupport = (StaticFactoryCreationSupport)button.getCreationSupport();
        IObjectPresentation presentation = button.getPresentation();
        DefaultJavaInfoPresentationTest.assertSame((Object)creationSupport.getDescription().getIcon(), (Object)presentation.getIcon());
        DefaultJavaInfoPresentationTest.assertEquals((Object)"button", (Object)presentation.getText());
    }

    @Test
    public void test_factoryComponent_noIcon() throws Exception {
        DefaultJavaInfoPresentationTest.do_projectDispose();
        DefaultJavaInfoPresentationTest.do_projectCreate();
        DefaultJavaInfoPresentationTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton() {", "    return new JButton();", "  }", "}"));
        DefaultJavaInfoPresentationTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = StaticFactory.createButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        StaticFactoryCreationSupport creationSupport = (StaticFactoryCreationSupport)button.getCreationSupport();
        DefaultJavaInfoPresentationTest.assertNull((Object)creationSupport.getDescription().getIcon());
        IObjectPresentation presentation = button.getPresentation();
        DefaultJavaInfoPresentationTest.assertSame((Object)button.getDescription().getIcon(), (Object)presentation.getIcon());
        DefaultJavaInfoPresentationTest.assertEquals((Object)"button", (Object)presentation.getText());
    }
}

