/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Test;

public class ClassLoadingTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_installNewBundleWithContributions() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addClass(ClassForBundle.class);
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing' myAttr='0'/>");
            testBundle.install();
            try {
                testBundle.getBundle().loadClass(className);
                ClassLoadingTest.assertTrue((boolean)ClassLoadingTest.hasToolkitElementWith("myAttr"));
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
        ClassLoadingTest.assertFalse((boolean)ClassLoadingTest.hasToolkitElementWith("myAttr"));
    }

    @Test
    public void test_useClasspathBundle() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addClass(ClassForBundle.class);
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-bundle bundle='" + testBundle.getId() + "'/>", "</toolkit>");
            testBundle.install();
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                this.m_lastLoader.loadClass(className);
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_useClasspathLibrary_singleJar() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "</toolkit>");
            testBundle.install();
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                this.m_lastLoader.loadClass(className);
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_useClassLoaderLibrary_toDependentJars() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            String className2 = ClassForBundle2.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("myClasses2.jar").addClass(ClassForBundle2.class).close();
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses2.jar'/>", "</toolkit>");
            testBundle.install();
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                this.m_lastLoader.loadClass(className);
                this.m_lastLoader.loadClass(className2);
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_useClassLoaderLibrary_twoDependentJars_packedBundle() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            String className = ClassForBundle.class.getName();
            String className2 = ClassForBundle2.class.getName();
            testBundle.addJar("myClasses.jar").addClass(ClassForBundle.class).close();
            testBundle.addJar("myClasses2.jar").addClass(ClassForBundle2.class).close();
            testBundle.addExtension("org.eclipse.wb.core.toolkits", "<toolkit id='org.eclipse.wb.swing'>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses.jar'/>", "  <classLoader-library bundle='" + testBundle.getId() + "' jar='myClasses2.jar'/>", "</toolkit>");
            testBundle.install(true);
            try {
                this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
                this.m_lastLoader.loadClass(className);
                this.m_lastLoader.loadClass(className2);
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    private static boolean hasToolkitElementWith(String attribute) {
        List toolkitElements = DescriptionHelper.getToolkitElements((String)"org.eclipse.wb.swing");
        for (IConfigurationElement toolkitElement : toolkitElements) {
            if (toolkitElement.getAttribute(attribute) == null) continue;
            return true;
        }
        return false;
    }

    @Test
    public void test_ConfigureClassLoader() throws Exception {
        ClassLoadingTest.setFileContentSrc("test/MyObject.java", ClassLoadingTest.getSource("package test;", "public class MyObject {", "  public static int m_value = 0;", "  public static void setValue(int value) {", "    m_value = value;", "  }", "}"));
        ClassLoadingTest.setFileContent("wbp-meta/ConfigureClassLoader.mvel", "test.MyObject.setValue(123);");
        ClassLoadingTest.waitForAutoBuild();
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "      // filler", "  }", "}");
        ClassLoadingTest.assertNoErrors(this.m_lastParseInfo);
        Class<?> myObjectClass = this.m_lastLoader.loadClass("test.MyObject");
        ClassLoadingTest.assertEquals((long)123L, (long)ReflectionUtils.getFieldInt(myObjectClass, (String)"m_value"));
    }

    @Test
    public void test_getPackage() throws Exception {
        ClassLoadingTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  private String bundle = getClass().getPackage().getName();", "}"));
        ClassLoadingTest.waitForAutoBuild();
        ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("public class Test extends MyPanel {", "  public Test() {", "      // filler", "  }", "}");
        panel.refresh();
        ClassLoadingTest.assertEquals((Object)"test", (Object)ReflectionUtils.getFieldString((Object)panel.getObject(), (String)"bundle"));
    }

    public static class ClassForBundle {
    }

    public static class ClassForBundle2
    extends ClassForBundle {
    }
}

