/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.tree.policies;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.tree.TreeEditPart;
import org.eclipse.wb.internal.core.EnvironmentUtils;

public abstract class LayoutEditPolicy
extends EditPolicy {
    @Override
    public TreeEditPart getHost() {
        return (TreeEditPart)super.getHost();
    }

    protected final TreeItem getHostWidget() {
        return this.getHost().getWidget();
    }

    protected final Tree getTree() {
        return this.getHostWidget().getParent();
    }

    protected ILayoutRequestValidator getRequestValidator() {
        return ILayoutRequestValidator.TRUE;
    }

    protected boolean isRequestCondition(Request request) {
        Object type = request.getType();
        ILayoutRequestValidator validator = this.getRequestValidator();
        TreeEditPart host = this.getHost();
        if (type == "create child") {
            return validator.validateCreateRequest((org.eclipse.gef.EditPart)host, (CreateRequest)request);
        }
        if (type == "paste") {
            return validator.validatePasteRequest((org.eclipse.gef.EditPart)host, (PasteRequest)request);
        }
        if (type == "move") {
            return validator.validateMoveRequest((org.eclipse.gef.EditPart)host, (ChangeBoundsRequest)request);
        }
        if (type == "add children") {
            return validator.validateAddRequest((org.eclipse.gef.EditPart)host, (ChangeBoundsRequest)request);
        }
        return false;
    }

    @Override
    public boolean understandsRequest(Request request) {
        return this.isRequestCondition(request);
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if (this.isRequestCondition(request)) {
            DropRequest dropRequest = (DropRequest)request;
            Point location = dropRequest.getLocation();
            TreeItem targetItem = this.getTree().getItem(location.getSWTPoint());
            if (targetItem == this.getHostWidget() && (LayoutEditPolicy.isBeforeLocation(targetItem, location) || LayoutEditPolicy.isAfterLocation(targetItem, location))) {
                return null;
            }
            return this.getHost();
        }
        return null;
    }

    @Override
    public Command getCommand(Request request) {
        DropRequest dropRequest = (DropRequest)request;
        Point location = dropRequest.getLocation();
        TreeItem targetItem = this.getTree().getItem(location.getSWTPoint());
        if (targetItem == null || targetItem.getData() == null) {
            return null;
        }
        List<EditPart> children = this.getReferenceChildren(request);
        Object referenceObject = null;
        if (targetItem != this.getHostWidget()) {
            org.eclipse.gef.EditPart dropPart = (org.eclipse.gef.EditPart)targetItem.getData();
            int dropIndex = children.indexOf(dropPart);
            if (dropIndex == -1) {
                return null;
            }
            int nextIndex = dropIndex + 1;
            if (LayoutEditPolicy.isBeforeLocation(targetItem, location)) {
                referenceObject = dropPart.getModel();
            } else if (nextIndex < children.size()) {
                referenceObject = children.get(nextIndex).getModel();
            }
        }
        return this.getCommand(request, referenceObject);
    }

    protected boolean isGoodReferenceChild(Request request, org.eclipse.gef.EditPart editPart) {
        return false;
    }

    private List<EditPart> getReferenceChildren(Request request) {
        List<EditPart> allChildren = this.getHost().getChildren();
        ArrayList<EditPart> referenceChildren = new ArrayList<EditPart>();
        for (EditPart editPart : allChildren) {
            if (!this.isGoodReferenceChild(request, (org.eclipse.gef.EditPart)editPart)) continue;
            referenceChildren.add(editPart);
        }
        return referenceChildren;
    }

    protected Command getCommand(Request request, Object referenceObject) {
        Object type = request.getType();
        if ("create child".equals(type)) {
            CreateRequest createRequest = (CreateRequest)request;
            return this.getCreateCommand(createRequest.getNewObject(), referenceObject);
        }
        if ("paste".equals(type)) {
            PasteRequest pasteRequest = (PasteRequest)request;
            return this.getPasteCommand(pasteRequest, referenceObject);
        }
        if ("move".equals(type)) {
            ChangeBoundsRequest boundsRequest = (ChangeBoundsRequest)request;
            return this.getMoveCommand(boundsRequest.getEditParts(), referenceObject);
        }
        if ("add children".equals(type)) {
            ChangeBoundsRequest boundsRequest = (ChangeBoundsRequest)request;
            return this.getAddCommand(boundsRequest.getEditParts(), referenceObject);
        }
        return null;
    }

    protected Command getCreateCommand(Object newObject, Object referenceObject) {
        return null;
    }

    protected Command getPasteCommand(PasteRequest request, Object referenceObject) {
        return null;
    }

    protected Command getMoveCommand(List<? extends org.eclipse.gef.EditPart> moveParts, Object referenceObject) {
        return null;
    }

    protected Command getAddCommand(List<? extends org.eclipse.gef.EditPart> addParts, Object referenceObject) {
        return null;
    }

    @Override
    public void showTargetFeedback(Request request) {
        if (this.isRequestCondition(request)) {
            this.showLayoutTargetFeedback(request);
        }
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        if (this.isRequestCondition(request)) {
            this.eraseLayoutTargetFeedback(request);
        }
    }

    protected void showLayoutTargetFeedback(Request request) {
        DropRequest dropRequest = (DropRequest)request;
        Point location = dropRequest.getLocation();
        Tree tree = this.getTree();
        TreeItem hostItem = this.getHostWidget();
        TreeItem targetItem = tree.getItem(location.getSWTPoint());
        if (targetItem == hostItem) {
            this.appendToSelection();
            this.setTreeInsertMark(null, true);
            Object type = request.getType();
            if (("create child".equals(type) || "paste".equals(type)) && !hostItem.getExpanded()) {
                tree.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreeItem hostWidget = LayoutEditPolicy.this.getHostWidget();
                        if (hostWidget != null) {
                            hostWidget.setExpanded(true);
                        }
                    }
                });
            }
        } else if (targetItem != null && hostItem.indexOf(targetItem) != -1) {
            this.removeFromSelection();
            boolean beforeLocation = LayoutEditPolicy.isBeforeLocation(targetItem, location);
            if (EnvironmentUtils.IS_LINUX && request instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
                changeBoundsRequest.setDNDFeedback(beforeLocation ? 2 : 4);
            }
            this.setTreeInsertMark(targetItem, beforeLocation);
        }
    }

    private void setTreeInsertMark(TreeItem targetItem, boolean before) {
        Tree tree = this.getTree();
        tree.setInsertMark(targetItem, before);
        tree.setData("_wbp_insertMarkItem", (Object)targetItem);
        tree.setData("_wbp_insertMarkLocation", (Object)before);
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.removeFromSelection();
        this.setTreeInsertMark(null, true);
    }

    private static boolean isBeforeLocation(TreeItem item, Point location) {
        Rectangle bounds = new Rectangle(item.getBounds());
        return location.y - bounds.y < 5;
    }

    private static boolean isAfterLocation(TreeItem item, Point location) {
        Rectangle bounds = new Rectangle(item.getBounds());
        return bounds.bottom() - location.y < 5;
    }

    private void appendToSelection() {
        TreeItem widget = this.getHostWidget();
        Tree tree = this.getTree();
        Object[] selection = tree.getSelection();
        if (!ArrayUtils.contains((Object[])selection, (Object)widget)) {
            selection = (TreeItem[])ArrayUtils.add((Object[])selection, (Object)widget);
            tree.setSelection((TreeItem[])selection);
        }
    }

    private void removeFromSelection() {
        TreeItem widget = this.getHostWidget();
        Tree tree = this.getTree();
        Object[] selection = tree.getSelection();
        if (ArrayUtils.contains((Object[])selection, (Object)widget)) {
            selection = (TreeItem[])ArrayUtils.removeElement((Object[])selection, (Object)widget);
            tree.setSelection((TreeItem[])selection);
        }
    }
}

