/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.template.ThrowingBiFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;

public interface GetPackageFunction
extends ThrowingBiFunction<ClassLoader, String, Package, Throwable> {

    public static class ForJava9
    implements GetPackageFunction {
        protected MethodHandle methodHandle;

        public ForJava9(Map<Object, Object> context) throws Throwable {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            ConsulterSupplyFunction consulterSupplyFunction = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context);
            MethodHandles.Lookup classLoaderConsulter = (MethodHandles.Lookup)consulterSupplyFunction.apply(ClassLoader.class);
            MethodType methodType = MethodType.methodType(Package.class, String.class);
            this.methodHandle = classLoaderConsulter.findSpecial(ClassLoader.class, "getDefinedPackage", methodType, ClassLoader.class);
        }

        @Override
        public Package apply(ClassLoader classLoader, String packageName) throws Throwable {
            return this.methodHandle.invokeExact(classLoader, packageName);
        }
    }

    public static class ForJava7
    implements GetPackageFunction {
        public ForJava7(Map<Object, Object> context) {
        }

        @Override
        public Package apply(ClassLoader inputOne, String packageName) {
            return Package.getPackage(packageName);
        }
    }
}

