/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.orm.BasicMapping;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.InvalidMapping;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.JavaPersistentAttributeModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaPersistentTypeModelAdapter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class JavaPersistentAttributeModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    private PersistentAttribute testPersistentAttribute;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaPersistentAttributeModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaPersistentAttributeModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
        this.testPersistentAttribute = (PersistentAttribute)this.testClassType.getPersistentAttributes().get(1);
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    public void testAttributeMappingChangesInJavaUpdatesPersistenceModel() {
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "basic" ? 1 : 0) != 0);
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)this.testPersistentAttribute.getModelAdapter();
        Attribute attribute = modelAdapter.getAttribute();
        attribute.addAnnotation("Id");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "id" ? 1 : 0) != 0);
        attribute.removeAnnotation("Id");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "basic" ? 1 : 0) != 0);
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)((BasicMapping)this.testPersistentAttribute.getAttributeMapping()).isDefault());
        attribute.addAnnotation("Basic");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "basic" ? 1 : 0) != 0);
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)((BasicMapping)this.testPersistentAttribute.getAttributeMapping()).isDefault());
        attribute.removeAnnotation("Basic");
        attribute.addAnnotation("OneToOne");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "oneToOne" ? 1 : 0) != 0);
        attribute.removeAnnotation("OneToOne");
        attribute.addAnnotation("OneToMany");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "oneToMany" ? 1 : 0) != 0);
        attribute.removeAnnotation("OneToMany");
        attribute.addAnnotation("ManyToMany");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "manyToMany" ? 1 : 0) != 0);
        attribute.removeAnnotation("ManyToMany");
        attribute.addAnnotation("ManyToOne");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "manyToOne" ? 1 : 0) != 0);
        attribute.removeAnnotation("ManyToOne");
        attribute.addAnnotation("Transient");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "transient" ? 1 : 0) != 0);
        attribute.removeAnnotation("Transient");
        attribute.addAnnotation("EmbeddedId");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "embeddedId" ? 1 : 0) != 0);
        attribute.removeAnnotation("EmbeddedId");
        attribute.addAnnotation("Embedded");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "embedded" ? 1 : 0) != 0);
        attribute.removeAnnotation("Embedded");
        attribute.addAnnotation("Version");
        JavaPersistentAttributeModelAdapterTests.assertTrue((this.testPersistentAttribute.getAttributeMappingKey() == "version" ? 1 : 0) != 0);
    }

    public void testAttributeMappingChangesInPersistenceModelUpdatesJava() {
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)this.testPersistentAttribute.getModelAdapter();
        Attribute attribute = modelAdapter.getAttribute();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Basic"));
        this.testPersistentAttribute.setAttributeMappingKey("basic", false);
        CompilationUnit astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("Basic", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("oneToOne", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("OneToOne", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Basic", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("basic", true);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("OneToOne", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Basic", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("oneToOne", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("OneToOne", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Basic", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("id", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("Id", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("OneToOne", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("basic", true);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Id", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("oneToMany", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("OneToMany", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("manyToOne", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("OneToMany", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("ManyToOne", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("manyToMany", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("ManyToOne", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("ManyToMany", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("transient", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("ManyToMany", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("Transient", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("version", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Transient", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("Version", astRoot));
        this.testPersistentAttribute.setAttributeMappingKey("embeddedId", false);
        astRoot = attribute.createASTRoot();
        JavaPersistentAttributeModelAdapterTests.assertFalse((boolean)attribute.containsAnnotation("Version", astRoot));
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)attribute.containsAnnotation("EmbeddedId", astRoot));
    }

    public void testInvalidMapping() {
        try {
            ((JavaPersistentTypeModelAdapter)this.testClassType.getModelAdapter()).getJDTType().createField("private Employee employee;", null, true, null);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        PersistentAttribute newAttribute = (PersistentAttribute)this.testClassType.getPersistentAttributes().get(2);
        JavaPersistentAttributeModelAdapterTests.assertTrue((boolean)(newAttribute.getAttributeMapping() instanceof InvalidMapping));
        JavaPersistentAttributeModelAdapter modelAdapter = (JavaPersistentAttributeModelAdapter)newAttribute.getModelAdapter();
        Attribute attribute = modelAdapter.getAttribute();
        attribute.addAnnotation("OneToOne");
        JavaPersistentAttributeModelAdapterTests.assertTrue((newAttribute.getAttributeMappingKey() == "oneToOne" ? 1 : 0) != 0);
    }
}

