/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.core.tests.adapters.java;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.tests.projects.SimpleTestProject;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.GeneratedValue;
import org.eclipse.dali.orm.GenerationType;
import org.eclipse.dali.orm.IdMapping;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.adapters.IGeneratedValueModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.JavaIdMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;

public class JavaGeneratedValueModelAdapterTests
extends TestCase {
    private SimpleTestProject project;
    private PersistentType testClassType;
    private IdMapping testClassIdMapping;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.core.tests.adapters.java.JavaGeneratedValueModelAdapterTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public JavaGeneratedValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = new SimpleTestProject();
        this.project.setPersistenceNature();
        PersistenceFile persistenceFile = DaliPlugin.getPersistenceFile((IFile)((IFile)this.project.getTestClassType().getCompilationUnit().getResource()));
        this.testClassType = (PersistentType)persistenceFile.getPersistentTypes().get(0);
        this.testClassType.setTypeMappingKey((TypeMapping.Key)Entity.Key.INSTANCE);
        this.testClassIdMapping = (IdMapping)((PersistentAttribute)this.testClassType.getPersistentAttributes().get(0)).getAttributeMapping();
    }

    protected void tearDown() throws Exception {
        this.testClassType.setTypeMappingKey((TypeMapping.Key)NullTypeMapping.Key.INSTANCE);
        this.testClassType = null;
        this.project.dispose();
        super.tearDown();
    }

    private JavaIdMappingModelAdapter getIdModelAdapter() {
        return (JavaIdMappingModelAdapter)this.testClassIdMapping.getModelAdapter();
    }

    public void testStrategyChangesInJavaUpdatesPersistenceModel() {
        JavaGeneratedValueModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation generatedValueAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"GeneratedValue");
                MemberValuePair valuePair = ast.newMemberValuePair();
                valuePair.setName(ast.newSimpleName("strategy"));
                valuePair.setValue((Expression)ast.newQualifiedName(ast.newName("GenerationType"), ast.newSimpleName("TABLE")));
                ASTTools.addValuePair((NormalAnnotation)generatedValueAnnotation, (MemberValuePair)valuePair);
                ASTTools.addAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)generatedValueAnnotation);
            }
        });
        JavaGeneratedValueModelAdapterTests.assertEquals((Object)GenerationType.TABLE_LITERAL, (Object)this.testClassIdMapping.getGeneratedValue().getStrategy());
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation generatedValueAnnotation = (NormalAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"GeneratedValue");
                MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)generatedValueAnnotation, (String)"strategy");
                valuePair.setValue((Expression)ast.newQualifiedName(ast.newName("GenerationType"), ast.newSimpleName("AUTO")));
            }
        });
        JavaGeneratedValueModelAdapterTests.assertEquals((Object)GenerationType.AUTO_LITERAL, (Object)this.testClassIdMapping.getGeneratedValue().getStrategy());
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation generatedValueAnnotation = (NormalAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"GeneratedValue");
                MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)generatedValueAnnotation, (String)"strategy");
                valuePair.setValue((Expression)ast.newQualifiedName(ast.newName("GenerationType"), ast.newSimpleName("IDENTITY")));
            }
        });
        JavaGeneratedValueModelAdapterTests.assertEquals((Object)GenerationType.IDENTITY_LITERAL, (Object)this.testClassIdMapping.getGeneratedValue().getStrategy());
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                NormalAnnotation generatedValueAnnotation = (NormalAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"GeneratedValue");
                MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)generatedValueAnnotation, (String)"strategy");
                valuePair.setValue((Expression)ast.newQualifiedName(ast.newName("GenerationType"), ast.newSimpleName("SEQUENCE")));
            }
        });
        JavaGeneratedValueModelAdapterTests.assertEquals((Object)GenerationType.SEQUENCE_LITERAL, (Object)this.testClassIdMapping.getGeneratedValue().getStrategy());
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation generatedValueAnnotation = (NormalAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"GeneratedValue");
                ASTTools.removeValuePair((NormalAnnotation)generatedValueAnnotation, (String)"strategy");
            }
        });
        JavaGeneratedValueModelAdapterTests.assertEquals((Object)GenerationType.DEFAULT_LITERAL, (Object)this.testClassIdMapping.getGeneratedValue().getStrategy());
    }

    public void testStrategyChangesInPersistenceModelUpdatesJava() {
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        JavaGeneratedValueModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
        IGeneratedValueModelAdapter generatedValueModelAdapter = this.getIdModelAdapter().createGeneratedValueModelAdapter();
        GeneratedValue generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(generatedValueModelAdapter);
        this.testClassIdMapping.setGeneratedValue(generatedValue);
        generatedValue.setStrategy(GenerationType.TABLE_LITERAL);
        NormalAnnotation normalAnnotation = (NormalAnnotation)attribute.getAnnotation("GeneratedValue");
        MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)normalAnnotation, (String)"strategy");
        QualifiedName qualifiedName = (QualifiedName)valuePair.getValue();
        JavaGeneratedValueModelAdapterTests.assertEquals((String)"GenerationType.TABLE", (String)qualifiedName.getFullyQualifiedName());
        generatedValue.setStrategy(GenerationType.SEQUENCE_LITERAL);
        normalAnnotation = (NormalAnnotation)attribute.getAnnotation("GeneratedValue");
        valuePair = ASTTools.memberValuePair((NormalAnnotation)normalAnnotation, (String)"strategy");
        qualifiedName = (QualifiedName)valuePair.getValue();
        JavaGeneratedValueModelAdapterTests.assertEquals((String)"GenerationType.SEQUENCE", (String)qualifiedName.getFullyQualifiedName());
        generatedValue.setStrategy(GenerationType.AUTO_LITERAL);
        normalAnnotation = (NormalAnnotation)attribute.getAnnotation("GeneratedValue");
        valuePair = ASTTools.memberValuePair((NormalAnnotation)normalAnnotation, (String)"strategy");
        qualifiedName = (QualifiedName)valuePair.getValue();
        JavaGeneratedValueModelAdapterTests.assertEquals((String)"GenerationType.AUTO", (String)qualifiedName.getFullyQualifiedName());
        generatedValue.setStrategy(GenerationType.IDENTITY_LITERAL);
        normalAnnotation = (NormalAnnotation)attribute.getAnnotation("GeneratedValue");
        valuePair = ASTTools.memberValuePair((NormalAnnotation)normalAnnotation, (String)"strategy");
        qualifiedName = (QualifiedName)valuePair.getValue();
        JavaGeneratedValueModelAdapterTests.assertEquals((String)"GenerationType.IDENTITY", (String)qualifiedName.getFullyQualifiedName());
        generatedValue.setStrategy(GenerationType.DEFAULT_LITERAL);
        Annotation annotation = attribute.getAnnotation("GeneratedValue");
        JavaGeneratedValueModelAdapterTests.assertNotNull((Object)annotation);
        valuePair = ASTTools.memberValuePair((Annotation)annotation, (String)"strategy");
        JavaGeneratedValueModelAdapterTests.assertNull((Object)valuePair);
    }

    public void testGeneratorNameChangesInJavaUpdatesPersistenceModel() {
        JavaGeneratedValueModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        IGeneratedValueModelAdapter generatedValueModelAdapter = this.getIdModelAdapter().createGeneratedValueModelAdapter();
        GeneratedValue generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(generatedValueModelAdapter);
        this.testClassIdMapping.setGeneratedValue(generatedValue);
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation annotation = ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"GeneratedValue");
                NormalAnnotation normalAnnotation = ASTTools.newNormalAnnotation((AST)bodyDeclaration.getAST(), (String)"GeneratedValue");
                ASTTools.replaceAnnotation((BodyDeclaration)bodyDeclaration, (Annotation)annotation, (Annotation)normalAnnotation);
                ASTTools.addLiteralMemberValuePair((NormalAnnotation)normalAnnotation, (String)"generator", (String)"fooGen");
            }
        });
        JavaGeneratedValueModelAdapterTests.assertEquals((String)"fooGen", (String)generatedValue.getSpecifiedGeneratorName());
        attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)ASTTools.annotation((BodyDeclaration)bodyDeclaration, (String)"GeneratedValue");
                ASTTools.removeValuePair((NormalAnnotation)normalAnnotation, (String)"generator");
            }
        });
        JavaGeneratedValueModelAdapterTests.assertNull((Object)generatedValue.getSpecifiedGeneratorName());
    }

    public void testGeneratorNameChangesInPersistenceModelUpdatesJava() {
        Attribute attribute = (Attribute)ClassTools.invokeMethod((Object)this.getIdModelAdapter(), (String)"getAttribute");
        JavaGeneratedValueModelAdapterTests.assertNull((Object)this.testClassIdMapping.getGeneratedValue());
        IGeneratedValueModelAdapter generatedValueModelAdapter = this.getIdModelAdapter().createGeneratedValueModelAdapter();
        GeneratedValue generatedValue = OrmFactory.eINSTANCE.createGeneratedValue(generatedValueModelAdapter);
        this.testClassIdMapping.setGeneratedValue(generatedValue);
        generatedValue.setSpecifiedGeneratorName("fooGen");
        String generatorName = attribute.getAnnotationElementStringValue("GeneratedValue", "generator");
        JavaGeneratedValueModelAdapterTests.assertEquals((String)"fooGen", (String)generatorName);
        generatedValue.setSpecifiedGeneratorName(null);
        Expression annotationElement = attribute.getAnnotationElement("GeneratedValue", "generator");
        JavaGeneratedValueModelAdapterTests.assertNull((Object)annotationElement);
    }
}

