package com.leagueplanet.dao.example;

import java.util.*;


import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.model.*;

public class LeagueDAOImpl implements LeagueDAO {

	private static LeagueDAOImpl leagueDAO;

	private ArrayList leagues = new ArrayList();

	public Set findLeaguesWithName(String name) {

		Set results = new HashSet();
		Iterator leagueIterator = leagues.iterator();
		while (leagueIterator.hasNext()) {
			League aLeague = (League) leagueIterator.next();
			if (name.equals(aLeague.getName()))
				results.add(aLeague);
		}
		return results;
	}

	public Set getSchedulesForLeague(String league) {

		Set schedules = new HashSet();
		Iterator leagueIterator = leagues.iterator();
		while (leagueIterator.hasNext()) {
			League aLeague = (League) leagueIterator.next();
			if (league.equals(aLeague.getName())) {
				Set leagueSchedules = aLeague.getSchedules();
				schedules.addAll(leagueSchedules);
			}
		}
		return schedules;
	}

	public void save(League newLeague) {
		// do nothing
	}

	public static LeagueDAO getLeagueDAO() {
		if (leagueDAO == null) {

			leagueDAO = new LeagueDAOImpl();
			leagueDAO.init();
		}

		return leagueDAO;
	}

	private void init() {

		League league1 = new League(1, "Polar Bears Hockey League");
		leagues.add(league1);

		Team team1 = new Team(1, "Ottawa Sleigh Riders");
		league1.getTeams().add(team1);

		Team team2 = new Team(2, "Toronto Bears");
		league1.getTeams().add(team2);

		Team team3 = new Team(3, "Istanbul Beach Boys");
		league1.getTeams().add(team3);

		Schedule schedule1 = new Schedule(1, "");
		schedule1.setLeague(league1);
		league1.getSchedules().add(schedule1);

		Location location1 = new Location(1, "Vista Highschool");

		Game game1 = new Game(1, "2006-01-20", "19:30:00");
		schedule1.getEvents().add(game1);
		game1.setHome(team1);
		game1.setVisitor(team2);
		game1.setLocation(location1);
		game1.setSchedule(schedule1);
	}

	public Event findEvent(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	public Game findGame(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	public League findLeague(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	public Location findLocation(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	public Schedule findSchedule(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	public Team findTeam(long id) {
		// TODO Auto-generated method stub
		return null;
	}

	public Player findPlayer(long id) {
		// TODO Auto-generated method stub
		return null;
	}
}
