package com.leagueplanet.dao;

import java.util.Set;

import com.leagueplanet.model.Event;
import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Player;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Team;

public interface LeagueDAO {
	public Event findEvent(long id);

	public Game findGame(long id);

	public League findLeague(long id);

	public Location findLocation(long id);
	
	public Player findPlayer(long id);

	public Schedule findSchedule(long id);

	public Team findTeam(long id);

	public Set getSchedulesForLeague(String league);

	public Set findLeaguesWithName(String name);

	public void save(League newLeague);

}
