/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.backend.executor.NotChangedException;
import org.jolokia.config.ConfigKey;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.list.MBeanInfoData;
import org.jolokia.request.JmxListRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHandler
extends JsonRequestHandler<JmxListRequest> {
    @Override
    public RequestType getType() {
        return RequestType.LIST;
    }

    public ListHandler(Restrictor pRestrictor) {
        super(pRestrictor);
    }

    @Override
    public boolean handleAllServersAtOnce(JmxListRequest pRequest) {
        return true;
    }

    @Override
    protected void checkForRestriction(JmxListRequest pRequest) {
        this.checkType();
    }

    @Override
    public Object doHandleRequest(MBeanServerExecutor pServerManager, JmxListRequest pRequest) throws IOException, NotChangedException {
        this.checkForModifiedSince(pServerManager, pRequest);
        Stack<String> originalPathStack = EscapeUtil.reversePath(pRequest.getPathParts());
        int maxDepth = pRequest.getParameterAsInt(ConfigKey.MAX_DEPTH);
        boolean useCanonicalName = pRequest.getParameterAsBool(ConfigKey.CANONICAL_NAMING);
        ObjectName oName = null;
        try {
            Stack pathStack = (Stack)originalPathStack.clone();
            oName = this.objectNameFromPath(pathStack);
            ListMBeanEachAction action = new ListMBeanEachAction(maxDepth, pathStack, useCanonicalName);
            if (oName == null || oName.isPattern()) {
                pServerManager.each(oName, action);
            } else {
                pServerManager.call(oName, action, new Object[0]);
            }
            return action.getResult();
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid path within the MBean part given. (Path: " + pRequest.getPath() + ")", e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalArgumentException("No MBean '" + oName + "' found", e);
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + e, e);
        }
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection server, JmxListRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        throw new UnsupportedOperationException("Internal: Method must not be called when all MBeanServers are handled at once");
    }

    @Override
    public boolean useReturnValueWithPath() {
        return false;
    }

    private ObjectName objectNameFromPath(Stack<String> pPathStack) throws MalformedObjectNameException {
        if (pPathStack.empty()) {
            return null;
        }
        Stack path = (Stack)pPathStack.clone();
        String domain = (String)path.pop();
        if (path.empty()) {
            return new ObjectName(domain + ":*");
        }
        String props = (String)path.pop();
        ObjectName mbean = new ObjectName(domain + ":" + props);
        if (mbean.isPattern()) {
            throw new IllegalArgumentException("Cannot use an MBean pattern as path (given MBean: " + mbean + ")");
        }
        return mbean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListMBeanEachAction
    implements MBeanServerExecutor.MBeanEachCallback,
    MBeanServerExecutor.MBeanAction<Void> {
        private final MBeanInfoData infoMap;

        public ListMBeanEachAction(int pMaxDepth, Stack<String> pPathStack, boolean pUseCanonicalName) {
            this.infoMap = new MBeanInfoData(pMaxDepth, pPathStack, pUseCanonicalName);
        }

        @Override
        public void callback(MBeanServerConnection pConn, ObjectName pName) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException {
            this.lookupMBeanInfo(pConn, pName);
        }

        @Override
        public Void execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException, AttributeNotFoundException {
            this.lookupMBeanInfo(pConn, pName);
            return null;
        }

        private void lookupMBeanInfo(MBeanServerConnection pConn, ObjectName pName) throws InstanceNotFoundException, ReflectionException, IOException {
            if (!this.infoMap.handleFirstOrSecondLevel(pName)) {
                try {
                    MBeanInfo mBeanInfo = pConn.getMBeanInfo(pName);
                    this.infoMap.addMBeanInfo(mBeanInfo, pName);
                }
                catch (IOException exp) {
                    this.infoMap.handleException(pName, exp);
                }
                catch (InstanceNotFoundException exp) {
                    this.infoMap.handleException(pName, exp);
                }
                catch (IllegalStateException exp) {
                    this.infoMap.handleException(pName, exp);
                }
                catch (IntrospectionException exp) {
                    throw new IllegalArgumentException("Cannot extra MBeanInfo for " + pName + ": " + exp, exp);
                }
            }
        }

        public Object getResult() {
            return this.infoMap.truncate();
        }
    }
}

