/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.management.internal.system;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.virgo.kernel.management.internal.system.SystemManagementExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSystemManagementExporter<T>
implements SystemManagementExporter {
    private static final String OBJECT_NAME_PATTERN = "%s:category=System Information,type=%s";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    @Override
    public void register(String managementDomain) {
        try {
            this.server.registerMBean(this.getBean(), this.getObjectName(managementDomain));
        }
        catch (Exception exception) {
            this.logger.warn("Unable to register system information {} for management", (Object)this.getName());
        }
    }

    @Override
    public void unregister(String managementDomain) {
        try {
            this.server.unregisterMBean(this.getObjectName(managementDomain));
        }
        catch (Exception exception) {
            this.logger.warn("Unable to unregister system information {} from management", (Object)this.getName());
        }
    }

    private ObjectName getObjectName(String managementDomain) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(String.format(OBJECT_NAME_PATTERN, managementDomain, this.getName()));
    }

    abstract T getBean();

    abstract String getName();
}

