/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSFactory;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStorageFactory;
import org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactStorage;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.util.io.PathReference;

public final class StandardArtifactStorageFactory
implements ArtifactStorageFactory {
    private static final String DEPLOYER_STAGING_DIRECTORY = "s";
    private final PathReference workDirectory;
    private final ArtifactFSFactory artifactFSFactory;
    private final EventLogger eventLogger;
    private final String unpackBundles;
    private final Object monitor = new Object();
    private final Map<PathReference, Long> uniqueId = new HashMap<PathReference, Long>();

    public StandardArtifactStorageFactory(PathReference workDirectory, ArtifactFSFactory artifactFSFactory, EventLogger eventLogger, String unpackBundles) {
        this.workDirectory = workDirectory;
        this.artifactFSFactory = artifactFSFactory;
        this.eventLogger = eventLogger;
        this.unpackBundles = unpackBundles;
        this.workDirectory.newChild(DEPLOYER_STAGING_DIRECTORY).delete(true);
    }

    @Override
    public ArtifactStorage create(File file, ArtifactIdentity artifactIdentity) {
        PathReference sourcePathReference = new PathReference(file);
        PathReference stagingPathReference = this.createStagingPathReference(artifactIdentity, file.getName());
        return new StandardArtifactStorage(sourcePathReference, stagingPathReference, this.artifactFSFactory, this.eventLogger, this.unpackBundles);
    }

    @Override
    public ArtifactStorage createDirectoryStorage(ArtifactIdentity artifactIdentity, String directoryName) {
        PathReference stagingPathReference = this.createStagingPathReference(artifactIdentity, directoryName);
        stagingPathReference.createDirectory();
        return new StandardArtifactStorage(null, stagingPathReference, this.artifactFSFactory, this.eventLogger, this.unpackBundles);
    }

    private PathReference createStagingPathReference(ArtifactIdentity artifactIdentity, String name) {
        PathReference scopeDir = this.workDirectory.newChild(DEPLOYER_STAGING_DIRECTORY).newChild(this.normalizeScopeName(artifactIdentity.getScopeName()));
        return this.createNextChild(scopeDir).newChild(name);
    }

    private String normalizeScopeName(String scopeName) {
        return scopeName == null ? "global" : scopeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathReference createNextChild(PathReference scopeDir) {
        Object object = this.monitor;
        synchronized (object) {
            Long uniqueId = this.uniqueId.get(scopeDir);
            uniqueId = uniqueId == null ? 0L : uniqueId + 1L;
            this.uniqueId.put(scopeDir, uniqueId);
            return scopeDir.newChild(uniqueId.toString());
        }
    }
}

