/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityClassListener;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;

public class EntityClassListenerMetadata
extends EntityListenerMetadata {
    private EntityAccessor m_accessor;
    private MetadataDescriptor m_descriptor;

    public EntityClassListenerMetadata(EntityAccessor accessor) {
        super(null, null, accessor);
        this.m_accessor = accessor;
        this.m_descriptor = accessor.getDescriptor();
    }

    protected void initCallbackMethods(MappedSuperclassAccessor accessor) {
        this.setPostLoad(accessor.getPostLoad());
        this.setPostPersist(accessor.getPostPersist());
        this.setPostRemove(accessor.getPostRemove());
        this.setPostUpdate(accessor.getPostUpdate());
        this.setPrePersist(accessor.getPrePersist());
        this.setPreRemove(accessor.getPreRemove());
        this.setPreUpdate(accessor.getPreUpdate());
    }

    public void process(List<MappedSuperclassAccessor> mappedSuperclasses, ClassLoader loader) {
        Class accessorClass = this.getClass(this.m_accessor.getJavaClass(), loader);
        this.m_listener = new EntityClassListener(accessorClass);
        this.initCallbackMethods(this.m_accessor);
        this.processCallbackMethods(this.getDeclaredMethods(accessorClass), this.m_accessor);
        if (!this.m_descriptor.excludeSuperclassListeners()) {
            for (MappedSuperclassAccessor mappedSuperclass : mappedSuperclasses) {
                Class superClass = this.getClass(mappedSuperclass.getJavaClass(), loader);
                this.initCallbackMethods(mappedSuperclass);
                this.processCallbackMethods(this.getDeclaredMethods(superClass), mappedSuperclass);
            }
        }
        if (this.m_listener.hasCallbackMethods()) {
            this.m_descriptor.setEntityEventListener(this.m_listener);
        }
    }
}

