/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.Serializable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.FailOverService;

public class FailOverSessionActivationListener
implements HttpSessionActivationListener,
Serializable {
    public static final String SESSION_ATTRIBUTE_NAME = "o.a.owb.SESSION_ACTIVATION_LISTENER";
    private static final long serialVersionUID = -5690043082210295824L;

    public void sessionWillPassivate(HttpSessionEvent event) {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        FailOverService failOverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        if (failOverService != null && failOverService.isSupportPassivation()) {
            HttpSession session = event.getSession();
            failOverService.sessionWillPassivate(session);
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        FailOverService failOverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        if (failOverService != null && (failOverService.isSupportFailOver() || failOverService.isSupportPassivation())) {
            HttpSession session = event.getSession();
            failOverService.sessionDidActivate(session);
        }
    }
}

