/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.util;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.equinox.region.Region;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.osgi.framework.Version;

public final class ArtifactRetriever<T extends ManageableArtifact> {
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final String type;
    private final RuntimeArtifactModelObjectNameCreator objectNameCreator;
    private final Class<T> artifactType;

    public ArtifactRetriever(String type, RuntimeArtifactModelObjectNameCreator objectNameCreator, Class<T> artifactType) {
        this.type = type;
        this.objectNameCreator = objectNameCreator;
        this.artifactType = artifactType;
    }

    public T getArtifact(String name, Version version, Region region) throws InstanceNotFoundException {
        return this.getArtifact(this.objectNameCreator.createArtifactModel(this.type, name, version, region));
    }

    public T getArtifact(ObjectName objectName) throws InstanceNotFoundException {
        if (this.server.isRegistered(objectName)) {
            return (T)((ManageableArtifact)JMX.newMXBeanProxy(this.server, objectName, this.artifactType));
        }
        throw new InstanceNotFoundException(String.format("Instance '%s' not found", objectName.getCanonicalName()));
    }
}

