/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.converters;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.virgo.shell.Converter;
import org.eclipse.virgo.shell.internal.converters.ConverterRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

final class ServiceRegistryConverterRegistry
implements ConverterRegistry {
    private final ServiceListener converterRegistryServiceListener = new ConverterRegistryServiceListener();
    private final Map<String, Converter> converters = new HashMap<String, Converter>();
    private final Object monitor = new Object();
    private final BundleContext bundleContext;

    ServiceRegistryConverterRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Converter getConverter(Class<?> clazz) {
        Object object = this.monitor;
        synchronized (object) {
            return this.converters.get(clazz.getName());
        }
    }

    void initialize() {
        try {
            this.bundleContext.addServiceListener(this.converterRegistryServiceListener, "(objectClass=" + Converter.class.getName() + ")");
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(Converter.class.getName(), null);
            if (serviceReferences != null) {
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    this.serviceRegistered(serviceReference);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unexpected InvalidSyntaxException", e);
        }
    }

    private void serviceRegistered(ServiceReference<?> serviceReference) {
        Converter converter = (Converter)this.bundleContext.getService(serviceReference);
        if (converter != null) {
            String[] converterClasses;
            String[] stringArray = converterClasses = this.getConverterClasses(serviceReference);
            int n = converterClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String converterClass = stringArray[n2];
                this.converters.put(converterClass, converter);
                ++n2;
            }
        }
    }

    private String[] getConverterClasses(ServiceReference<?> serviceReference) {
        Object converterClassesProperty = serviceReference.getProperty("osgi.converter.classes");
        String[] converterClasses = converterClassesProperty instanceof String[] ? (String[])converterClassesProperty : (converterClassesProperty instanceof String ? new String[]{(String)converterClassesProperty} : new String[]{});
        return converterClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceUnregistering(ServiceReference<?> serviceReference) {
        Object converter = this.bundleContext.getService(serviceReference);
        if (converter != null) {
            Object object = this.monitor;
            synchronized (object) {
                Iterator<Map.Entry<String, Converter>> iterator = this.converters.entrySet().iterator();
                while (iterator.hasNext()) {
                    Converter candidate = iterator.next().getValue();
                    if (!converter.equals(candidate)) continue;
                    iterator.remove();
                }
            }
        }
    }

    private final class ConverterRegistryServiceListener
    implements ServiceListener {
        private ConverterRegistryServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (1 == event.getType()) {
                ServiceRegistryConverterRegistry.this.serviceRegistered(event.getServiceReference());
            } else if (4 == event.getType()) {
                ServiceRegistryConverterRegistry.this.serviceUnregistering(event.getServiceReference());
            }
        }
    }
}

