/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.shell.internal.completers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.virgo.shell.CommandCompleter;
import org.eclipse.virgo.shell.internal.completers.CommandCompleterRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

final class ServiceRegistryCommandCompleterRegistry
implements CommandCompleterRegistry {
    private final ServiceListener commandCompleterRegistryServiceListener = new ConverterRegistryServiceListener();
    private final Map<String, CommandCompleter> completers = new HashMap<String, CommandCompleter>();
    private final Object monitor = new Object();
    private final BundleContext bundleContext;

    ServiceRegistryCommandCompleterRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandCompleter getCommandCompleter(String commandName) {
        Object object = this.monitor;
        synchronized (object) {
            return this.completers.get(commandName);
        }
    }

    void initialize() {
        try {
            this.bundleContext.addServiceListener(this.commandCompleterRegistryServiceListener, "(objectClass=" + CommandCompleter.class.getName() + ")");
            ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(CommandCompleter.class.getName(), null);
            if (serviceReferences != null) {
                ServiceReference[] serviceReferenceArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    this.serviceRegistered(serviceReference);
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unexpected InvalidSyntaxException", e);
        }
    }

    private void serviceRegistered(ServiceReference<?> serviceReference) {
        CommandCompleter completer = (CommandCompleter)this.bundleContext.getService(serviceReference);
        if (completer != null) {
            String[] commandNames;
            String[] stringArray = commandNames = this.getCommandNames(serviceReference);
            int n = commandNames.length;
            int n2 = 0;
            while (n2 < n) {
                String commandName = stringArray[n2];
                this.completers.put(commandName, completer);
                ++n2;
            }
        }
    }

    private String[] getCommandNames(ServiceReference<?> serviceReference) {
        Object commandNamesProperty = serviceReference.getProperty("org.eclipse.virgo.shell.completer.commmandNames");
        String[] commandNames = commandNamesProperty instanceof String[] ? (String[])commandNamesProperty : (commandNamesProperty instanceof String ? new String[]{(String)commandNamesProperty} : new String[]{});
        return commandNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceUnregistering(ServiceReference<?> serviceReference) {
        Object converter = this.bundleContext.getService(serviceReference);
        if (converter != null) {
            String[] commandNames = this.getCommandNames(serviceReference);
            Object object = this.monitor;
            synchronized (object) {
                String[] stringArray = commandNames;
                int n = commandNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String commandName = stringArray[n2];
                    this.completers.remove(commandName);
                    ++n2;
                }
            }
        }
    }

    private final class ConverterRegistryServiceListener
    implements ServiceListener {
        private ConverterRegistryServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            if (1 == event.getType()) {
                ServiceRegistryCommandCompleterRegistry.this.serviceRegistered(event.getServiceReference());
            } else if (4 == event.getType()) {
                ServiceRegistryCommandCompleterRegistry.this.serviceUnregistering(event.getServiceReference());
            }
        }
    }
}

