/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.dmfragment.internal;

import org.eclipse.virgo.kernel.dmfragment.ModuleBeanFactoryPostProcessor;
import org.eclipse.virgo.kernel.dmfragment.internal.KernelAnnotationMBeanExporter;
import org.eclipse.virgo.kernel.dmfragment.internal.KernelMBeanExporter;
import org.eclipse.virgo.nano.shim.serviceability.TracingService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;

final class MBeanExporterPostProcessor
implements ModuleBeanFactoryPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TracingService tracingService;

    public MBeanExporterPostProcessor(TracingService tracingService) {
        this.tracingService = tracingService;
    }

    @Override
    public void postProcess(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        String[] beanDefinitionNames;
        boolean foundExporter = false;
        String[] stringArray = beanDefinitionNames = beanFactory.getBeanDefinitionNames();
        int n = beanDefinitionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String beanDefinitionName = stringArray[n2];
            AbstractBeanDefinition definition = (AbstractBeanDefinition)beanFactory.getBeanDefinition(beanDefinitionName);
            if (MBeanExporter.class.getName().equals(definition.getBeanClassName())) {
                definition.setBeanClass(KernelMBeanExporter.class);
                definition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.tracingService);
                foundExporter = true;
            } else if (AnnotationMBeanExporter.class.getName().equals(definition.getBeanClassName())) {
                definition.setBeanClass(KernelAnnotationMBeanExporter.class);
                definition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.tracingService);
                foundExporter = true;
            }
            ++n2;
        }
        if (foundExporter) {
            this.logger.info("Found MBean exporter bean for bundle '{}'. Switching to ServerMBeanExporter or ServerAnnotationMBeanExporter.", (Object)bundleContext.getBundle());
        } else {
            this.logger.info("MBean exporting not enabled for bundle '{}',", (Object)bundleContext.getBundle());
        }
    }
}

