/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.module.internal;

import java.util.Collection;
import org.eclipse.gemini.blueprint.context.ConfigurableOsgiBundleApplicationContext;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.module.internal.ModuleContextWrapper;
import org.eclipse.virgo.nano.serviceability.Assert;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public final class KernelModuleContextAccessor
implements ModuleContextAccessor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModuleContext getModuleContext(@NonNull Bundle bundle) {
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) return null;
        String symbolicName = bundle.getSymbolicName();
        try {
            Collection refs = bundleContext.getServiceReferences(ApplicationContext.class, "(Bundle-SymbolicName=" + symbolicName + ")");
            if (refs.size() == 0) return null;
            for (ServiceReference ref : refs) {
                Object service = bundleContext.getService(ref);
                try {
                    ApplicationContext appCtx;
                    if (!(service instanceof ApplicationContext) || !((appCtx = (ApplicationContext)service) instanceof ConfigurableOsgiBundleApplicationContext) || bundleContext != ((ConfigurableOsgiBundleApplicationContext)appCtx).getBundleContext()) continue;
                    ModuleContextWrapper moduleContextWrapper = new ModuleContextWrapper((ConfigurableApplicationContext)((ConfigurableOsgiBundleApplicationContext)appCtx));
                    return moduleContextWrapper;
                }
                finally {
                    bundleContext.ungetService(ref);
                }
            }
            return null;
        }
        catch (InvalidSyntaxException e) {
            Assert.isFalse((boolean)true, (String)"Unexpected exception %s", (Object[])new Object[]{e.getMessage()});
        }
        return null;
    }
}

