/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact;

import org.eclipse.virgo.nano.serviceability.NonNull;
import org.osgi.framework.Version;

public class ArtifactIdentity {
    private final String type;
    private final String name;
    private final Version version;
    private final String scopeName;

    public ArtifactIdentity(@NonNull String type, @NonNull String name, @NonNull Version version, String scopeName) {
        this.type = type;
        this.name = name;
        this.version = version;
        this.scopeName = scopeName;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.scopeName == null ? 0 : this.scopeName.hashCode());
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactIdentity other = (ArtifactIdentity)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.scopeName == null ? other.scopeName != null : !this.scopeName.equals(other.scopeName)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        return this.version.equals((Object)other.version);
    }

    public String toString() {
        return String.format("%s '%s' version '%s' in scope '%s'", this.type, this.name, this.version, this.scopeName);
    }
}

