/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.io.IOException;
import java.net.URL;
import org.eclipse.virgo.kernel.install.artifact.BundleInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.environment.InstallEnvironment;
import org.eclipse.virgo.kernel.install.pipeline.stage.transform.Transformer;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;

public class ManifestUpgrader
implements Transformer {
    private static final int BUNDLE_MANIFEST_VERSION_FOR_OSGI_R4 = 2;

    @Override
    public void transform(GraphNode<InstallArtifact> installGraph, final InstallEnvironment installEnvironment) throws DeploymentException {
        installGraph.visit((GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor)new GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<InstallArtifact, DeploymentException>(){

            public boolean visit(GraphNode<InstallArtifact> graph) throws DeploymentException {
                ManifestUpgrader.this.operate((InstallArtifact)graph.getValue(), installEnvironment);
                return true;
            }
        });
    }

    void operate(InstallArtifact installArtifact, InstallEnvironment installEnvironment) throws DeploymentException {
        if (installArtifact instanceof BundleInstallArtifact) {
            BundleManifest bundleManifest = this.getBundleManifest(installArtifact, installEnvironment);
            this.upgradeManifestIfNecessary(bundleManifest, installArtifact, installEnvironment);
            this.validateManifest(bundleManifest, installArtifact, installEnvironment);
            this.removeBundleUpdateLocation(installArtifact, installEnvironment, bundleManifest);
        }
    }

    private BundleManifest getBundleManifest(InstallArtifact installArtifact, InstallEnvironment installEnvironment) throws DeploymentException {
        try {
            return ((BundleInstallArtifact)installArtifact).getBundleManifest();
        }
        catch (IOException e) {
            installEnvironment.getInstallLog().log((LogEvent)DeployerLogEvents.BUNDLE_MANIFEST_NOT_FOUND, e, new Object[]{installArtifact.getName(), installArtifact.getVersion()});
            throw new DeploymentException("I/O error accessing bundle manifest for " + installArtifact, (Throwable)e);
        }
    }

    private void upgradeManifestIfNecessary(BundleManifest bundleManifest, InstallArtifact installArtifact, InstallEnvironment installEnvironment) {
        if (bundleManifest.getBundleManifestVersion() < 2) {
            installEnvironment.getInstallLog().log(this, "OSGi R3 or earlier manifest detected:\n'%s'\nfor %s - upgrading manifest to OSGi R4.", bundleManifest.toString(), installArtifact.toString());
            bundleManifest.setBundleManifestVersion(2);
            if (bundleManifest.getBundleSymbolicName().getSymbolicName() == null) {
                bundleManifest.getBundleSymbolicName().setSymbolicName(installArtifact.getName());
            }
        }
    }

    private void validateManifest(BundleManifest bundleManifest, InstallArtifact installArtifact, InstallEnvironment installEnvironment) throws DeploymentException {
        if (bundleManifest.getBundleSymbolicName().getSymbolicName() == null) {
            installEnvironment.getInstallLog().log((LogEvent)DeployerLogEvents.MISSING_BUNDLE_SYMBOLIC_NAME, new Object[]{installArtifact.getName(), installArtifact.getVersion(), bundleManifest});
            throw new DeploymentException("OSGi R4 manifest with no bundle symbolic name detected:\n" + bundleManifest + "'\nfor module '" + this + "'.");
        }
    }

    private void removeBundleUpdateLocation(InstallArtifact installArtifact, InstallEnvironment installEnvironment, BundleManifest bundleManifest) {
        URL bundleUpdateLocation = bundleManifest.getBundleUpdateLocation();
        if (bundleUpdateLocation != null) {
            installEnvironment.getInstallLog().log((LogEvent)DeployerLogEvents.DISCARDING_BUNDLE_UPDATE_LOCATION, new Object[]{bundleUpdateLocation, installArtifact.getName(), installArtifact.getVersion().toString()});
            bundleManifest.setBundleUpdateLocation(null);
        }
    }
}

