/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InterceptionType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenWebBeansEjbInterceptor
implements Serializable {
    private static final long serialVersionUID = -4317127341083031217L;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(OpenWebBeansEjbInterceptor.class);
    private static transient ThreadLocal<BaseEjbBean<?>> threadLocal = new ThreadLocal();
    private static transient ThreadLocal<CreationalContext<?>> threadLocalCreationalContext = new ThreadLocal();
    protected transient Map<Method, List<InterceptorData>> interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
    protected transient Map<Method, List<InterceptorData>> nonCtxInterceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
    private transient Map<Class<?>, BaseEjbBean<?>> resolvedBeans = new HashMap();
    private CreationalContext<?> cc;
    private transient BaseEjbBean<?> contextual;
    private transient WebBeansContext webBeansContext;
    private CreationalKey ccKey;

    public static void setThreadLocal(BaseEjbBean<?> ejbBean, CreationalContext<?> creationalContext) {
        threadLocal.set(ejbBean);
        threadLocalCreationalContext.set(creationalContext);
    }

    public static void unsetThreadLocal() {
        threadLocal.set(null);
        threadLocalCreationalContext.set(null);
        threadLocal.remove();
        threadLocalCreationalContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object callToOwbInterceptors(InvocationContext ejbContext) throws Exception {
        boolean requestCreated = false;
        boolean applicationCreated = false;
        boolean requestAlreadyActive = false;
        boolean applicationAlreadyActive = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Intercepting EJB method {0} ", ejbContext.getMethod());
        }
        try {
            if (this.webBeansContext.getOpenWebBeansConfiguration().isUseEJBInterceptorActivation()) {
                int result = this.activateContexts(RequestScoped.class);
                if (result == 1) {
                    requestCreated = true;
                } else if (result == -1) {
                    requestAlreadyActive = true;
                }
                result = this.activateContexts(ApplicationScoped.class);
                if (result == 1) {
                    applicationCreated = true;
                } else if (result == -1) {
                    applicationAlreadyActive = true;
                }
            }
            if (this.contextual == null) {
                Object object = ejbContext.proceed();
                return object;
            }
            Object object = this.callInterceptorsAndDecorators(ejbContext.getMethod(), ejbContext.getTarget(), ejbContext.getParameters(), ejbContext);
            return object;
        }
        finally {
            if (this.webBeansContext.getOpenWebBeansConfiguration().isUseEJBInterceptorActivation()) {
                if (!requestAlreadyActive) {
                    this.deActivateContexts(requestCreated, RequestScoped.class);
                }
                if (!applicationAlreadyActive) {
                    this.deActivateContexts(applicationCreated, ApplicationScoped.class);
                }
            }
        }
    }

    public void lifecycleCommon(InvocationContext context, InterceptionType interceptionType) {
        try {
            if (this.contextual != null && WebBeansUtil.isContainsInterceptorMethod((List)this.contextual.getInterceptorStack(), (InterceptionType)interceptionType)) {
                InvocationContextImpl impl = new InvocationContextImpl(this.webBeansContext, this.contextual, context.getTarget(), null, null, this.webBeansContext.getInterceptorUtil().getInterceptorMethods(this.contextual.getInterceptorStack(), interceptionType), interceptionType);
                impl.setCreationalContext(this.cc);
                impl.setEJBInvocationContext(context);
                impl.setCcKey((Object)this.ccKey);
                impl.proceed();
            } else {
                context.proceed();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0008", (Object[])new Object[]{interceptionType}), e);
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    public void afterConstruct(InvocationContext context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("entry");
        }
        if (this.webBeansContext == null) {
            this.webBeansContext = WebBeansContext.currentInstance();
        }
        BaseEjbBean<?> injectionTarget = threadLocal.get();
        this.ccKey = new CreationalKey();
        if (injectionTarget == null) {
            this.contextual = this.findTargetBean(context.getTarget());
            if (this.contextual == null) {
                try {
                    context.proceed();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        } else {
            this.contextual = injectionTarget;
            OpenWebBeansEjbInterceptor.unsetThreadLocal();
        }
        this.cc = this.webBeansContext.getBeanManagerImpl().createCreationalContext(this.contextual);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptionType.POST_CONSTRUCT);
        if (this.webBeansContext.getOpenWebBeansConfiguration().isUseEJBInterceptorInjection()) {
            Object instance = context.getTarget();
            try {
                OWBInjector.inject((BeanManager)this.webBeansContext.getBeanManagerImpl(), (Object)instance, this.cc);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0026", (Object[])new Object[]{this.contextual}), e);
            }
        }
    }

    @PreDestroy
    public void preDestroy(InvocationContext context) {
        this.lifecycleCommon(context, InterceptionType.PRE_DESTROY);
        this.interceptedMethodMap.clear();
        this.resolvedBeans.clear();
        this.nonCtxInterceptedMethodMap.clear();
        if (this.cc != null) {
            this.cc.release();
        }
    }

    private int activateContexts(Class<? extends Annotation> scopeType) {
        ContextsService service = (ContextsService)this.webBeansContext.getService(ContextsService.class);
        Context ctx = service.getCurrentContext(scopeType);
        ContextFactory contextFactory = this.webBeansContext.getContextFactory();
        if (scopeType == RequestScoped.class) {
            if (ctx != null && !ctx.isActive()) {
                contextFactory.activateContext(scopeType);
                return 0;
            }
            if (ctx == null) {
                contextFactory.initRequestContext(null);
                return 1;
            }
        }
        if ((ctx = service.getCurrentContext(scopeType)) != null && !ctx.isActive()) {
            contextFactory.activateContext(scopeType);
            return 0;
        }
        if (ctx == null) {
            contextFactory.initApplicationContext(null);
            return 1;
        }
        return -1;
    }

    private void deActivateContexts(boolean destroy, Class<? extends Annotation> scopeType) {
        ContextFactory contextFactory = this.webBeansContext.getContextFactory();
        if (scopeType == ApplicationScoped.class) {
            if (destroy) {
                contextFactory.destroyApplicationContext(null);
            } else {
                contextFactory.deActivateContext(ApplicationScoped.class);
            }
        } else if (destroy) {
            contextFactory.destroyRequestContext(null);
        } else {
            contextFactory.deActivateContext(RequestScoped.class);
        }
    }

    private BaseEjbBean<?> findTargetBean(Object instance) {
        if (instance == null) {
            return null;
        }
        BaseEjbBean ejbBean = this.resolvedBeans.get(instance.getClass());
        if (ejbBean == null) {
            Set beans = this.webBeansContext.getBeanManagerImpl().getComponents();
            for (Bean bean : beans) {
                if (!(bean instanceof BaseEjbBean) || bean.getBeanClass() != instance.getClass()) continue;
                ejbBean = (BaseEjbBean)bean;
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Found managed bean for [{0}] [{1}]", WebBeansLoggerFacade.args((Object[])new Object[]{instance.getClass(), ejbBean}));
                }
                this.resolvedBeans.put(instance.getClass(), ejbBean);
                break;
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Managed bean for [{0}] found in cache: [{1}]", WebBeansLoggerFacade.args((Object[])new Object[]{instance.getClass(), ejbBean}));
        }
        return ejbBean;
    }

    private Object callInterceptorsAndDecorators(Method method, Object instance, Object[] arguments, InvocationContext ejbContext) throws Exception {
        Object rv = null;
        BaseEjbBean<?> injectionTarget = this.contextual;
        InterceptorDataImpl decoratorInterceptorDataImpl = null;
        List decorators = null;
        DelegateHandler delegateHandler = null;
        List decoratorStack = injectionTarget.getDecoratorStack();
        List interceptorStack = injectionTarget.getInterceptorStack();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Decorator stack for target {0}", decoratorStack);
            logger.log(Level.FINE, "Interceptor stack {0}", interceptorStack);
        }
        if (decoratorStack.size() > 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Obtaining a delegate");
            }
            delegateHandler = new DelegateHandler(this.contextual, ejbContext);
            Object delegate = this.webBeansContext.getProxyFactory().createDecoratorDelegate(injectionTarget, delegateHandler);
            decorators = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, (Object)instance, (Object)delegate, (CreationalContextImpl)((CreationalContextImpl)this.cc));
            delegateHandler.setDecorators(decorators);
        }
        if (interceptorStack.size() == 0) {
            rv = decoratorStack.size() == 0 ? ejbContext.proceed() : delegateHandler.invoke(instance, method, null, arguments);
        } else {
            ArrayList<InterceptorDataImpl> filteredInterceptorStack;
            if (this.interceptedMethodMap.get(method) == null) {
                filteredInterceptorStack = new ArrayList<InterceptorDataImpl>(interceptorStack);
                this.webBeansContext.getInterceptorUtil().filterCommonInterceptorStackList(filteredInterceptorStack, method);
                this.webBeansContext.getInterceptorUtil().filterOverridenAroundInvokeInterceptor(injectionTarget.getBeanClass(), filteredInterceptorStack);
                this.interceptedMethodMap.put(method, filteredInterceptorStack);
            }
            filteredInterceptorStack = new ArrayList(this.interceptedMethodMap.get(method));
            if (delegateHandler != null) {
                WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(delegateHandler, instance);
                decoratorInterceptorDataImpl = new InterceptorDataImpl(true, lastInterceptor, this.webBeansContext);
                decoratorInterceptorDataImpl.setDefinedInInterceptorClass(true);
                decoratorInterceptorDataImpl.setAroundInvoke(this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethod(lastInterceptor.getClass(), "invokeDecorators", new Class[]{InvocationContext.class}));
                filteredInterceptorStack.add(decoratorInterceptorDataImpl);
            }
            rv = this.webBeansContext.getInterceptorUtil().callAroundInvokes(this.webBeansContext, this.contextual, instance, (CreationalContextImpl)this.cc, method, arguments, this.webBeansContext.getInterceptorUtil().getInterceptorMethods(filteredInterceptorStack, InterceptionType.AROUND_INVOKE), ejbContext, (Object)this.ccKey);
        }
        return rv;
    }

    @AroundTimeout
    public Object callAroundTimeouts(InvocationContext context) throws Exception {
        Object rv = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("OWBEI:: @AroundTimeout entry. Trying to run Interceptors.");
        }
        if (this.contextual != null && WebBeansUtil.isContainsInterceptorMethod((List)this.contextual.getInterceptorStack(), (InterceptionType)InterceptionType.AROUND_TIMEOUT)) {
            try {
                InvocationContextImpl impl = new InvocationContextImpl(this.webBeansContext, null, context.getTarget(), null, null, this.webBeansContext.getInterceptorUtil().getInterceptorMethods(this.contextual.getInterceptorStack(), InterceptionType.AROUND_TIMEOUT), InterceptionType.AROUND_TIMEOUT);
                impl.setCreationalContext(this.cc);
                impl.setEJBInvocationContext(context);
                impl.setCcKey((Object)this.ccKey);
                rv = impl.proceed();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0008", (Object[])new Object[]{"@AroundTimeout."}), e);
                throw new RuntimeException(e);
            }
        } else {
            rv = context.proceed();
        }
        return rv;
    }

    @PrePassivate
    public void beforePassivate(InvocationContext context) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "manager = {0} interceptor_instance = {1} contextual = {2} ", WebBeansLoggerFacade.args((Object[])new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual}));
        }
        this.lifecycleCommon(context, InterceptionType.PRE_PASSIVATE);
    }

    @PostActivate
    public void afterActivate(InvocationContext context) {
        this.contextual = this.findTargetBean(context.getTarget());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "manager = {0} interceptor_instance = {1} contextual = {2} ", WebBeansLoggerFacade.args((Object[])new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual}));
        }
        this.lifecycleCommon(context, InterceptionType.POST_ACTIVATE);
    }

    public static CreationalContext<?> getThreadCreationalContext() {
        return threadLocalCreationalContext.get();
    }

    public static BaseEjbBean<?> getEjbBean() {
        return threadLocal.get();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "manager = {0} interceptor_instance = {1} contextual = {2} ", WebBeansLoggerFacade.args((Object[])new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual}));
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "interceptor instance = " + this.hashCode());
        }
        this.interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
        this.nonCtxInterceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
        this.resolvedBeans = new HashMap();
        s.defaultReadObject();
        this.webBeansContext = WebBeansContext.currentInstance();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "manager = {0} interceptor_instance = {1} contextual = {2} ", WebBeansLoggerFacade.args((Object[])new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual}));
        }
    }

    private class CreationalKey
    implements Serializable {
        private CreationalKey() {
        }
    }
}

