/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.war.deployer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.PackageAdminImpl;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.KernelConfig;
import org.eclipse.virgo.nano.deployer.SimpleDeployer;
import org.eclipse.virgo.nano.deployer.StandardDeploymentIdentity;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.deployer.util.BundleInfosUpdater;
import org.eclipse.virgo.nano.deployer.util.BundleLocationUtil;
import org.eclipse.virgo.nano.deployer.util.StatusFileModificator;
import org.eclipse.virgo.util.io.FatalIOException;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.JarUtils;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.web.war.deployer.IOUtils;
import org.eclipse.virgo.web.war.deployer.WARDeployerLogEvents;
import org.eclipse.virgo.web.war.deployer.WebBundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WARDeployer
implements SimpleDeployer {
    private static final boolean NOT_A_FRAGMENT = false;
    private static final String KERNEL_HOME_PROP = "org.eclipse.virgo.kernel.home";
    private static final String WAR = "war";
    private static final boolean STATUS_OK = true;
    private static final boolean STATUS_ERROR = false;
    private static final String PICKUP_DIR = "pickup";
    private static final String SLASH = "/";
    private static final char SLASH_CHAR = '/';
    private static final char DOT = '.';
    static final String LAST_MODIFIED = "last-modified";
    static final String EMPTY_STRING = "";
    private static final String WEBAPPS_DIR = "webapps";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String DEFAULT_CONTEXT_PATH = "/";
    private static final String ROOT_WAR_NAME = "ROOT";
    private static final char HASH_SIGN = '#';
    private static final String PROPERTY_WAB_HEADERS = "WABHeaders";
    private static final String PROPERTY_VALUE_WAB_HEADERS_STRICT = "strict";
    private static final String PROPERTY_VALUE_WAB_HEADERS_DEFAULTED = "defaulted";
    private static final String HEADER_DEFAULT_WAB_HEADERS = "org-eclipse-gemini-web-DefaultWABHeaders";
    private static final String WEB_BUNDLE_MODULE_TYPE = "web-bundle";
    private static final String EVENT_TOPIC_DEPLOYED = "org/osgi/service/web/DEPLOYED";
    private static final String EVENT_TOPIC_DEPLOYING = "org/osgi/service/web/DEPLOYING";
    private static final String EVENT_TOPIC_UNDEPLOYED = "org/osgi/service/web/UNDEPLOYED";
    private static final String EVENT_TOPIC_UNDEPLOYING = "org/osgi/service/web/UNDEPLOYING";
    private static final String EVENT_TOPIC_FAILED = "org/osgi/service/web/FAILED";
    private static final String UPDATE_TIMEOUT_PROP = "org.eclipse.virgo.update.timeout";
    private static final long DEFAULT_TIMEOUT = 120000L;
    private static long TIMEOUT;
    private static final long CHECK_INTERVAL = 1000L;
    private static final boolean UNPACK_TO_DESTRUCTIVE;
    private EventLogger eventLogger;
    private BundleInfosUpdater bundleInfosUpdaterUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BundleContext bundleContext;
    private PackageAdmin packageAdmin;
    private WebBundleManifestTransformer webBundleManifestTransformer;
    private long largeFileCopyTimeout = 4000L;
    private File pickupDir;
    private File webAppsDir;
    private KernelConfig kernelConfig;
    private File kernelHomeFile;
    private Map<String, String> wabStates = new ConcurrentHashMap<String, String>();

    static {
        UNPACK_TO_DESTRUCTIVE = Boolean.parseBoolean(System.getProperty("org.eclipse.virgo.web.war.deployer.unpackToDestructive", "true"));
    }

    public WARDeployer() {
        this.warDeployerInternalInit(null);
    }

    public WARDeployer(BundleContext bundleContext, PackageAdmin packageAdmin, WebBundleManifestTransformer webBundleManifestTransformer, EventLogger eventLogger, KernelConfig kernelConfig) {
        this.warDeployerInternalInit(bundleContext);
        this.packageAdmin = packageAdmin;
        this.webBundleManifestTransformer = webBundleManifestTransformer;
        this.eventLogger = eventLogger;
        this.kernelConfig = kernelConfig;
    }

    public void activate(ComponentContext context) {
        this.warDeployerInternalInit(context.getBundleContext());
    }

    public final boolean deploy(URI path) {
        Bundle installed;
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLING, new Object[]{new File(path).toString()});
        String warName = this.extractDecodedWarNameFromString(path.toString());
        File deployedFile = new File(path);
        String extractionFolderName = WebBundleUtils.calculateCorrectSymbolicName(warName);
        File warDir = new File(this.webAppsDir, extractionFolderName);
        StatusFileModificator.deleteStatusFile((String)warName, (File)this.pickupDir);
        long bundleId = -1L;
        long lastModified = deployedFile.lastModified();
        if (!this.canWrite(path)) {
            this.logger.error("Cannot open the file " + path + " for writing. The configured timeout is " + this.largeFileCopyTimeout + ".");
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)bundleId, (long)lastModified);
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{path});
            return false;
        }
        try {
            try {
                JarUtils.unpackToDestructive((PathReference)new PathReference(deployedFile), (PathReference)new PathReference(warDir));
            }
            catch (FatalIOException e) {
                if (UNPACK_TO_DESTRUCTIVE) {
                    throw e;
                }
                this.logger.warn("Cannot delete directory '" + warDir + "'.", (Throwable)e);
                IOUtils.extractJar(deployedFile, warDir);
            }
            this.transformUnpackedManifest(warDir, warName);
            installed = this.bundleContext.installBundle(BundleLocationUtil.createInstallLocation((File)this.kernelHomeFile, (File)warDir));
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLING_ERROR, (Throwable)e, new Object[]{path});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)bundleId, (long)lastModified);
            return false;
        }
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_WEB_STARTING, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        try {
            installed.start();
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_STARTING_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)bundleId, (long)lastModified);
            return false;
        }
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_WEB_STARTED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        bundleId = installed.getBundleId();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Bundles info will be updated for war with path '" + path + "'.");
        }
        try {
            if (this.bundleInfosUpdaterUtil != null && this.bundleInfosUpdaterUtil.isAvailable()) {
                BundleInfosUpdater.registerToBundlesInfo((Bundle)installed, (String)this.getLocationForBundlesInfo(extractionFolderName), (boolean)false);
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{installed.getSymbolicName(), installed.getVersion()});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)bundleId, (long)lastModified);
            return false;
        }
        StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)true, (long)bundleId, (long)lastModified);
        return true;
    }

    public boolean isDeployFileValid(File file) {
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                this.logger.error("The deployed file '" + file.getAbsolutePath() + "' is an invalid zip file.");
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return true;
    }

    private String extractDecodedWarNameFromString(String path) {
        String warName = path.substring(path.lastIndexOf("/") + 1, path.length() - 4);
        return URLDecoder.decode(warName);
    }

    public final boolean undeploy(Bundle bundle) {
        String bundleLocation = this.removeTrailingFileSeparator(bundle.getLocation());
        String warPath = this.extractWarPath(bundleLocation);
        String extractedWarNameFromBundleLocation = this.extractWarNameFromBundleLocation(warPath);
        File warDir = new File(warPath);
        String warName = StatusFileModificator.deleteStatusFileByNamePattern((String)extractedWarNameFromBundleLocation.replaceAll("[.]", "[^a-zA-Z0-9_-]"), (File)this.pickupDir);
        if (EMPTY_STRING.equals(warName)) {
            warName = extractedWarNameFromBundleLocation;
        }
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Removing bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
            }
            if (this.bundleInfosUpdaterUtil != null && this.bundleInfosUpdaterUtil.isAvailable()) {
                String locationForBundlesInfo = BundleLocationUtil.getRelativisedURI((File)this.kernelHomeFile, (File)warDir).toString();
                BundleInfosUpdater.unregisterToBundlesInfo((Bundle)bundle, (String)locationForBundlesInfo, (boolean)false);
                this.logger.info("Successfully removed bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
            } else {
                this.logger.error("BundleInfosUpdater not available. Failed to remove bundle '" + bundle.getSymbolicName() + "' version '" + bundle.getVersion() + "' from bundles.info.");
            }
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_STOPPING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            bundle.stop();
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_STOPPED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UNINSTALLING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            bundle.uninstall();
            FileSystemUtils.deleteRecursively((File)new File(warDir.getAbsolutePath()));
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UNINSTALLED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            this.wabStates.remove(bundle.getSymbolicName());
        }
        catch (BundleException e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UNDEPLOY_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"undeploy", (boolean)false, (long)-1L, (long)-1L);
            return false;
        }
        catch (IOException e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
        }
        catch (URISyntaxException e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
        }
        StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"undeploy", (boolean)true, (long)-1L, (long)-1L);
        return true;
    }

    private String calculateStatusFilePrefix(Bundle bundle, String warName) {
        if (warName.contains(String.valueOf('.'))) {
            String webContextPath = (String)bundle.getHeaders().get(HEADER_WEB_CONTEXT_PATH);
            if (warName.charAt(0) == '.' && webContextPath.indexOf(46) == 1 || warName.charAt(0) != '.' && webContextPath.indexOf(46) != 1) {
                webContextPath = webContextPath.substring(1);
            }
            if (webContextPath.contains("/") && webContextPath.replace('/', '.').equals(warName)) {
                return URLDecoder.decode(webContextPath.replace('/', '#'));
            }
        }
        return URLDecoder.decode(warName);
    }

    private String extractWarNameFromBundleLocation(String bundleLocation) {
        String[] pathItems = bundleLocation.split("/");
        if (pathItems.length > 0) {
            return pathItems[pathItems.length - 1];
        }
        this.logger.warn("Cannot calculate war name on the given warPath [" + bundleLocation + "]");
        return EMPTY_STRING;
    }

    private String extractWarPath(String bundleLocation) {
        String warPath = bundleLocation.startsWith("reference:file:") ? bundleLocation.substring("reference:file:".length()) : bundleLocation;
        return warPath;
    }

    private String removeTrailingFileSeparator(String bundleLocation) {
        if (bundleLocation.endsWith(File.separator)) {
            bundleLocation = bundleLocation.substring(0, bundleLocation.length() - 1);
        }
        return bundleLocation;
    }

    public final boolean update(URI path) {
        String warName = this.extractDecodedWarNameFromString(path.toString());
        String extractionFolderName = WebBundleUtils.calculateCorrectSymbolicName(warName);
        File updatedFile = new File(path);
        File warDir = new File(this.webAppsDir, extractionFolderName);
        if (!warDir.exists()) {
            this.logger.info("Can't update artifact for path '" + path + "'. It is not deployed.");
        }
        boolean isOfflineUpdated = this.isOfflineUpdated(path);
        StatusFileModificator.deleteStatusFile((String)warName, (File)this.pickupDir);
        long lastModified = updatedFile.lastModified();
        if (!this.canWrite(path)) {
            this.logger.error("Cannot open the file [" + path + "] for writing. Timeout is [" + this.largeFileCopyTimeout + "].");
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)-1L, (long)lastModified);
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UPDATING_ERROR, new Object[]{path});
            return false;
        }
        Bundle bundle = this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation((File)this.kernelHomeFile, (File)warDir));
        if (bundle != null) {
            block12: {
                try {
                    boolean isLegalState = this.checkWabState(bundle, isOfflineUpdated);
                    if (isLegalState) break block12;
                    this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UPDATE_STATE_ERROR, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                    StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)-1L, (long)lastModified);
                    return false;
                }
                catch (Exception e) {
                    this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UPDATE_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
                    StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)-1L, (long)lastModified);
                    return false;
                }
            }
            this.wabStates.put(bundle.getSymbolicName(), EMPTY_STRING);
            bundle.stop();
            if (bundle instanceof BundleHost) {
                BundleClassLoader loader = (BundleClassLoader)((BundleHost)bundle).getClassLoader();
                loader.close();
            }
            try {
                JarUtils.unpackToDestructive((PathReference)new PathReference(updatedFile), (PathReference)new PathReference(warDir));
            }
            catch (FatalIOException e) {
                if (UNPACK_TO_DESTRUCTIVE) {
                    throw e;
                }
                this.logger.warn("Cannot delete directory '" + warDir + "'.", (Throwable)e);
                IOUtils.extractJar(updatedFile, warDir);
            }
            this.transformUnpackedManifest(warDir, warName);
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UPDATING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            bundle.update();
            if (this.packageAdmin != null) {
                ((PackageAdminImpl)this.packageAdmin).refreshPackages(new Bundle[]{bundle}, true, null);
                this.logger.info("Update of file with path [" + path + "] is successful.");
            }
            bundle.start();
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_UPDATED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)true, (long)-1L, (long)lastModified);
        } else {
            this.deploy(path);
        }
        return true;
    }

    private synchronized boolean checkWabState(Bundle bundle, boolean isOfflineUpdated) {
        String bundleSymbolicName = bundle.getSymbolicName();
        String wabState = this.wabStates.get(bundleSymbolicName);
        if (EMPTY_STRING.equals(wabState)) {
            return this.waitForState(bundle);
        }
        if ("DEPLOYED".equals(wabState) || "UNDEPLOYED".equals(wabState) || "FAILED".equals(wabState)) {
            return true;
        }
        if (wabState == null && isOfflineUpdated) {
            return this.waitForState(bundle);
        }
        return false;
    }

    private boolean waitForState(Bundle bundle) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < TIMEOUT) {
            String wabState = this.wabStates.get(bundle.getSymbolicName());
            if ("DEPLOYED".equals(wabState) || "UNDEPLOYED".equals(wabState) || "FAILED".equals(wabState)) {
                return true;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public void setLargeFileCopyTimeout(long timeout) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("setLargeFileCopyTimeout(" + timeout + ")");
        }
        this.largeFileCopyTimeout = timeout;
    }

    private boolean canWrite(URI path) {
        int tries = -1;
        boolean isWritable = false;
        long timeout = this.largeFileCopyTimeout / 500L;
        while ((long)tries < timeout) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(path));
                isWritable = true;
            }
            catch (FileNotFoundException e) {
                block7: {
                    try {
                        if (!this.logger.isInfoEnabled()) break block7;
                        this.logger.info("File is still locked.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        org.eclipse.virgo.util.io.IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                org.eclipse.virgo.util.io.IOUtils.closeQuietly((Closeable)fis);
            }
            org.eclipse.virgo.util.io.IOUtils.closeQuietly((Closeable)fis);
            break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.error("InterruptedException occurred.", (Throwable)e);
            }
            ++tries;
        }
        return isWritable;
    }

    private final void transformUnpackedManifest(File srcFile, String warName) throws IOException {
        BundleManifest manifest;
        FileInputStream mfIS;
        FileOutputStream fos;
        File destFile;
        block9: {
            if (srcFile == null) {
                throw new NullPointerException("Source file is null.");
            }
            if (!srcFile.isDirectory() || !srcFile.canRead()) {
                throw new IllegalArgumentException("Source file must be a readable directory [" + srcFile + "].");
            }
            destFile = new File(srcFile, "META-INF/MANIFEST.MF");
            if (!destFile.exists()) {
                destFile.getParentFile().mkdirs();
                destFile.createNewFile();
            }
            if (!destFile.isFile() || !destFile.canRead()) {
                throw new IllegalArgumentException("Destination file must be a readable file [" + destFile + "].");
            }
            fos = null;
            mfIS = null;
            try {
                mfIS = new FileInputStream(srcFile + File.separator + "META-INF/MANIFEST.MF");
                manifest = BundleManifestFactory.createBundleManifest((Reader)new InputStreamReader(mfIS));
                if (manifest.getModuleType() == null || "web".equalsIgnoreCase(manifest.getModuleType())) {
                    boolean strictWABHeaders = this.getStrictWABHeadersValue();
                    if (!strictWABHeaders) {
                        manifest.setHeader(HEADER_DEFAULT_WAB_HEADERS, "true");
                    }
                    manifest.setModuleType(WEB_BUNDLE_MODULE_TYPE);
                    InstallationOptions installationOptions = this.prepareInstallationOptions(strictWABHeaders, warName, manifest);
                    boolean isWebBundle = WebBundleUtils.isWebApplicationBundle(manifest);
                    this.webBundleManifestTransformer.transform(manifest, srcFile.toURI().toURL(), installationOptions, isWebBundle);
                    break block9;
                }
                this.logger.info("Skipping transformation of application '" + warName + "' because it is already a web bundle.");
            }
            catch (Throwable throwable) {
                org.eclipse.virgo.util.io.IOUtils.closeQuietly(fos);
                org.eclipse.virgo.util.io.IOUtils.closeQuietly(mfIS);
                throw throwable;
            }
            org.eclipse.virgo.util.io.IOUtils.closeQuietly(fos);
            org.eclipse.virgo.util.io.IOUtils.closeQuietly((Closeable)mfIS);
            return;
        }
        fos = new FileOutputStream(destFile);
        this.toManifest(manifest.toDictionary()).write(fos);
        org.eclipse.virgo.util.io.IOUtils.closeQuietly((Closeable)fos);
        org.eclipse.virgo.util.io.IOUtils.closeQuietly((Closeable)mfIS);
    }

    private InstallationOptions prepareInstallationOptions(boolean strictWABHeaders, String warName, BundleManifest manifest) {
        HashMap<String, String> map = new HashMap<String, String>();
        String webContextPathHeader = manifest.getHeader(HEADER_WEB_CONTEXT_PATH);
        if (webContextPathHeader == null || webContextPathHeader.trim().length() == 0) {
            if (warName.equals(ROOT_WAR_NAME)) {
                map.put(HEADER_WEB_CONTEXT_PATH, "/");
            } else {
                map.put(HEADER_WEB_CONTEXT_PATH, this.replaceHashSigns(warName, '/'));
            }
        }
        InstallationOptions installationOptions = new InstallationOptions(map);
        installationOptions.setDefaultWABHeaders(!strictWABHeaders);
        return installationOptions;
    }

    private final Manifest toManifest(Dictionary<String, String> headers) {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        Enumeration<String> names = headers.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            String value = headers.get(name);
            attributes.putValue(name, value);
        }
        return manifest;
    }

    public boolean canServeFileType(String fileType) {
        return fileType.toLowerCase().equals(WAR);
    }

    public boolean isDeployed(URI path) {
        String warName = this.extractDecodedWarNameFromString(path.toString());
        File warDir = new File(this.webAppsDir, WebBundleUtils.calculateCorrectSymbolicName(warName));
        if (!warDir.exists()) {
            return false;
        }
        return this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation((File)this.kernelHomeFile, (File)warDir)) != null;
    }

    public boolean isOfflineUpdated(URI path) {
        String warName = this.extractDecodedWarNameFromString(path.toString());
        File deployFile = new File(path);
        long deployFileLastModified = deployFile.lastModified();
        long lastModifiedStatus = StatusFileModificator.getLastModifiedFromStatusFile((String)warName, (File)this.pickupDir);
        return lastModifiedStatus != -1L && deployFileLastModified != lastModifiedStatus;
    }

    public DeploymentIdentity getDeploymentIdentity(URI path) {
        String warName = this.extractDecodedWarNameFromString(path.toString());
        File warDir = new File(this.webAppsDir, WebBundleUtils.calculateCorrectSymbolicName(warName));
        if (!warDir.exists()) {
            return null;
        }
        Bundle bundle = this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation((File)this.kernelHomeFile, (File)warDir));
        if (bundle == null) {
            return null;
        }
        return new StandardDeploymentIdentity(WAR, bundle.getSymbolicName(), bundle.getVersion().toString());
    }

    public List<String> getAcceptedFileTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(WAR);
        return types;
    }

    private void warDeployerInternalInit(BundleContext bundleContext) {
        String kernelHome = System.getProperty(KERNEL_HOME_PROP);
        if (kernelHome != null) {
            this.kernelHomeFile = new File(kernelHome);
            if (!this.kernelHomeFile.exists()) {
                throw new IllegalStateException("Required location '" + this.kernelHomeFile.getAbsolutePath() + "' does not exist. Check the value of the '" + KERNEL_HOME_PROP + "' propery");
            }
        } else {
            throw new IllegalStateException("Missing value for required property 'org.eclipse.virgo.kernel.home'");
        }
        File bundlesInfoFile = new File(this.kernelHomeFile, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        this.pickupDir = new File(this.kernelHomeFile, PICKUP_DIR);
        this.webAppsDir = new File(this.kernelHomeFile, WEBAPPS_DIR);
        this.bundleContext = bundleContext;
        this.bundleInfosUpdaterUtil = new BundleInfosUpdater(bundlesInfoFile, this.kernelHomeFile);
        if (bundleContext == null) {
            TIMEOUT = 120000L;
            return;
        }
        String timeout = bundleContext.getProperty(UPDATE_TIMEOUT_PROP);
        if (timeout == null) {
            TIMEOUT = 120000L;
        } else {
            try {
                TIMEOUT = Long.parseLong(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                TIMEOUT = 120000L;
            }
        }
        this.registerWebContainerEventsHandler(bundleContext);
    }

    private void registerWebContainerEventsHandler(BundleContext bundleContext) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put("event.topics", new String[]{EVENT_TOPIC_DEPLOYING, EVENT_TOPIC_DEPLOYED, EVENT_TOPIC_UNDEPLOYING, EVENT_TOPIC_UNDEPLOYED, EVENT_TOPIC_FAILED});
        bundleContext.registerService(EventHandler.class, (Object)new WebContainerEventsHandler(), props);
    }

    private boolean getStrictWABHeadersValue() {
        boolean strictWABHeaders = true;
        String wabHeadersPropertyValue = null;
        if (this.kernelConfig.getProperty(PROPERTY_WAB_HEADERS) != null) {
            wabHeadersPropertyValue = this.kernelConfig.getProperty(PROPERTY_WAB_HEADERS).toString();
        }
        if (wabHeadersPropertyValue != null) {
            if (PROPERTY_VALUE_WAB_HEADERS_DEFAULTED.equals(wabHeadersPropertyValue)) {
                strictWABHeaders = false;
                this.logger.info("Property '%s' has value [defaulted]", (Object[])new String[]{PROPERTY_WAB_HEADERS});
            } else if (!PROPERTY_VALUE_WAB_HEADERS_STRICT.equals(wabHeadersPropertyValue)) {
                this.logger.error("Property '%s' has invalid value '%s'", (Object[])new String[]{PROPERTY_WAB_HEADERS, wabHeadersPropertyValue});
            }
        }
        return strictWABHeaders;
    }

    public void bindWebBundleManifestTransformer(WebBundleManifestTransformer transformer) {
        this.webBundleManifestTransformer = transformer;
    }

    public void unbindWebBundleManifestTransformer(WebBundleManifestTransformer transformer) {
        this.webBundleManifestTransformer = null;
    }

    public void bindEventLogger(EventLogger logger) {
        this.eventLogger = logger;
    }

    public void unbindEventLogger(EventLogger logger) {
        this.eventLogger = null;
    }

    public void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    public void unbindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = null;
    }

    public void bindKernelConfig(KernelConfig kernelConfig) {
        this.kernelConfig = kernelConfig;
    }

    public void unbindKernelConfig(KernelConfig kernelConfig) {
        this.kernelConfig = null;
    }

    public boolean install(URI uri) {
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLING, new Object[]{new File(uri).toString()});
        String warName = this.extractDecodedWarNameFromString(uri.toString());
        File deployedFile = new File(uri);
        String extractionFolderName = WebBundleUtils.calculateCorrectSymbolicName(warName);
        File warDir = new File(this.webAppsDir, extractionFolderName);
        StatusFileModificator.deleteStatusFile((String)warName, (File)this.pickupDir);
        long lastModified = deployedFile.lastModified();
        if (!this.canWrite(uri)) {
            this.logger.error("Cannot open the file " + uri + " for writing. The configured timeout is " + this.largeFileCopyTimeout + ".");
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)-1L, (long)lastModified);
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLING_ERROR, new Object[]{uri});
            return false;
        }
        try {
            try {
                JarUtils.unpackToDestructive((PathReference)new PathReference(deployedFile), (PathReference)new PathReference(warDir));
            }
            catch (FatalIOException e) {
                if (UNPACK_TO_DESTRUCTIVE) {
                    throw e;
                }
                this.logger.warn("Cannot delete directory '" + warDir + "'.", (Throwable)e);
                IOUtils.extractJar(deployedFile, warDir);
            }
            this.transformUnpackedManifest(warDir, warName);
            Bundle installed = this.bundleContext.installBundle(BundleLocationUtil.createInstallLocation((File)this.kernelHomeFile, (File)warDir));
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLED, new Object[]{installed.getSymbolicName(), installed.getVersion()});
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_INSTALLING_ERROR, (Throwable)e, new Object[]{uri});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)-1L, (long)lastModified);
            return false;
        }
        return true;
    }

    public boolean start(URI uri) {
        String warName = this.extractDecodedWarNameFromString(uri.toString());
        String extractionFolderName = WebBundleUtils.calculateCorrectSymbolicName(this.extractDecodedWarNameFromString(uri.toString()));
        Bundle bundle = this.getInstalledBundle(extractionFolderName);
        if (bundle == null) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_STARTING_ERROR, new Object[]{uri});
            this.logger.error("Cannot start deployable with URI + [" + uri + "]. There is no bundle installed with this URI.");
            return false;
        }
        StatusFileModificator.deleteStatusFile((String)warName, (File)this.pickupDir);
        long lastModified = new File(uri).lastModified();
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_WEB_STARTING, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
        try {
            bundle.start();
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_STARTING_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)bundle.getBundleId(), (long)lastModified);
            return false;
        }
        this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_WEB_STARTED, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
        if (!this.updateBundlesInfo(bundle, this.getLocationForBundlesInfo(extractionFolderName))) {
            StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)false, (long)bundle.getBundleId(), (long)lastModified);
            return false;
        }
        StatusFileModificator.createStatusFile((String)warName, (File)this.pickupDir, (String)"deploy", (boolean)true, (long)bundle.getBundleId(), (long)lastModified);
        return true;
    }

    private boolean updateBundlesInfo(Bundle bundle, String location) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Bundles info will be updated for web app bundle with simbolic name '" + bundle.getSymbolicName() + "' .");
        }
        try {
            if (this.bundleInfosUpdaterUtil != null && this.bundleInfosUpdaterUtil.isAvailable()) {
                BundleInfosUpdater.registerToBundlesInfo((Bundle)bundle, (String)location, (boolean)false);
            }
        }
        catch (Exception e) {
            this.eventLogger.log((LogEvent)WARDeployerLogEvents.NANO_PERSIST_ERROR, (Throwable)e, new Object[]{bundle.getSymbolicName(), bundle.getVersion()});
            return false;
        }
        return true;
    }

    private Bundle getInstalledBundle(String extractionFolderName) {
        File warDir = new File(this.webAppsDir, extractionFolderName);
        if (!warDir.exists()) {
            this.logger.warn("Directory with name [" + extractionFolderName + "] cannot be found in web applications directory." + " See logs for previous failures during install.");
            return null;
        }
        return this.bundleContext.getBundle(BundleLocationUtil.createInstallLocation((File)this.kernelHomeFile, (File)warDir));
    }

    private String getLocationForBundlesInfo(String extractionFolderName) {
        File warDir = new File(this.webAppsDir, extractionFolderName);
        if (!warDir.exists()) {
            this.logger.warn("Directory with name [" + extractionFolderName + "] cannot be found in web applications directory." + " See logs for previous failures during install.");
            return null;
        }
        return BundleLocationUtil.getRelativisedURI((File)this.kernelHomeFile, (File)warDir).toString();
    }

    private String replaceHashSigns(String str, char newChar) {
        return str.replace('#', newChar);
    }

    class WebContainerEventsHandler
    implements EventHandler {
        WebContainerEventsHandler() {
        }

        public void handleEvent(Event event) {
            String topic = event.getTopic();
            if (WARDeployer.EVENT_TOPIC_DEPLOYING.equals(topic) || WARDeployer.EVENT_TOPIC_UNDEPLOYING.equals(topic)) {
                WARDeployer.this.wabStates.put((String)event.getProperty("bundle.symbolicName"), WARDeployer.EMPTY_STRING);
            } else if (WARDeployer.EVENT_TOPIC_DEPLOYED.equals(topic)) {
                WARDeployer.this.wabStates.put((String)event.getProperty("bundle.symbolicName"), "DEPLOYED");
            } else if (WARDeployer.EVENT_TOPIC_UNDEPLOYED.equals(topic)) {
                WARDeployer.this.wabStates.put((String)event.getProperty("bundle.symbolicName"), "UNDEPLOYED");
            } else if (WARDeployer.EVENT_TOPIC_FAILED.equals(topic)) {
                WARDeployer.this.wabStates.put((String)event.getProperty("bundle.symbolicName"), "FAILED");
            }
        }
    }
}

