/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.Asserts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JNDIUtil {
    private static final Logger LOGGER = WebBeansLoggerFacade.getLogger(JNDIUtil.class);

    private JNDIUtil() {
    }

    public static void bind(String name, Object object) {
        Asserts.assertNotNull(name, "name parameter can not be null");
        Asserts.assertNotNull(object, "object parameter can not be null");
        try {
            InitialContext initialContext;
            Context context = initialContext = new InitialContext();
            String[] parts = name.split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                try {
                    context = (Context)initialContext.lookup(parts[i]);
                    continue;
                }
                catch (NameNotFoundException e) {
                    context = initialContext.createSubcontext(parts[i]);
                }
            }
            context.bind(parts[parts.length - 1], object);
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0005", name), e);
        }
    }

    public static void unbind(String name) {
        Asserts.assertNotNull(name, "name parameter can not be null");
        try {
            new InitialContext().unbind(name);
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString("EXCEPT_0009") + name, e);
        }
    }

    public static <T> T lookup(String name, Class<? extends T> expectedClass) throws WebBeansException {
        Asserts.assertNotNull(name, "name parameter can not be null");
        try {
            return (T)new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString("EXCEPT_0010") + name, e);
        }
    }
}

