/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.webservices;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.core.webservices.PortAddress;
import org.apache.openejb.core.webservices.PortAddressRegistry;

public class PortAddressRegistryImpl
implements PortAddressRegistry {
    private Map<String, PortAddress> portsById = new TreeMap<String, PortAddress>();
    private Map<String, Map<String, PortAddress>> portsByInterface = new TreeMap<String, Map<String, PortAddress>>();
    private Map<String, Map<String, PortAddress>> portsByServiceId = new TreeMap<String, Map<String, PortAddress>>();
    private Map<QName, Map<String, PortAddress>> portsByServiceQName = new HashMap<QName, Map<String, PortAddress>>();

    @Override
    public synchronized void addPort(String serviceId, QName serviceQName, String portId, QName portQName, String portInterface, String address) throws OpenEJBException {
        if (serviceId == null) {
            throw new NullPointerException("serviceId is null");
        }
        if (serviceQName == null) {
            throw new NullPointerException("serviceQName is null");
        }
        if (portId == null) {
            throw new NullPointerException("portId is null");
        }
        if (portQName == null) {
            throw new NullPointerException("portQName is null");
        }
        if (address == null) {
            throw new NullPointerException("address is null");
        }
        PortAddress portAddress = this.portsById.get(portId);
        if (portAddress != null) {
            throw new OpenEJBException("A webservice port with qname " + portAddress.getPortQName() + " is already registered to the portId " + portId);
        }
        portAddress = new PortAddress(portId, serviceQName, portQName, address, portInterface);
        this.portsById.put(portId, portAddress);
        Map<String, PortAddress> ports = null;
        if (portInterface != null) {
            ports = this.portsByInterface.get(portInterface);
            if (ports == null) {
                ports = new TreeMap<String, PortAddress>();
                this.portsByInterface.put(portInterface, ports);
            }
            ports.put(portId, portAddress);
        }
        if ((ports = this.portsByServiceId.get(serviceId)) == null) {
            ports = new TreeMap<String, PortAddress>();
            this.portsByServiceId.put(serviceId, ports);
        }
        ports.put(portId, portAddress);
        ports = this.portsByServiceQName.get(serviceQName);
        if (ports == null) {
            ports = new TreeMap<String, PortAddress>();
            this.portsByServiceQName.put(serviceQName, ports);
        }
        ports.put(portId, portAddress);
    }

    @Override
    public synchronized void removePort(String serviceId, QName serviceQName, String portId, String portInterface) {
        if (serviceId == null) {
            throw new NullPointerException("serviceId is null");
        }
        if (serviceQName == null) {
            throw new NullPointerException("serviceQName is null");
        }
        if (portId == null) {
            throw new NullPointerException("portId is null");
        }
        PortAddress portAddress = this.portsById.remove(portId);
        if (portAddress != null) {
            return;
        }
        Map<String, PortAddress> ports = null;
        if (portInterface != null && (ports = this.portsByInterface.get(portInterface)) != null) {
            ports.remove(portId);
            if (ports.isEmpty()) {
                this.portsByInterface.remove(portInterface);
            }
        }
        if ((ports = this.portsByServiceId.get(serviceId)) != null) {
            ports.remove(portId);
            if (ports.isEmpty()) {
                this.portsByServiceId.remove(serviceId);
            }
        }
        if ((ports = this.portsByServiceQName.get(serviceQName)) != null) {
            ports.remove(portId);
            if (ports.isEmpty()) {
                this.portsByServiceId.remove(serviceId);
            }
        }
    }

    @Override
    public synchronized Set<PortAddress> getPorts(String id, QName serviceQName, String referenceClassName) {
        Map<String, PortAddress> qnamePorts;
        Map<String, PortAddress> idPorts;
        Map<String, PortAddress> interfacePorts;
        PortAddress portAddress;
        if (serviceQName == null) {
            throw new NullPointerException("serviceQName is null");
        }
        if (id != null && (portAddress = this.portsById.get(id)) != null) {
            return Collections.singleton(portAddress);
        }
        if (referenceClassName != null && (interfacePorts = this.portsByInterface.get(referenceClassName)) != null && interfacePorts.size() == 1) {
            PortAddress portAddress2 = interfacePorts.values().iterator().next();
            return Collections.singleton(portAddress2);
        }
        TreeMap<String, PortAddress> ports = new TreeMap<String, PortAddress>();
        if (id != null && (idPorts = this.portsByServiceId.get(id)) != null) {
            ports.putAll(idPorts);
        }
        if (ports.isEmpty() && (qnamePorts = this.portsByServiceQName.get(serviceQName)) != null) {
            ports.putAll(qnamePorts);
        }
        HashSet<PortAddress> portAddresses = new HashSet<PortAddress>(ports.values());
        return portAddresses;
    }
}

