/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.filter.Filters;

public class TldScanner {
    private static Map<ClassLoader, Set<URL>> cache = new WeakHashMap<ClassLoader, Set<URL>>();

    public static Set<URL> scan(ClassLoader classLoader) throws OpenEJBException {
        if (classLoader == null) {
            return Collections.EMPTY_SET;
        }
        Set<URL> urls = cache.get(classLoader);
        if (urls != null) {
            return urls;
        }
        Set<URL> result = TldScanner.scanClassLoaderForTagLibs(classLoader);
        cache.put(classLoader, result);
        return result;
    }

    public static Set<URL> scanClassLoaderForTagLibs(ClassLoader classLoader) throws OpenEJBException {
        HashSet<URL> tldUrls = new HashSet<URL>();
        if (classLoader == null) {
            return tldUrls;
        }
        if (classLoader == Object.class.getClassLoader()) {
            return tldUrls;
        }
        tldUrls.addAll(TldScanner.scan(classLoader.getParent()));
        UrlSet urlSet = new UrlSet(new URL[0]);
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            urlSet = new UrlSet(urlClassLoader.getURLs());
        } else {
            try {
                urlSet = new UrlSet(classLoader);
            }
            catch (IOException e) {
                DeploymentLoader.logger.warning("Error scanning class loader for JSP tag libraries", e);
            }
        }
        try {
            urlSet = URLs.cullSystemJars(urlSet);
            urlSet = NewLoaderLogic.applyBuiltinExcludes(urlSet, Filters.tokens((String[])new String[]{"jstl-1.2", "myfaces-impl"}));
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning class loader for JSP tag libraries", e);
        }
        for (URL url : urlSet.getUrls()) {
            if (url.getProtocol().equals("jar")) {
                try {
                    String path = url.getPath();
                    if (path.endsWith("!/")) {
                        path = path.substring(0, path.length() - 2);
                    }
                    url = new URL(path);
                }
                catch (MalformedURLException e) {
                    DeploymentLoader.logger.warning("JSP tag library location bad: " + url.toExternalForm(), e);
                    continue;
                }
            }
            if (!url.getProtocol().equals("file")) continue;
            File file = URLs.toFile(url);
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                DeploymentLoader.logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
                continue;
            }
            tldUrls.addAll(TldScanner.scanForTagLibs(file));
        }
        return tldUrls;
    }

    public static Set<URL> scanWarForTagLibs(File war) {
        HashSet<URL> urls = new HashSet<URL>();
        File webInfDir = new File(war, "WEB-INF");
        if (!webInfDir.isDirectory()) {
            return urls;
        }
        LinkedList<File> files = new LinkedList<File>();
        File[] list = webInfDir.listFiles();
        if (list != null) {
            for (File file : list) {
                if ("lib".equals(file.getName()) || "classes".equals(file.getName())) continue;
                files.add(file);
            }
        }
        if (files.isEmpty()) {
            return urls;
        }
        while (!files.isEmpty()) {
            File file = (File)files.removeFirst();
            if (file.isDirectory()) {
                File[] a = file.listFiles();
                if (a == null) continue;
                files.addAll(Arrays.asList(a));
                continue;
            }
            if (!file.getName().endsWith(".tld")) continue;
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
                urls.add(file.toURI().toURL());
            }
            catch (IOException e) {
                DeploymentLoader.logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
            }
        }
        return urls;
    }

    public static Set<URL> scanForTagLibs(File file) {
        HashSet<URL> tldLocations = new HashSet<URL>();
        try {
            String location = file.toURI().toURL().toExternalForm();
            if (location.endsWith(".jar")) {
                Set<URL> urls = TldScanner.scanJarForTagLibs(file);
                tldLocations.addAll(urls);
            } else if (file.getName().endsWith(".tld")) {
                URL url = file.toURI().toURL();
                tldLocations.add(url);
            }
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning for JSP tag libraries: " + file.getAbsolutePath(), e);
        }
        return tldLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<URL> scanJarForTagLibs(File file) {
        HashSet<URL> urls = new HashSet<URL>();
        if (!file.isFile()) {
            return urls;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            URL jarFileUrl = new URL("jar", "", -1, file.toURI().toURL().toExternalForm() + "!/");
            for (JarEntry entry : Collections.list(jarFile.entries())) {
                String name = entry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                URL url = new URL(jarFileUrl, name);
                urls.add(url);
            }
        }
        catch (IOException e) {
            DeploymentLoader.logger.warning("Error scanning jar for JSP tag libraries: " + file.getAbsolutePath(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return urls;
    }
}

