/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendResult;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.FutureToSendHandler;
import org.apache.tomcat.websocket.MessageHandlerResult;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WrappedMessageHandler;
import org.apache.tomcat.websocket.WsRemoteEndpointAsync;
import org.apache.tomcat.websocket.WsRemoteEndpointBasic;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.WsWebSocketContainer;

public class WsSession
implements Session {
    private static final byte[] ELLIPSIS_BYTES = "\u2026".getBytes(StandardCharsets.UTF_8);
    private static final int ELLIPSIS_BYTES_LEN = ELLIPSIS_BYTES.length;
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private static AtomicLong ids = new AtomicLong(0L);
    private final Log log = LogFactory.getLog(WsSession.class);
    private final Endpoint localEndpoint;
    private final WsRemoteEndpointImplBase wsRemoteEndpoint;
    private final RemoteEndpoint.Async remoteEndpointAsync;
    private final RemoteEndpoint.Basic remoteEndpointBasic;
    private final ClassLoader applicationClassLoader;
    private final WsWebSocketContainer webSocketContainer;
    private final URI requestUri;
    private final Map<String, List<String>> requestParameterMap;
    private final String queryString;
    private final Principal userPrincipal;
    private final EndpointConfig endpointConfig;
    private final String subProtocol;
    private final Map<String, String> pathParameters;
    private final boolean secure;
    private final String httpSessionId;
    private final String id;
    private MessageHandler textMessageHandler = null;
    private MessageHandler binaryMessageHandler = null;
    private MessageHandler.Whole<PongMessage> pongMessageHandler = null;
    private volatile State state = State.OPEN;
    private final Object stateLock = new Object();
    private final Map<String, Object> userProperties = new ConcurrentHashMap<String, Object>();
    private volatile int maxBinaryMessageBufferSize = 8192;
    private volatile int maxTextMessageBufferSize = 8192;
    private volatile long maxIdleTimeout = 0L;
    private volatile long lastActive = System.currentTimeMillis();
    private Map<FutureToSendHandler, FutureToSendHandler> futures = new ConcurrentHashMap<FutureToSendHandler, FutureToSendHandler>();

    public WsSession(Endpoint localEndpoint, WsRemoteEndpointImplBase wsRemoteEndpoint, WsWebSocketContainer wsWebSocketContainer, URI requestUri, Map<String, List<String>> requestParameterMap, String queryString, Principal userPrincipal, String httpSessionId, String subProtocol, Map<String, String> pathParameters, boolean secure, EndpointConfig endpointConfig) throws DeploymentException {
        this.localEndpoint = localEndpoint;
        this.wsRemoteEndpoint = wsRemoteEndpoint;
        this.wsRemoteEndpoint.setSession(this);
        this.remoteEndpointAsync = new WsRemoteEndpointAsync(wsRemoteEndpoint);
        this.remoteEndpointBasic = new WsRemoteEndpointBasic(wsRemoteEndpoint);
        this.webSocketContainer = wsWebSocketContainer;
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
        wsRemoteEndpoint.setSendTimeout(wsWebSocketContainer.getDefaultAsyncSendTimeout());
        this.maxBinaryMessageBufferSize = this.webSocketContainer.getDefaultMaxBinaryMessageBufferSize();
        this.maxTextMessageBufferSize = this.webSocketContainer.getDefaultMaxTextMessageBufferSize();
        this.maxIdleTimeout = this.webSocketContainer.getDefaultMaxSessionIdleTimeout();
        this.requestUri = requestUri;
        this.requestParameterMap = requestParameterMap == null ? Collections.emptyMap() : requestParameterMap;
        this.queryString = queryString;
        this.userPrincipal = userPrincipal;
        this.httpSessionId = httpSessionId;
        this.subProtocol = subProtocol == null ? "" : subProtocol;
        this.pathParameters = pathParameters;
        this.secure = secure;
        this.wsRemoteEndpoint.setEncoders(endpointConfig);
        this.endpointConfig = endpointConfig;
        this.userProperties.putAll(endpointConfig.getUserProperties());
        this.id = Long.toHexString(ids.getAndIncrement());
    }

    public WebSocketContainer getContainer() {
        this.checkState();
        return this.webSocketContainer;
    }

    public void addMessageHandler(MessageHandler listener) {
        this.checkState();
        Set<MessageHandlerResult> mhResults = Util.getMessageHandlers(listener, this.endpointConfig, this);
        block5: for (MessageHandlerResult mhResult : mhResults) {
            switch (mhResult.getType()) {
                case TEXT: {
                    if (this.textMessageHandler != null) {
                        throw new IllegalStateException(sm.getString("wsSession.duplicateHandlerText"));
                    }
                    this.textMessageHandler = mhResult.getHandler();
                    continue block5;
                }
                case BINARY: {
                    if (this.binaryMessageHandler != null) {
                        throw new IllegalStateException(sm.getString("wsSession.duplicateHandlerBinary"));
                    }
                    this.binaryMessageHandler = mhResult.getHandler();
                    continue block5;
                }
                case PONG: {
                    if (this.pongMessageHandler != null) {
                        throw new IllegalStateException(sm.getString("wsSession.duplicateHandlerPong"));
                    }
                    MessageHandler handler = mhResult.getHandler();
                    if (handler instanceof MessageHandler.Whole) {
                        this.pongMessageHandler = (MessageHandler.Whole)handler;
                        continue block5;
                    }
                    throw new IllegalStateException(sm.getString("wsSession.invalidHandlerTypePong"));
                }
            }
            throw new IllegalArgumentException(sm.getString("wsSession.unknownHandlerType", new Object[]{listener, mhResult.getType()}));
        }
    }

    public Set<MessageHandler> getMessageHandlers() {
        this.checkState();
        HashSet<MessageHandler> result = new HashSet<MessageHandler>();
        if (this.binaryMessageHandler != null) {
            result.add(this.binaryMessageHandler);
        }
        if (this.textMessageHandler != null) {
            result.add(this.textMessageHandler);
        }
        if (this.pongMessageHandler != null) {
            result.add((MessageHandler)this.pongMessageHandler);
        }
        return result;
    }

    public void removeMessageHandler(MessageHandler listener) {
        this.checkState();
        if (listener == null) {
            return;
        }
        MessageHandler wrapped = null;
        if (listener instanceof WrappedMessageHandler) {
            wrapped = ((WrappedMessageHandler)listener).getWrappedHandler();
        }
        if (wrapped == null) {
            wrapped = listener;
        }
        boolean removed = false;
        if (wrapped.equals(this.textMessageHandler) || listener.equals(this.textMessageHandler)) {
            this.textMessageHandler = null;
            removed = true;
        }
        if (listener.equals(this.binaryMessageHandler) || listener.equals(this.binaryMessageHandler)) {
            this.binaryMessageHandler = null;
            removed = true;
        }
        if (listener.equals(this.pongMessageHandler) || listener.equals(this.pongMessageHandler)) {
            this.pongMessageHandler = null;
            removed = true;
        }
        if (!removed) {
            throw new IllegalStateException(sm.getString("wsSession.removeHandlerFailed", new Object[]{listener}));
        }
    }

    public String getProtocolVersion() {
        this.checkState();
        return "13";
    }

    public String getNegotiatedSubprotocol() {
        this.checkState();
        return this.subProtocol;
    }

    public List<Extension> getNegotiatedExtensions() {
        this.checkState();
        return Collections.emptyList();
    }

    public boolean isSecure() {
        this.checkState();
        return this.secure;
    }

    public boolean isOpen() {
        return this.state == State.OPEN;
    }

    public long getMaxIdleTimeout() {
        this.checkState();
        return this.maxIdleTimeout;
    }

    public void setMaxIdleTimeout(long timeout) {
        this.checkState();
        this.maxIdleTimeout = timeout;
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.checkState();
        this.maxBinaryMessageBufferSize = max;
    }

    public int getMaxBinaryMessageBufferSize() {
        this.checkState();
        return this.maxBinaryMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.checkState();
        this.maxTextMessageBufferSize = max;
    }

    public int getMaxTextMessageBufferSize() {
        this.checkState();
        return this.maxTextMessageBufferSize;
    }

    public Set<Session> getOpenSessions() {
        this.checkState();
        return this.webSocketContainer.getOpenSessions(this.localEndpoint.getClass());
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        this.checkState();
        return this.remoteEndpointAsync;
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        this.checkState();
        return this.remoteEndpointBasic;
    }

    public void close() throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, ""));
    }

    public void close(CloseReason closeReason) throws IOException {
        this.doClose(closeReason, closeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(CloseReason closeReasonMessage, CloseReason closeReasonLocal) {
        if (this.state != State.OPEN) {
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.OPEN) {
                return;
            }
            this.state = State.CLOSING;
            this.sendCloseMessage(closeReasonMessage);
            this.fireEndpointOnClose(closeReasonLocal);
            this.state = State.CLOSED;
        }
        IOException ioe = new IOException(sm.getString("wsSession.messageFailed"));
        SendResult sr = new SendResult((Throwable)ioe);
        for (FutureToSendHandler f2sh : this.futures.keySet()) {
            f2sh.onResult(sr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(CloseReason closeReason) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.OPEN) {
                this.sendCloseMessage(closeReason);
                this.fireEndpointOnClose(closeReason);
                this.state = State.CLOSED;
            }
            this.wsRemoteEndpoint.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEndpointOnClose(CloseReason closeReason) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.localEndpoint.onClose((Session)this, closeReason);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.localEndpoint.onError((Session)this, throwable);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseMessage(CloseReason closeReason) {
        ByteBuffer msg = ByteBuffer.allocate(125);
        CloseReason.CloseCode closeCode = closeReason.getCloseCode();
        if (closeCode == CloseReason.CloseCodes.CLOSED_ABNORMALLY) {
            msg.putShort((short)CloseReason.CloseCodes.PROTOCOL_ERROR.getCode());
        } else {
            msg.putShort((short)closeCode.getCode());
        }
        String reason = closeReason.getReasonPhrase();
        if (reason != null && reason.length() > 0) {
            WsSession.appendCloseReasonWithTruncation(msg, reason);
        }
        msg.flip();
        try {
            this.wsRemoteEndpoint.startMessageBlock((byte)8, msg, true);
        }
        catch (IOException ioe) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("wsSession.sendCloseFail"), (Throwable)ioe);
            }
            this.wsRemoteEndpoint.close();
            if (closeCode != CloseReason.CloseCodes.CLOSED_ABNORMALLY) {
                this.localEndpoint.onError((Session)this, (Throwable)ioe);
            }
        }
        finally {
            this.webSocketContainer.unregisterSession(this.localEndpoint, this);
        }
    }

    protected static void appendCloseReasonWithTruncation(ByteBuffer msg, String reason) {
        byte[] reasonBytes = reason.getBytes(StandardCharsets.UTF_8);
        if (reasonBytes.length <= 123) {
            msg.put(reasonBytes);
        } else {
            int pos = 0;
            byte[] bytesNext = reason.substring(pos, pos + 1).getBytes(StandardCharsets.UTF_8);
            for (int remaining = 123 - ELLIPSIS_BYTES_LEN; remaining >= bytesNext.length; remaining -= bytesNext.length) {
                msg.put(bytesNext);
                bytesNext = reason.substring(++pos, pos + 1).getBytes(StandardCharsets.UTF_8);
            }
            msg.put(ELLIPSIS_BYTES);
        }
    }

    protected void registerFuture(FutureToSendHandler f2sh) {
        this.futures.put(f2sh, f2sh);
    }

    protected void unregisterFuture(FutureToSendHandler f2sh) {
        this.futures.remove(f2sh);
    }

    public URI getRequestURI() {
        this.checkState();
        return this.requestUri;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        this.checkState();
        return this.requestParameterMap;
    }

    public String getQueryString() {
        this.checkState();
        return this.queryString;
    }

    public Principal getUserPrincipal() {
        this.checkState();
        return this.userPrincipal;
    }

    public Map<String, String> getPathParameters() {
        this.checkState();
        return this.pathParameters;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getUserProperties() {
        this.checkState();
        return this.userProperties;
    }

    public Endpoint getLocal() {
        return this.localEndpoint;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    protected MessageHandler getTextMessageHandler() {
        return this.textMessageHandler;
    }

    protected MessageHandler getBinaryMessageHandler() {
        return this.binaryMessageHandler;
    }

    protected MessageHandler.Whole<PongMessage> getPongMessageHandler() {
        return this.pongMessageHandler;
    }

    protected void updateLastActive() {
        this.lastActive = System.currentTimeMillis();
    }

    protected void checkExpiration() {
        long timeout = this.maxIdleTimeout;
        if (timeout < 1L) {
            return;
        }
        if (System.currentTimeMillis() - this.lastActive > timeout) {
            String msg = sm.getString("wsSession.timeout");
            this.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, msg), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, msg));
        }
    }

    private void checkState() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException(sm.getString("wsSession.closed"));
        }
    }

    private static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

