/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.jmx.MBean;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurableClasspathArchive;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;

public class MBeanDeployer
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, MBeanDeployer.class);

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        String name;
        logger.debug("looking for annotated MBeans in " + appModule.getModuleId());
        ArrayList<String> done = new ArrayList<String>();
        ClassLoader cl = appModule.getClassLoader();
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        ArrayList mbeanClasses = new ArrayList(2);
        mbeanClasses.add(MBean.class);
        try {
            mbeanClasses.add(cl.loadClass("javax.management.MBean"));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            if (ejbModule.getFinder() == null) continue;
            for (Class clazz : mbeanClasses) {
                for (Annotated clazz2 : ejbModule.getFinder().findMetaAnnotatedClasses(clazz)) {
                    Class realClass = (Class)clazz2.get();
                    name = realClass.getName();
                    if (done.contains(name)) continue;
                    ejbModule.getMbeans().add(name);
                    done.add(name);
                }
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            if (clientModule.getFinder() == null) continue;
            for (Class clazz : mbeanClasses) {
                for (Annotated clazz2 : clientModule.getFinder().findMetaAnnotatedClasses(clazz)) {
                    String name2 = ((Class)clazz2.get()).getName();
                    if (done.contains(name2)) continue;
                    clientModule.getMbeans().add(name2);
                }
            }
        }
        List<URL> libs = appModule.getAdditionalLibraries();
        Iterator<URL> it = libs.iterator();
        while (it.hasNext()) {
            URL url = it.next();
            for (String string : done) {
                if (!url.getFile().equals(string)) continue;
                it.remove();
            }
        }
        if (libs.size() > 0) {
            AnnotationFinder finder = new AnnotationFinder((Archive)new ConfigurableClasspathArchive(appModule.getClassLoader(), true, libs));
            for (Class clazz : mbeanClasses) {
                for (Annotated clazz3 : finder.findMetaAnnotatedClasses(clazz)) {
                    name = ((Class)clazz3.get()).getName();
                    if (done.contains(name)) continue;
                    appModule.getAdditionalLibMbeans().add(name);
                }
            }
        }
        return appModule;
    }
}

