/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.util.common.Assert;
import org.eclipse.virgo.util.common.GraphNode;
import org.eclipse.virgo.util.common.SynchronizedList;

class ThreadSafeGraphNode<V>
implements GraphNode<V> {
    private final V value;
    private final Object monitor;
    private static final Object tieMonitor = new Object();
    private final List<ThreadSafeGraphNode<V>> children = new ArrayList<ThreadSafeGraphNode<V>>();
    private final List<ThreadSafeGraphNode<V>> parents = new ArrayList<ThreadSafeGraphNode<V>>();

    ThreadSafeGraphNode(V value, Object monitor) {
        this.value = value;
        this.monitor = monitor;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphNode<V>> getChildren() {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedList<GraphNode<V>>(this.children, this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(GraphNode<V> child) {
        ThreadSafeGraphNode<V> concreteChild = this.assertTypeAndMembership(child);
        Object object = this.monitor;
        synchronized (object) {
            Assert.isFalse(this.children.contains(child), "The node '%s' is already a child of '%s'", child, this);
            this.doCycleCheck(concreteChild);
            this.children.add(concreteChild);
            concreteChild.parents.add(this);
        }
    }

    private ThreadSafeGraphNode<V> assertTypeAndMembership(GraphNode<V> child) {
        Assert.isInstanceOf(ThreadSafeGraphNode.class, child, "A child must be of type %s.", this.getClass().getName());
        ThreadSafeGraphNode concreteChild = (ThreadSafeGraphNode)child;
        Assert.isTrue(this.belongsToSameGraph(concreteChild), "The node '%s' does not belong to the same graph as '%s'", concreteChild, this);
        return concreteChild;
    }

    private boolean belongsToSameGraph(ThreadSafeGraphNode<V> other) {
        return this.monitor == other.monitor;
    }

    protected boolean belongsToSameGraph(Object monitor) {
        return this.monitor == monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCycleCheck(GraphNode<V> child) {
        Object object = this.monitor;
        synchronized (object) {
            DescendentChecker descendentChecker = new DescendentChecker(this);
            child.visit(descendentChecker);
            Assert.isFalse(descendentChecker.isDescendent(), "Can't add '%s'. This node is a descendent of the new child.", child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChild(GraphNode<V> child) {
        ThreadSafeGraphNode<V> concreteChild = this.assertTypeAndMembership(child);
        Object object = this.monitor;
        synchronized (object) {
            boolean removed = this.children.remove(concreteChild);
            if (removed) {
                this.removeParent(child, this);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeParent(GraphNode<V> child, GraphNode<V> parent) {
        Object object = this.monitor;
        synchronized (object) {
            if (child instanceof ThreadSafeGraphNode) {
                ThreadSafeGraphNode concreteChild = (ThreadSafeGraphNode)child;
                concreteChild.parents.remove(parent);
            }
        }
    }

    @Override
    public void visit(GraphNode.DirectedAcyclicGraphVisitor<V> visitor) {
        this.visitInternal(visitor, new HashMap<ThreadSafeGraphNode<V>, Boolean>());
    }

    private void visitInternal(GraphNode.DirectedAcyclicGraphVisitor<V> visitor, Map<ThreadSafeGraphNode<V>, Boolean> visitedFlags) {
        if (visitedFlags.containsKey(this)) {
            return;
        }
        visitedFlags.put(this, Boolean.TRUE);
        if (visitor.visit(this)) {
            int i = 0;
            while (i < this.numChildren()) {
                ThreadSafeGraphNode<V> nextChild = this.getChild(i);
                if (nextChild == null) break;
                super.visitInternal(visitor, visitedFlags);
                ++i;
            }
        }
    }

    @Override
    public <E extends Exception> void visit(GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<V, E> visitor) throws E {
        this.visitInternal(visitor, new HashMap<ThreadSafeGraphNode<V>, Boolean>());
    }

    private <E extends Exception> void visitInternal(GraphNode.ExceptionThrowingDirectedAcyclicGraphVisitor<V, E> visitor, Map<ThreadSafeGraphNode<V>, Boolean> visitedFlags) throws E {
        if (visitedFlags.containsKey(this)) {
            return;
        }
        visitedFlags.put(this, Boolean.TRUE);
        if (visitor.visit(this)) {
            int i = 0;
            while (i < this.numChildren()) {
                ThreadSafeGraphNode<V> nextChild = this.getChild(i);
                if (nextChild == null) break;
                super.visitInternal(visitor, visitedFlags);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadSafeGraphNode<V> getChild(int i) {
        Object object = this.monitor;
        synchronized (object) {
            try {
                return this.children.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numChildren() {
        Object object = this.monitor;
        synchronized (object) {
            return this.children.size();
        }
    }

    @Override
    public int size() {
        SizeVisitor sizeVisitor = new SizeVisitor();
        this.visit(sizeVisitor);
        return sizeVisitor.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.monitor;
        synchronized (object) {
            int result = 1;
            result = 31 * result + this.children.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        int otherHash;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreadSafeGraphNode other = (ThreadSafeGraphNode)obj;
        int thisHash = System.identityHashCode(this);
        if (thisHash < (otherHash = System.identityHashCode(other))) {
            Object object = this.monitor;
            synchronized (object) {
                Object object2 = other.monitor;
                synchronized (object2) {
                    if (this.children.equals(other.children)) return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                    return false;
                }
            }
        }
        if (thisHash > otherHash) {
            Object object = other.monitor;
            synchronized (object) {
                Object object3 = this.monitor;
                synchronized (object3) {
                    if (this.children.equals(other.children)) return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                    return false;
                }
            }
        }
        Object object = tieMonitor;
        synchronized (object) {
            Object object4 = this.monitor;
            synchronized (object4) {
                Object object5 = other.monitor;
                synchronized (object5) {
                    if (this.children.equals(other.children)) return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.value != null ? this.value : "null").append("<");
        Object object = this.monitor;
        synchronized (object) {
            boolean first = true;
            for (ThreadSafeGraphNode<V> child : this.children) {
                if (!first) {
                    result.append(", ");
                }
                result.append(child.toString());
                first = false;
            }
        }
        result.append(">");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphNode<V>> getParents() {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedList<GraphNode<V>>(this.parents, this.monitor);
        }
    }

    @Override
    public boolean isRootNode() {
        return this.parents.isEmpty();
    }

    private static class DescendentChecker<V>
    implements GraphNode.DirectedAcyclicGraphVisitor<V> {
        private final ThreadSafeGraphNode<V> prospect;
        private boolean descendent = false;

        public DescendentChecker(ThreadSafeGraphNode<V> prospect) {
            this.prospect = prospect;
        }

        @Override
        public boolean visit(GraphNode<V> node) {
            if (this.descendent) {
                return false;
            }
            if (this.prospect == node) {
                this.descendent = true;
                return false;
            }
            return true;
        }

        public boolean isDescendent() {
            return this.descendent;
        }
    }

    private static class SizeVisitor<V>
    implements GraphNode.DirectedAcyclicGraphVisitor<V> {
        private int size;

        private SizeVisitor() {
        }

        @Override
        public boolean visit(GraphNode<V> dag) {
            ++this.size;
            return true;
        }

        public int getSize() {
            return this.size;
        }
    }
}

