/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.SystemPropertyUtils;

public class ResourceArrayPropertyEditor
extends PropertyEditorSupport {
    private final ResourcePatternResolver resourcePatternResolver;

    public ResourceArrayPropertyEditor() {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    public void setAsText(String text) {
        String pattern = this.resolvePath(text).trim();
        try {
            this.setValue(this.resourcePatternResolver.getResources(pattern));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
        }
    }

    public void setValue(Object value) throws IllegalArgumentException {
        if (value instanceof Collection || value instanceof Object[] && !(value instanceof Resource[])) {
            Collection input = value instanceof Collection ? (Collection)value : (Collection)Arrays.asList((Object[])value);
            ArrayList<Resource> merged = new ArrayList<Resource>();
            for (Object element : input) {
                if (element instanceof String) {
                    String pattern = this.resolvePath((String)element).trim();
                    try {
                        Resource[] resources;
                        Resource[] resourceArray = resources = this.resourcePatternResolver.getResources(pattern);
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Resource resource = resourceArray[n2];
                            if (!merged.contains(resource)) {
                                merged.add(resource);
                            }
                            ++n2;
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
                    }
                }
                if (element instanceof Resource) {
                    Resource resource = (Resource)element;
                    if (merged.contains(resource)) continue;
                    merged.add(resource);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + element + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            super.setValue(merged.toArray(new Resource[merged.size()]));
        } else {
            super.setValue(value);
        }
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }
}

